/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.loginredirect;

import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.httpd.AllRequestFilter;
import com.google.gerrit.httpd.GitOverHttpServlet;
import com.google.gerrit.httpd.WebSession;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class LoginRedirectFilter
extends AllRequestFilter {
    @Inject
    private DynamicItem<WebSession> sessionProvider;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        String path = httpReq.getRequestURI();
        if (!httpReq.getContextPath().isEmpty()) {
            path = path.substring(httpReq.getContextPath().length());
        }
        if (path.startsWith("/a/") || path.equals("/config/server/healthcheck~status") || path.startsWith("/Documentation/") || path.equals("/favicon.ico") || path.equals("/login") || path.startsWith("/login/") || path.equals("/oauth") || path.startsWith("/plugins/") && !path.startsWith("/plugins/gitiles/") || path.equals("/ssh_info") || path.startsWith("/static/") || path.startsWith("/tools/hooks/") || path.endsWith("/info/lfs/objects/batch") || Pattern.compile(GitOverHttpServlet.URL_REGEX).matcher(path).matches() || ((WebSession)this.sessionProvider.get()).isSignedIn()) {
            chain.doFilter(request, response);
        } else {
            ((HttpServletResponse)response).sendRedirect(LoginRedirectFilter.getLoginRedirectUrl(httpReq));
        }
    }

    private static String getLoginRedirectUrl(HttpServletRequest req) {
        String queryString;
        String contextPath = req.getContextPath();
        String loginUrl = contextPath + "/login/";
        String token = req.getRequestURI();
        if (!contextPath.isEmpty()) {
            token = token.substring(contextPath.length());
        }
        if ((queryString = req.getQueryString()) != null && !queryString.isEmpty()) {
            token = token.concat("?" + queryString);
        }
        return loginUrl + Url.encode((String)token);
    }
}

