/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.serialization;

import com.google.common.io.BaseEncoding;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.squareup.javapoet.CodeBlock;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

public final class ProtoSerialization {
    private static final AnnotationValueVisitor<String, Void> STRING_VALUE = new SimpleAnnotationValueVisitor8<String, Void>(){

        @Override
        public String visitString(String s, Void ignored) {
            return s;
        }

        @Override
        protected String defaultAction(Object o, Void ignored) {
            throw new IllegalArgumentException(o + " is not a String");
        }
    };

    public static CodeBlock toAnnotationValue(Message message) {
        return CodeBlock.of((String)"$S", (Object[])new Object[]{BaseEncoding.base64().encode(message.toByteArray())});
    }

    public static <T extends Message> T fromAnnotationValue(AnnotationValue value, T defaultInstance) {
        Message message;
        byte[] bytes = BaseEncoding.base64().decode((CharSequence)value.accept(STRING_VALUE, null));
        try {
            message = (Message)defaultInstance.getParserForType().parseFrom(bytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new InconsistentSerializedProtoException(e);
        }
        Message t = message;
        return (T)t;
    }

    public static final class InconsistentSerializedProtoException
    extends RuntimeException {
        InconsistentSerializedProtoException(Throwable cause) {
            super(cause);
        }
    }
}

