/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.MultibindingFactoryCreationExpression;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.SourceFiles;
import dagger.model.DependencyRequest;
import dagger.producers.Produced;
import java.util.Optional;

final class SetFactoryCreationExpression
extends MultibindingFactoryCreationExpression {
    private final ComponentImplementation componentImplementation;
    private final BindingGraph graph;
    private final ContributionBinding binding;

    SetFactoryCreationExpression(ContributionBinding binding, ComponentImplementation componentImplementation, ComponentBindingExpressions componentBindingExpressions, BindingGraph graph) {
        super(binding, componentImplementation, componentBindingExpressions);
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation);
        this.graph = (BindingGraph)Preconditions.checkNotNull((Object)graph);
    }

    @Override
    public CodeBlock creationExpression() {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.", new Object[]{SourceFiles.setFactoryClassName(this.binding)});
        if (!this.useRawType()) {
            SetType setType = SetType.from(this.binding.key());
            builder.add("<$T>", new Object[]{setType.elementsAreTypeOf(Produced.class) ? setType.unwrappedElementType(Produced.class) : setType.elementType()});
        }
        int individualProviders = 0;
        int setProviders = 0;
        CodeBlock.Builder builderMethodCalls = CodeBlock.builder();
        String methodNameSuffix = this.binding.bindingType().equals((Object)BindingType.PROVISION) ? "Provider" : "Producer";
        Optional<CodeBlock> superContributions = this.superContributions();
        if (superContributions.isPresent()) {
            builderMethodCalls.add(".addCollection$N($L)", new Object[]{methodNameSuffix, superContributions.get()});
            ++setProviders;
        }
        for (DependencyRequest dependency : this.dependenciesToImplement()) {
            String methodNamePrefix;
            ContributionType contributionType = ((ResolvedBindings)this.graph.contributionBindings().get((Object)dependency.key())).contributionType();
            switch (contributionType) {
                case SET: {
                    ++individualProviders;
                    methodNamePrefix = "add";
                    break;
                }
                case SET_VALUES: {
                    ++setProviders;
                    methodNamePrefix = "addCollection";
                    break;
                }
                default: {
                    throw new AssertionError((Object)(dependency + " is not a set multibinding"));
                }
            }
            builderMethodCalls.add(".$N$N($L)", new Object[]{methodNamePrefix, methodNameSuffix, this.multibindingDependencyExpression(dependency)});
        }
        builder.add("builder($L, $L)", new Object[]{individualProviders, setProviders});
        builder.add(builderMethodCalls.build());
        this.componentImplementation.registerImplementedMultibinding(this.binding, this.bindingRequest());
        return builder.add(".build()", new Object[0]).build();
    }
}

