/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;

final class Optionals {
    static <C extends Comparable<C>> Comparator<Optional<C>> optionalComparator() {
        return Comparator.comparing(optional -> optional.isPresent()).thenComparing(Optional::get);
    }

    static <T> Comparator<Optional<T>> emptiesLast(Comparator<? super T> valueComparator) {
        Preconditions.checkNotNull(valueComparator);
        return Comparator.comparing(o -> o.orElse(null), Comparator.nullsLast(valueComparator));
    }

    @SafeVarargs
    static <T> Optional<T> firstPresent(Optional<T> first, Optional<T> second, Optional<T> ... rest) {
        return Lists.asList(first, second, (Object[])rest).stream().filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    static <T> T rootmostValue(T start, Function<T, Optional<T>> nextFunction) {
        T current = start;
        Optional<T> next = nextFunction.apply(start);
        while (next.isPresent()) {
            current = next.get();
            next = nextFunction.apply(current);
        }
        return current;
    }

    private Optionals() {
    }
}

