/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.FrameworkFieldInitializer;
import dagger.internal.codegen.ModifiableBindingMethods;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import java.util.Optional;

abstract class MultibindingFactoryCreationExpression
implements FrameworkFieldInitializer.FrameworkInstanceCreationExpression {
    private final ComponentImplementation componentImplementation;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final ContributionBinding binding;

    MultibindingFactoryCreationExpression(ContributionBinding binding, ComponentImplementation componentImplementation, ComponentBindingExpressions componentBindingExpressions) {
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation);
        this.componentBindingExpressions = (ComponentBindingExpressions)Preconditions.checkNotNull((Object)componentBindingExpressions);
    }

    protected final CodeBlock multibindingDependencyExpression(DependencyRequest dependency) {
        CodeBlock expression = this.componentBindingExpressions.getDependencyExpression(BindingRequest.bindingRequest(dependency.key(), this.binding.frameworkType()), this.componentImplementation.name()).codeBlock();
        return this.useRawType() ? CodeBlocks.cast(expression, this.binding.frameworkType().frameworkClass()) : expression;
    }

    protected final ImmutableSet<DependencyRequest> dependenciesToImplement() {
        ImmutableSet<Key> alreadyImplementedKeys = this.componentImplementation.superclassContributionsMade(this.bindingRequest());
        return this.binding.dependencies().stream().filter(dependency -> !alreadyImplementedKeys.contains((Object)dependency.key())).collect(DaggerStreams.toImmutableSet());
    }

    protected Optional<CodeBlock> superContributions() {
        if (this.dependenciesToImplement().size() == this.binding.dependencies().size()) {
            return Optional.empty();
        }
        ModifiableBindingMethods.ModifiableBindingMethod superMethod = this.componentImplementation.getModifiableBindingMethod(this.bindingRequest()).get();
        return Optional.of(CodeBlock.of((String)"super.$N()", (Object[])new Object[]{superMethod.methodSpec().name}));
    }

    protected final BindingRequest bindingRequest() {
        return BindingRequest.bindingRequest(this.binding.key(), this.binding.frameworkType());
    }

    protected final boolean useRawType() {
        return !this.componentImplementation.isTypeAccessible(this.binding.key().type());
    }

    @Override
    public final boolean useInnerSwitchingProvider() {
        return !this.binding.dependencies().isEmpty();
    }
}

