/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.AnyBindingMethodValidator;
import dagger.internal.codegen.TypeCheckingProcessingStep;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.multibindings.ElementsIntoSet;
import dagger.multibindings.IntoMap;
import dagger.multibindings.IntoSet;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.tools.Diagnostic;

final class MultibindingAnnotationsProcessingStep
extends TypeCheckingProcessingStep<ExecutableElement> {
    private final AnyBindingMethodValidator anyBindingMethodValidator;
    private final Messager messager;

    @Inject
    MultibindingAnnotationsProcessingStep(AnyBindingMethodValidator anyBindingMethodValidator, Messager messager) {
        super(MoreElements::asExecutable);
        this.anyBindingMethodValidator = anyBindingMethodValidator;
        this.messager = messager;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(IntoSet.class, ElementsIntoSet.class, IntoMap.class);
    }

    @Override
    protected void process(ExecutableElement method, ImmutableSet<Class<? extends Annotation>> annotations) {
        if (!this.anyBindingMethodValidator.isBindingMethod(method)) {
            annotations.forEach(annotation -> this.messager.printMessage(Diagnostic.Kind.ERROR, "Multibinding annotations may only be on @Provides, @Produces, or @Binds methods", method, DaggerElements.getAnnotationMirror(method, annotation).get()));
        }
    }
}

