/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.BindingFactory;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DelegateDeclaration;
import dagger.internal.codegen.InaccessibleMapKeyProxyGenerator;
import dagger.internal.codegen.ModuleGenerator;
import dagger.internal.codegen.ModuleValidator;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.TypeCheckingProcessingStep;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProducerModule;
import dagger.producers.Produces;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class ModuleProcessingStep
extends TypeCheckingProcessingStep<TypeElement> {
    private final Messager messager;
    private final ModuleValidator moduleValidator;
    private final BindingFactory bindingFactory;
    private final SourceFileGenerator<ProvisionBinding> factoryGenerator;
    private final SourceFileGenerator<ProductionBinding> producerFactoryGenerator;
    private final SourceFileGenerator<TypeElement> moduleConstructorProxyGenerator;
    private final InaccessibleMapKeyProxyGenerator inaccessibleMapKeyProxyGenerator;
    private final DelegateDeclaration.Factory delegateDeclarationFactory;
    private final Set<TypeElement> processedModuleElements = Sets.newLinkedHashSet();

    @Inject
    ModuleProcessingStep(Messager messager, ModuleValidator moduleValidator, BindingFactory bindingFactory, SourceFileGenerator<ProvisionBinding> factoryGenerator, SourceFileGenerator<ProductionBinding> producerFactoryGenerator, @ModuleGenerator SourceFileGenerator<TypeElement> moduleConstructorProxyGenerator, InaccessibleMapKeyProxyGenerator inaccessibleMapKeyProxyGenerator, DelegateDeclaration.Factory delegateDeclarationFactory) {
        super(MoreElements::asType);
        this.messager = messager;
        this.moduleValidator = moduleValidator;
        this.bindingFactory = bindingFactory;
        this.factoryGenerator = factoryGenerator;
        this.producerFactoryGenerator = producerFactoryGenerator;
        this.moduleConstructorProxyGenerator = moduleConstructorProxyGenerator;
        this.inaccessibleMapKeyProxyGenerator = inaccessibleMapKeyProxyGenerator;
        this.delegateDeclarationFactory = delegateDeclarationFactory;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(Module.class, ProducerModule.class);
    }

    @Override
    public ImmutableSet<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        List<TypeElement> modules = ElementFilter.typesIn(elementsByAnnotation.values());
        this.moduleValidator.addKnownModules(modules);
        return super.process(elementsByAnnotation);
    }

    @Override
    protected void process(TypeElement module, ImmutableSet<Class<? extends Annotation>> annotations) {
        if (this.processedModuleElements.contains(module)) {
            return;
        }
        ValidationReport<TypeElement> report = this.moduleValidator.validate(module);
        report.printMessagesTo(this.messager);
        if (report.isClean()) {
            for (ExecutableElement method : ElementFilter.methodsIn(module.getEnclosedElements())) {
                if (MoreElements.isAnnotationPresent(method, Provides.class)) {
                    this.generate(this.factoryGenerator, this.bindingFactory.providesMethodBinding(method, module));
                    continue;
                }
                if (MoreElements.isAnnotationPresent(method, Produces.class)) {
                    this.generate(this.producerFactoryGenerator, this.bindingFactory.producesMethodBinding(method, module));
                    continue;
                }
                if (!MoreElements.isAnnotationPresent(method, Binds.class)) continue;
                this.inaccessibleMapKeyProxyGenerator.generate(this.bindsMethodBinding(module, method), this.messager);
            }
            this.moduleConstructorProxyGenerator.generate(module, this.messager);
        }
        this.processedModuleElements.add(module);
    }

    private <B extends ContributionBinding> void generate(SourceFileGenerator<B> generator, B binding) {
        generator.generate(binding, this.messager);
        this.inaccessibleMapKeyProxyGenerator.generate(binding, this.messager);
    }

    private ContributionBinding bindsMethodBinding(TypeElement module, ExecutableElement method) {
        return this.bindingFactory.unresolvedDelegateBinding(this.delegateDeclarationFactory.create(method, module));
    }
}

