/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MultibindingFactoryCreationExpression;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.model.DependencyRequest;
import dagger.producers.Produced;
import dagger.producers.Producer;
import javax.inject.Provider;
import javax.lang.model.type.TypeMirror;

final class MapFactoryCreationExpression
extends MultibindingFactoryCreationExpression {
    private final ComponentImplementation componentImplementation;
    private final BindingGraph graph;
    private final ContributionBinding binding;
    private final DaggerElements elements;

    MapFactoryCreationExpression(ContributionBinding binding, ComponentImplementation componentImplementation, ComponentBindingExpressions componentBindingExpressions, BindingGraph graph, DaggerElements elements) {
        super(binding, componentImplementation, componentBindingExpressions);
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation);
        this.graph = (BindingGraph)Preconditions.checkNotNull((Object)graph);
        this.elements = (DaggerElements)Preconditions.checkNotNull((Object)elements);
    }

    @Override
    public CodeBlock creationExpression() {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.", new Object[]{SourceFiles.mapFactoryClassName(this.binding)});
        if (!this.useRawType()) {
            MapType mapType = MapType.from(this.binding.key().type());
            TypeMirror valueType = mapType.valueType();
            for (Class frameworkClass : ImmutableSet.of(Provider.class, Producer.class, Produced.class)) {
                if (!mapType.valuesAreTypeOf(frameworkClass)) continue;
                valueType = mapType.unwrappedValueType(frameworkClass);
                break;
            }
            builder.add("<$T, $T>", new Object[]{mapType.keyType(), valueType});
        }
        builder.add("builder($L)", new Object[]{this.binding.dependencies().size()});
        this.superContributions().ifPresent(superContributions -> builder.add(".putAll($L)", new Object[]{superContributions}));
        for (DependencyRequest dependency : this.dependenciesToImplement()) {
            ContributionBinding contributionBinding = ((ResolvedBindings)this.graph.contributionBindings().get((Object)dependency.key())).contributionBinding();
            builder.add(".put($L, $L)", new Object[]{MapKeys.getMapKeyExpression(contributionBinding, this.componentImplementation.name(), this.elements), this.multibindingDependencyExpression(dependency)});
        }
        builder.add(".build()", new Object[0]);
        this.componentImplementation.registerImplementedMultibinding(this.binding, this.bindingRequest());
        return builder.build();
    }
}

