/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.DependencyRequestFactory;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor8;

final class InjectionSiteFactory {
    private final ElementVisitor<Optional<MembersInjectionBinding.InjectionSite>, DeclaredType> injectionSiteVisitor = new ElementKindVisitor8<Optional<MembersInjectionBinding.InjectionSite>, DeclaredType>(Optional.empty()){

        @Override
        public Optional<MembersInjectionBinding.InjectionSite> visitExecutableAsMethod(ExecutableElement method, DeclaredType type) {
            ExecutableType resolved = MoreTypes.asExecutable(InjectionSiteFactory.this.types.asMemberOf(type, method));
            return Optional.of(MembersInjectionBinding.InjectionSite.method(method, InjectionSiteFactory.this.dependencyRequestFactory.forRequiredResolvedVariables(method.getParameters(), resolved.getParameterTypes())));
        }

        @Override
        public Optional<MembersInjectionBinding.InjectionSite> visitVariableAsField(VariableElement field, DeclaredType type) {
            if (!MoreElements.isAnnotationPresent(field, Inject.class) || field.getModifiers().contains((Object)Modifier.PRIVATE) || field.getModifiers().contains((Object)Modifier.STATIC)) {
                return Optional.empty();
            }
            TypeMirror resolved = InjectionSiteFactory.this.types.asMemberOf(type, field);
            return Optional.of(MembersInjectionBinding.InjectionSite.field(field, InjectionSiteFactory.this.dependencyRequestFactory.forRequiredResolvedVariable(field, resolved)));
        }
    };
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final DependencyRequestFactory dependencyRequestFactory;

    @Inject
    InjectionSiteFactory(DaggerTypes types, DaggerElements elements, DependencyRequestFactory dependencyRequestFactory) {
        this.types = types;
        this.elements = elements;
        this.dependencyRequestFactory = dependencyRequestFactory;
    }

    ImmutableSortedSet<MembersInjectionBinding.InjectionSite> getInjectionSites(DeclaredType declaredType) {
        HashSet<MembersInjectionBinding.InjectionSite> injectionSites = new HashSet<MembersInjectionBinding.InjectionSite>();
        ArrayList<TypeElement> ancestors = new ArrayList<TypeElement>();
        LinkedHashMultimap overriddenMethodMap = LinkedHashMultimap.create();
        Optional<DeclaredType> currentType = Optional.of(declaredType);
        while (currentType.isPresent()) {
            DeclaredType type = currentType.get();
            ancestors.add(MoreElements.asType(type.asElement()));
            for (Element element : type.asElement().getEnclosedElements()) {
                Optional<MembersInjectionBinding.InjectionSite> maybeInjectionSite = this.injectionSiteVisitor.visit(element, type);
                if (!maybeInjectionSite.isPresent()) continue;
                MembersInjectionBinding.InjectionSite injectionSite2 = maybeInjectionSite.get();
                if (this.shouldBeInjected(injectionSite2.element(), (SetMultimap<String, ExecutableElement>)overriddenMethodMap)) {
                    injectionSites.add(injectionSite2);
                }
                if (!injectionSite2.kind().equals((Object)MembersInjectionBinding.InjectionSite.Kind.METHOD)) continue;
                ExecutableElement injectionSiteMethod = MoreElements.asExecutable(injectionSite2.element());
                overriddenMethodMap.put((Object)injectionSiteMethod.getSimpleName().toString(), (Object)injectionSiteMethod);
            }
            currentType = this.types.nonObjectSuperclass(currentType.get());
        }
        return ImmutableSortedSet.copyOf(Comparator.comparing(injectionSite -> ancestors.indexOf(injectionSite.element().getEnclosingElement())).reversed().thenComparing(injectionSite -> injectionSite.element().getKind()).thenComparing(MembersInjectionBinding.InjectionSite::element, DaggerElements.DECLARATION_ORDER), injectionSites);
    }

    private boolean shouldBeInjected(Element injectionSite, SetMultimap<String, ExecutableElement> overriddenMethodMap) {
        if (!MoreElements.isAnnotationPresent(injectionSite, Inject.class) || injectionSite.getModifiers().contains((Object)Modifier.PRIVATE) || injectionSite.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        if (injectionSite.getKind().isField()) {
            return true;
        }
        ExecutableElement injectionSiteMethod = MoreElements.asExecutable(injectionSite);
        TypeElement injectionSiteType = MoreElements.asType(injectionSite.getEnclosingElement());
        for (ExecutableElement method : overriddenMethodMap.get((Object)injectionSiteMethod.getSimpleName().toString())) {
            if (!this.elements.overrides(method, injectionSiteMethod, injectionSiteType)) continue;
            return false;
        }
        return true;
    }
}

