/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.model.Key;
import dagger.model.RequestKind;
import javax.lang.model.SourceVersion;

final class ImmediateFutureBindingExpression
extends BindingExpression {
    private final ComponentBindingExpressions componentBindingExpressions;
    private final DaggerTypes types;
    private final SourceVersion sourceVersion;
    private final Key key;

    ImmediateFutureBindingExpression(ResolvedBindings resolvedBindings, ComponentBindingExpressions componentBindingExpressions, DaggerTypes types, SourceVersion sourceVersion) {
        this.componentBindingExpressions = (ComponentBindingExpressions)Preconditions.checkNotNull((Object)componentBindingExpressions);
        this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
        this.sourceVersion = (SourceVersion)((Object)Preconditions.checkNotNull((Object)((Object)sourceVersion)));
        this.key = resolvedBindings.key();
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        return Expression.create(this.types.wrapType(this.key.type(), ListenableFuture.class), CodeBlock.of((String)"$T.immediateFuture($L)", (Object[])new Object[]{Futures.class, this.instanceExpression(requestingClass)}));
    }

    private CodeBlock instanceExpression(ClassName requestingClass) {
        Expression expression = this.componentBindingExpressions.getDependencyExpression(BindingRequest.bindingRequest(this.key, RequestKind.INSTANCE), requestingClass);
        if (this.sourceVersion.compareTo(SourceVersion.RELEASE_7) <= 0 && !this.types.isSameType(expression.type(), this.key.type())) {
            return CodeBlock.of((String)"($T) $L", (Object[])new Object[]{this.types.accessibleType(this.key.type(), requestingClass), expression.codeBlock()});
        }
        return expression.codeBlock();
    }
}

