/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.ComponentDefinitionType;
import dagger.internal.ConfigureInitializationParameters;
import dagger.internal.ModifiableBinding;
import dagger.internal.ModifiableModule;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentCreatorImplementationFactory;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.ModifiableBindingType;
import dagger.internal.codegen.MoreAnnotationValues;
import dagger.internal.codegen.TypeProtoConverter;
import dagger.internal.codegen.serialization.BindingRequestProto;
import dagger.internal.codegen.serialization.ComponentRequirementProto;
import dagger.internal.codegen.serialization.FrameworkTypeWrapper;
import dagger.internal.codegen.serialization.KeyProto;
import dagger.internal.codegen.serialization.ProtoSerialization;
import dagger.model.Key;
import dagger.model.RequestKind;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class DeserializedComponentImplementationBuilder {
    private final CompilerOptions compilerOptions;
    private final ComponentCreatorImplementationFactory componentCreatorImplementationFactory;
    private final TypeProtoConverter typeProtoConverter;
    private final KeyFactory keyFactory;

    @Inject
    DeserializedComponentImplementationBuilder(CompilerOptions compilerOptions, ComponentCreatorImplementationFactory componentCreatorImplementationFactory, TypeProtoConverter typeProtoConverter, KeyFactory keyFactory) {
        this.compilerOptions = compilerOptions;
        this.componentCreatorImplementationFactory = componentCreatorImplementationFactory;
        this.typeProtoConverter = typeProtoConverter;
        this.keyFactory = keyFactory;
    }

    ComponentImplementation create(ComponentDescriptor component, TypeElement generatedComponent) {
        Optional<ComponentImplementation> superclassImplementation = this.deserializedSuperclassImplementation(component, MoreTypes.asTypeElement(generatedComponent.getSuperclass()));
        ComponentImplementation componentImplementation = ComponentImplementation.forDeserializedComponent(component, ClassName.get((TypeElement)generatedComponent), generatedComponent.getNestingKind(), superclassImplementation, this.compilerOptions);
        componentImplementation.setCreatorImplementation(superclassImplementation.isPresent() ? Optional.empty() : this.componentCreatorImplementationFactory.create(componentImplementation, Optional.empty()));
        for (ExecutableElement method : ElementFilter.methodsIn(generatedComponent.getEnclosedElements())) {
            MoreElements.getAnnotationMirror(method, ModifiableBinding.class).asSet().forEach(annotation -> this.addModifiableBindingMethod(componentImplementation, method, (AnnotationMirror)annotation));
            MoreElements.getAnnotationMirror(method, ModifiableModule.class).asSet().forEach(annotation -> this.addModifiableModuleMethod(componentImplementation, method, (AnnotationMirror)annotation));
            MoreElements.getAnnotationMirror(method, ConfigureInitializationParameters.class).asSet().forEach(annotation -> this.setConfigureInitializationMethod(componentImplementation, method, (AnnotationMirror)annotation));
        }
        for (TypeElement nestedType : ElementFilter.typesIn(generatedComponent.getEnclosedElements())) {
            this.addChildImplementation(component, componentImplementation, nestedType);
        }
        return componentImplementation;
    }

    private Optional<ComponentImplementation> deserializedSuperclassImplementation(ComponentDescriptor component, TypeElement superclassElement) {
        return MoreElements.isAnnotationPresent(superclassElement, ComponentDefinitionType.class) ? Optional.of(this.create(component, superclassElement)) : Optional.empty();
    }

    private void addModifiableBindingMethod(ComponentImplementation componentImplementation, ExecutableElement method, AnnotationMirror metadataAnnotation) {
        ModifiableBindingType modifiableBindingType = ModifiableBindingType.valueOf(AnnotationMirrors.getAnnotationValue(metadataAnnotation, "modifiableBindingType").getValue().toString());
        BindingRequest request = this.parseBindingRequest(AnnotationMirrors.getAnnotationValue(metadataAnnotation, "bindingRequest"));
        ImmutableList multibindingContributions = MoreAnnotationValues.asAnnotationValues(AnnotationMirrors.getAnnotationValue(metadataAnnotation, "multibindingContributions")).stream().map(this::parseKey).collect(DaggerStreams.toImmutableList());
        componentImplementation.addModifiableBindingMethod(modifiableBindingType, request, method.getReturnType(), this.methodDeclaration(method), method.getModifiers().contains((Object)Modifier.FINAL));
        componentImplementation.registerImplementedMultibindingKeys(request, (Iterable<Key>)multibindingContributions);
    }

    private BindingRequest fromProto(BindingRequestProto bindingRequest) {
        Key key = this.keyFactory.fromProto(bindingRequest.getKey());
        return bindingRequest.getFrameworkType().equals((Object)FrameworkTypeWrapper.FrameworkType.UNKNOWN) ? BindingRequest.bindingRequest(key, RequestKind.valueOf((String)bindingRequest.getRequestKind().name())) : BindingRequest.bindingRequest(key, FrameworkType.valueOf(bindingRequest.getFrameworkType().name()));
    }

    private MethodSpec methodDeclaration(ExecutableElement method) {
        return MethodSpec.methodBuilder((String)method.getSimpleName().toString()).addModifiers(method.getModifiers()).returns(TypeName.get((TypeMirror)method.getReturnType())).build();
    }

    private void addModifiableModuleMethod(ComponentImplementation componentImplementation, ExecutableElement method, AnnotationMirror metadataAnnotation) {
        ComponentRequirement moduleRequirement = this.parseComponentRequirement(AnnotationMirrors.getAnnotationValue(metadataAnnotation, "value"));
        componentImplementation.registerModifiableModuleMethod(moduleRequirement, method.getSimpleName().toString());
    }

    private void setConfigureInitializationMethod(ComponentImplementation componentImplementation, ExecutableElement method, AnnotationMirror metadataAnnotation) {
        ImmutableSet parameters = MoreAnnotationValues.asAnnotationValues(AnnotationMirrors.getAnnotationValue(metadataAnnotation, "value")).stream().map(this::parseComponentRequirement).collect(DaggerStreams.toImmutableSet());
        componentImplementation.setConfigureInitializationMethod(ComponentImplementation.ConfigureInitializationMethod.create(MethodSpec.overriding((ExecutableElement)method).build(), parameters));
    }

    private void addChildImplementation(ComponentDescriptor component, ComponentImplementation componentImplementation, TypeElement nestedType) {
        MoreElements.getAnnotationMirror(nestedType, ComponentDefinitionType.class).transform(annotation -> (TypeMirror)AnnotationMirrors.getAnnotationValue(annotation, "value").getValue()).transform(MoreTypes::asTypeElement).asSet().forEach(componentDefinitionType -> {
            ComponentDescriptor child = (ComponentDescriptor)component.childComponentsByElement().get(componentDefinitionType);
            componentImplementation.addChild(child, this.create(child, nestedType));
        });
    }

    private Key parseKey(AnnotationValue annotationValue) {
        return this.keyFactory.fromProto(ProtoSerialization.fromAnnotationValue(annotationValue, KeyProto.getDefaultInstance()));
    }

    private BindingRequest parseBindingRequest(AnnotationValue annotationValue) {
        return this.fromProto(ProtoSerialization.fromAnnotationValue(annotationValue, BindingRequestProto.getDefaultInstance()));
    }

    private ComponentRequirement parseComponentRequirement(AnnotationValue annotationValue) {
        return this.fromProto(ProtoSerialization.fromAnnotationValue(annotationValue, ComponentRequirementProto.getDefaultInstance()));
    }

    private ComponentRequirement fromProto(ComponentRequirementProto proto) {
        switch (proto.getRequirementCase()) {
            case MODULE: {
                return ComponentRequirement.forModule(this.typeProtoConverter.fromProto(proto.getModule()));
            }
            case DEPENDENCY: {
                return ComponentRequirement.forDependency(this.typeProtoConverter.fromProto(proto.getDependency()));
            }
            case BOUND_INSTANCE: {
                return ComponentRequirement.forBoundInstance(this.keyFactory.fromProto(proto.getBoundInstance().getKey()), proto.getBoundInstance().getNullable(), proto.getBoundInstance().getVariableName());
            }
        }
        throw new AssertionError(proto);
    }
}

