/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.DaggerStreams;
import dagger.model.ComponentPath;
import dagger.model.DependencyRequest;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class ComponentTreeTraverser {
    private final Deque<BindingGraph> bindingGraphPath = new ArrayDeque<BindingGraph>();
    private final Deque<ComponentPath> componentPaths = new ArrayDeque<ComponentPath>();

    public ComponentTreeTraverser(BindingGraph rootGraph) {
        this.bindingGraphPath.add(rootGraph);
        this.componentPaths.add(ComponentPath.create((Iterable)ImmutableList.of((Object)rootGraph.componentTypeElement())));
    }

    public final void traverseComponents() {
        Preconditions.checkState((this.bindingGraphPath.size() == 1 ? 1 : 0) != 0);
        Preconditions.checkState((this.componentPaths.size() == 1 ? 1 : 0) != 0);
        this.visitComponent(this.bindingGraphPath.getFirst());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitComponent(BindingGraph graph) {
        if (this.bindingGraphPath.size() > 1) {
            BindingGraph parent = (BindingGraph)Iterators.get(this.bindingGraphPath.descendingIterator(), (int)1);
            parent.componentDescriptor().getFactoryMethodForChildComponent(graph.componentDescriptor()).ifPresent(childFactoryMethod -> this.visitSubcomponentFactoryMethod(graph, parent, childFactoryMethod.methodElement()));
        }
        for (ComponentDescriptor.ComponentMethodDescriptor entryPointMethod : graph.componentDescriptor().entryPointMethods()) {
            this.visitEntryPoint(entryPointMethod.dependencyRequest().get(), graph);
        }
        for (BindingGraph child : graph.subgraphs()) {
            this.bindingGraphPath.addLast(child);
            ComponentPath childPath = ComponentPath.create((Iterable)((Iterable)this.bindingGraphPath.stream().map(BindingGraph::componentTypeElement).collect(DaggerStreams.toImmutableList())));
            this.componentPaths.addLast(childPath);
            try {
                this.visitComponent(child);
            }
            finally {
                Verify.verify((boolean)this.bindingGraphPath.removeLast().equals(child));
                Verify.verify((boolean)this.componentPaths.removeLast().equals((Object)childPath));
            }
        }
    }

    protected void visitSubcomponentFactoryMethod(BindingGraph graph, BindingGraph parent, ExecutableElement factoryMethod) {
    }

    protected void visitEntryPoint(DependencyRequest entryPoint, BindingGraph graph) {
    }

    protected final ComponentPath componentPath() {
        return this.componentPaths.getLast();
    }

    protected final ComponentPath pathFromRootToAncestor(TypeElement ancestor) {
        for (ComponentPath componentPath : this.componentPaths) {
            if (!componentPath.currentComponent().equals(ancestor)) continue;
            return componentPath;
        }
        throw new IllegalArgumentException(String.format("%s is not in the current path: %s", ancestor.getQualifiedName(), this));
    }

    protected final BindingGraph graphForAncestor(TypeElement ancestor) {
        for (BindingGraph graph : this.bindingGraphPath) {
            if (!graph.componentTypeElement().equals(ancestor)) continue;
            return graph;
        }
        throw new IllegalArgumentException(String.format("%s is not in the current path: %s", ancestor.getQualifiedName(), this));
    }
}

