/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.Component;
import dagger.Subcomponent;
import dagger.internal.codegen.$;
import dagger.internal.codegen.AutoValue_ComponentAnnotation_FictionalComponentAnnotation;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.ModuleAnnotation;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.MoreAnnotationValues;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.producers.ProducerModule;
import dagger.producers.ProductionComponent;
import dagger.producers.ProductionSubcomponent;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

abstract class ComponentAnnotation {
    private static final ImmutableSet<Class<? extends Annotation>> ROOT_COMPONENT_ANNOTATIONS = ImmutableSet.of(Component.class, ProductionComponent.class);
    private static final ImmutableSet<Class<? extends Annotation>> SUBCOMPONENT_ANNOTATIONS = ImmutableSet.of(Subcomponent.class, ProductionSubcomponent.class);
    private static final ImmutableSet<Class<? extends Annotation>> ALL_COMPONENT_ANNOTATIONS = ImmutableSet.builder().addAll(ROOT_COMPONENT_ANNOTATIONS).addAll(SUBCOMPONENT_ANNOTATIONS).build();

    ComponentAnnotation() {
    }

    abstract AnnotationMirror annotation();

    String simpleName() {
        return MoreAnnotationMirrors.simpleName(this.annotation()).toString();
    }

    abstract boolean isSubcomponent();

    abstract boolean isProduction();

    abstract boolean isRealComponent();

    abstract ImmutableList<AnnotationValue> dependencyValues();

    ImmutableList<TypeMirror> dependencyTypes() {
        return this.dependencyValues().stream().map(MoreAnnotationValues::asType).collect(DaggerStreams.toImmutableList());
    }

    ImmutableList<TypeElement> dependencies() {
        return MoreTypes.asTypeElements(this.dependencyTypes()).asList();
    }

    abstract ImmutableList<AnnotationValue> moduleValues();

    ImmutableList<TypeMirror> moduleTypes() {
        return this.moduleValues().stream().map(MoreAnnotationValues::asType).collect(DaggerStreams.toImmutableList());
    }

    ImmutableSet<TypeElement> modules() {
        return MoreTypes.asTypeElements(this.moduleTypes());
    }

    protected final ImmutableList<AnnotationValue> getAnnotationValues(String parameterName) {
        return MoreAnnotationValues.asAnnotationValues(AnnotationMirrors.getAnnotationValue(this.annotation(), parameterName));
    }

    static Optional<ComponentAnnotation> rootComponentAnnotation(TypeElement typeElement) {
        return ComponentAnnotation.anyComponentAnnotation(typeElement, ROOT_COMPONENT_ANNOTATIONS);
    }

    static Optional<ComponentAnnotation> subcomponentAnnotation(TypeElement typeElement) {
        return ComponentAnnotation.anyComponentAnnotation(typeElement, SUBCOMPONENT_ANNOTATIONS);
    }

    static Optional<ComponentAnnotation> anyComponentAnnotation(TypeElement typeElement) {
        return ComponentAnnotation.anyComponentAnnotation(typeElement, ALL_COMPONENT_ANNOTATIONS);
    }

    private static Optional<ComponentAnnotation> anyComponentAnnotation(TypeElement typeElement, Collection<Class<? extends Annotation>> annotations) {
        return DaggerElements.getAnyAnnotation(typeElement, annotations).map(ComponentAnnotation::componentAnnotation);
    }

    static boolean isComponentAnnotation(AnnotationMirror annotation) {
        return ALL_COMPONENT_ANNOTATIONS.stream().anyMatch(annotationClass -> MoreTypes.isTypeOf(annotationClass, annotation.getAnnotationType()));
    }

    static ComponentAnnotation componentAnnotation(AnnotationMirror annotation) {
        RealComponentAnnotation.Builder annotationBuilder = RealComponentAnnotation.builder().annotation(annotation);
        if (MoreTypes.isTypeOf(Component.class, annotation.getAnnotationType())) {
            return annotationBuilder.isProduction(false).isSubcomponent(false).build();
        }
        if (MoreTypes.isTypeOf(Subcomponent.class, annotation.getAnnotationType())) {
            return annotationBuilder.isProduction(false).isSubcomponent(true).build();
        }
        if (MoreTypes.isTypeOf(ProductionComponent.class, annotation.getAnnotationType())) {
            return annotationBuilder.isProduction(true).isSubcomponent(false).build();
        }
        if (MoreTypes.isTypeOf(ProductionSubcomponent.class, annotation.getAnnotationType())) {
            return annotationBuilder.isProduction(true).isSubcomponent(true).build();
        }
        throw new IllegalArgumentException(annotation + " must be a Component, Subcomponent, ProductionComponent, or ProductionSubcomponent annotation");
    }

    static ComponentAnnotation fromModuleAnnotation(ModuleAnnotation moduleAnnotation) {
        return new AutoValue_ComponentAnnotation_FictionalComponentAnnotation(moduleAnnotation);
    }

    static ImmutableSet<Class<? extends Annotation>> rootComponentAnnotations() {
        return ROOT_COMPONENT_ANNOTATIONS;
    }

    static ImmutableSet<Class<? extends Annotation>> subcomponentAnnotations() {
        return SUBCOMPONENT_ANNOTATIONS;
    }

    static ImmutableSet<Class<? extends Annotation>> allComponentAnnotations() {
        return ALL_COMPONENT_ANNOTATIONS;
    }

    @AutoValue
    static abstract class FictionalComponentAnnotation
    extends ComponentAnnotation {
        FictionalComponentAnnotation() {
        }

        @Override
        AnnotationMirror annotation() {
            return this.moduleAnnotation().annotation();
        }

        @Override
        boolean isSubcomponent() {
            return false;
        }

        @Override
        boolean isProduction() {
            return this.moduleAnnotation().annotationClass().equals(ProducerModule.class);
        }

        @Override
        boolean isRealComponent() {
            return false;
        }

        @Override
        ImmutableList<AnnotationValue> dependencyValues() {
            return ImmutableList.of();
        }

        @Override
        ImmutableList<AnnotationValue> moduleValues() {
            return this.moduleAnnotation().includesAsAnnotationValues();
        }

        @Override
        ImmutableList<TypeMirror> moduleTypes() {
            return super.moduleTypes();
        }

        @Override
        ImmutableSet<TypeElement> modules() {
            return super.modules();
        }

        abstract ModuleAnnotation moduleAnnotation();
    }

    @AutoValue
    static abstract class RealComponentAnnotation
    extends ComponentAnnotation {
        RealComponentAnnotation() {
        }

        @Override
        ImmutableList<AnnotationValue> dependencyValues() {
            return this.isSubcomponent() ? ImmutableList.of() : this.getAnnotationValues("dependencies");
        }

        @Override
        ImmutableList<TypeMirror> dependencyTypes() {
            return super.dependencyTypes();
        }

        @Override
        ImmutableList<TypeElement> dependencies() {
            return super.dependencies();
        }

        @Override
        boolean isRealComponent() {
            return true;
        }

        @Override
        ImmutableList<AnnotationValue> moduleValues() {
            return this.getAnnotationValues("modules");
        }

        @Override
        ImmutableList<TypeMirror> moduleTypes() {
            return super.moduleTypes();
        }

        @Override
        ImmutableSet<TypeElement> modules() {
            return super.modules();
        }

        static Builder builder() {
            return new $.AutoValue_ComponentAnnotation_RealComponentAnnotation.Builder();
        }

        @AutoValue.Builder
        static interface Builder {
            public Builder annotation(AnnotationMirror var1);

            public Builder isSubcomponent(boolean var1);

            public Builder isProduction(boolean var1);

            public RealComponentAnnotation build();
        }
    }
}

