/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.Iterables;
import dagger.internal.codegen.BindingElementValidator;
import dagger.internal.codegen.BindsInstanceElementValidator;
import dagger.internal.codegen.ComponentAnnotation;
import dagger.internal.codegen.ModuleAnnotation;
import dagger.shaded.auto.common.MoreElements;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

final class BindsInstanceMethodValidator
extends BindsInstanceElementValidator<ExecutableElement> {
    @Inject
    BindsInstanceMethodValidator() {
    }

    @Override
    protected BindingElementValidator.ElementValidator elementValidator(ExecutableElement element) {
        return new Validator(element);
    }

    private static String didYouMeanBinds(ModuleAnnotation moduleAnnotation) {
        return String.format("@BindsInstance methods should not be included in @%ss. Did you mean @Binds?", moduleAnnotation.annotationClass().getSimpleName());
    }

    private class Validator
    extends BindingElementValidator.ElementValidator {
        Validator(ExecutableElement element) {
            super((BindingElementValidator)BindsInstanceMethodValidator.this, (Element)element);
        }

        @Override
        protected void checkAdditionalProperties() {
            if (!((ExecutableElement)this.element).getModifiers().contains((Object)Modifier.ABSTRACT)) {
                this.report.addError("@BindsInstance methods must be abstract");
            }
            if (((ExecutableElement)this.element).getParameters().size() != 1) {
                this.report.addError("@BindsInstance methods should have exactly one parameter for the bound type");
            }
            TypeElement enclosingType = MoreElements.asType(((ExecutableElement)this.element).getEnclosingElement());
            ModuleAnnotation.moduleAnnotation(enclosingType).ifPresent(moduleAnnotation -> this.report.addError(BindsInstanceMethodValidator.didYouMeanBinds(moduleAnnotation)));
            ComponentAnnotation.anyComponentAnnotation(enclosingType).ifPresent(componentAnnotation -> this.report.addError(String.format("@BindsInstance methods should not be included in @%1$ss. Did you mean to put it in a @%1$s.Builder?", componentAnnotation.simpleName())));
        }

        @Override
        protected Optional<TypeMirror> bindingElementType() {
            List<? extends VariableElement> parameters = MoreElements.asExecutable(this.element).getParameters();
            return parameters.size() == 1 ? Optional.of(((VariableElement)Iterables.getOnlyElement(parameters)).asType()) : Optional.empty();
        }
    }
}

