/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.FormatMethod;
import dagger.Provides;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MultibindingAnnotations;
import dagger.internal.codegen.Scopes;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.ValidationReport;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.model.Scope;
import java.lang.annotation.Annotation;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

abstract class BindingElementValidator<E extends Element> {
    private final Class<? extends Annotation> bindingAnnotation;
    private final AllowsMultibindings allowsMultibindings;
    private final AllowsScoping allowsScoping;
    private final Map<E, ValidationReport<E>> cache = new HashMap<E, ValidationReport<E>>();

    protected BindingElementValidator(Class<? extends Annotation> bindingAnnotation, AllowsMultibindings allowsMultibindings, AllowsScoping allowsScoping) {
        this.bindingAnnotation = bindingAnnotation;
        this.allowsMultibindings = allowsMultibindings;
        this.allowsScoping = allowsScoping;
    }

    final ValidationReport<E> validate(E element) {
        return Util.reentrantComputeIfAbsent(this.cache, element, this::validateUncached);
    }

    private ValidationReport<E> validateUncached(E element) {
        return this.elementValidator(element).validate();
    }

    @FormatMethod
    protected final String bindingElements(String ruleFormat, Object ... args) {
        return new Formatter().format("%s ", this.bindingElements()).format(ruleFormat, args).toString();
    }

    protected abstract String bindingElements();

    protected abstract String bindingElementTypeVerb();

    protected String badTypeMessage() {
        return this.bindingElements("must %s a primitive, an array, a type variable, or a declared type", this.bindingElementTypeVerb());
    }

    protected String elementsIntoSetNotASetMessage() {
        return this.bindingElements("annotated with @ElementsIntoSet must %s a Set", this.bindingElementTypeVerb());
    }

    protected String elementsIntoSetRawSetMessage() {
        return this.bindingElements("annotated with @ElementsIntoSet cannot %s a raw Set", this.bindingElementTypeVerb());
    }

    protected abstract ElementValidator elementValidator(E var1);

    static enum AllowsScoping {
        NO_SCOPING,
        ALLOWS_SCOPING;

    }

    static enum AllowsMultibindings {
        NO_MULTIBINDINGS,
        ALLOWS_MULTIBINDINGS;


        private boolean allowsMultibindings() {
            return this == ALLOWS_MULTIBINDINGS;
        }
    }

    protected static abstract class ElementValidator {
        protected final E element;
        protected final ValidationReport.Builder<E> report;
        final /* synthetic */ BindingElementValidator this$0;

        protected ElementValidator(E element) {
            this.this$0 = this$0;
            this.element = element;
            this.report = ValidationReport.about(element);
        }

        private ValidationReport<E> validate() {
            this.checkType();
            this.checkQualifiers();
            this.checkMapKeys();
            this.checkMultibindings();
            this.checkScopes();
            this.checkAdditionalProperties();
            return this.report.build();
        }

        protected void checkAdditionalProperties() {
        }

        protected abstract Optional<TypeMirror> bindingElementType();

        protected void checkType() {
            switch (ContributionType.fromBindingElement(this.element)) {
                case UNIQUE: {
                    this.checkFrameworkType();
                }
                case SET: 
                case MAP: {
                    this.bindingElementType().ifPresent(type -> this.checkKeyType((TypeMirror)type));
                    break;
                }
                case SET_VALUES: {
                    this.checkSetValuesType();
                }
            }
        }

        protected void checkKeyType(TypeMirror keyType) {
            TypeKind kind = keyType.getKind();
            if (kind.equals((Object)TypeKind.VOID)) {
                this.report.addError(this.this$0.bindingElements("must %s a value (not void)", this.this$0.bindingElementTypeVerb()));
            } else if (!(kind.isPrimitive() || kind.equals((Object)TypeKind.DECLARED) || kind.equals((Object)TypeKind.ARRAY) || kind.equals((Object)TypeKind.TYPEVAR))) {
                this.report.addError(this.this$0.badTypeMessage());
            }
        }

        protected void checkSetValuesType() {
            this.bindingElementType().ifPresent(keyType -> this.checkSetValuesType((TypeMirror)keyType));
        }

        protected final void checkSetValuesType(TypeMirror type) {
            if (!SetType.isSet(type)) {
                this.report.addError(this.this$0.elementsIntoSetNotASetMessage());
            } else {
                SetType setType = SetType.from(type);
                if (setType.isRawType()) {
                    this.report.addError(this.this$0.elementsIntoSetRawSetMessage());
                } else {
                    this.checkKeyType(setType.elementType());
                }
            }
        }

        private void checkQualifiers() {
            ImmutableSet<? extends AnnotationMirror> qualifiers = InjectionAnnotations.getQualifiers(this.element);
            if (qualifiers.size() > 1) {
                for (AnnotationMirror qualifier : qualifiers) {
                    this.report.addError(this.this$0.bindingElements("may not use more than one @Qualifier", new Object[0]), (Element)this.element, qualifier);
                }
            }
        }

        private void checkMapKeys() {
            if (!this.this$0.allowsMultibindings.allowsMultibindings()) {
                return;
            }
            ImmutableSet<? extends AnnotationMirror> mapKeys = MapKeys.getMapKeys(this.element);
            if (ContributionType.fromBindingElement(this.element).equals((Object)ContributionType.MAP)) {
                switch (mapKeys.size()) {
                    case 0: {
                        this.report.addError(this.this$0.bindingElements("of type map must declare a map key", new Object[0]));
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.report.addError(this.this$0.bindingElements("may not have more than one map key", new Object[0]));
                        break;
                    }
                }
            } else if (!mapKeys.isEmpty()) {
                this.report.addError(this.this$0.bindingElements("of non map type cannot declare a map key", new Object[0]));
            }
        }

        private void checkMultibindings() {
            ImmutableSet<AnnotationMirror> multibindingAnnotations = MultibindingAnnotations.forElement(this.element);
            switch (this.this$0.allowsMultibindings) {
                case NO_MULTIBINDINGS: {
                    for (AnnotationMirror annotation : multibindingAnnotations) {
                        this.report.addError(this.this$0.bindingElements("cannot have multibinding annotations", new Object[0]), (Element)this.element, annotation);
                    }
                    break;
                }
                case ALLOWS_MULTIBINDINGS: {
                    if (multibindingAnnotations.size() <= 1) break;
                    for (AnnotationMirror annotation : multibindingAnnotations) {
                        this.report.addError(this.this$0.bindingElements("cannot have more than one multibinding annotation", new Object[0]), (Element)this.element, annotation);
                    }
                    break;
                }
            }
            if (this.this$0.bindingAnnotation.equals(Provides.class)) {
                AnnotationMirror bindingAnnotationMirror = DaggerElements.getAnnotationMirror(this.element, this.this$0.bindingAnnotation).get();
                boolean usesProvidesType = false;
                for (ExecutableElement member : bindingAnnotationMirror.getElementValues().keySet()) {
                    usesProvidesType |= member.getSimpleName().contentEquals("type");
                }
                if (usesProvidesType && !multibindingAnnotations.isEmpty()) {
                    this.report.addError("@Provides.type cannot be used with multibinding annotations", (Element)this.element);
                }
            }
        }

        private void checkScopes() {
            ImmutableSet<Scope> scopes = Scopes.scopesOf(this.element);
            String error = null;
            switch (this.this$0.allowsScoping) {
                case ALLOWS_SCOPING: {
                    if (scopes.size() <= 1) {
                        return;
                    }
                    error = this.this$0.bindingElements("cannot use more than one @Scope", new Object[0]);
                    break;
                }
                case NO_SCOPING: {
                    error = this.this$0.bindingElements("cannot be scoped", new Object[0]);
                }
            }
            Verify.verifyNotNull(error);
            for (Scope scope : scopes) {
                this.report.addError(error, (Element)this.element, scope.scopeAnnotation());
            }
        }

        private void checkFrameworkType() {
            if (this.bindingElementType().filter(FrameworkTypes::isFrameworkType).isPresent()) {
                this.report.addError(this.this$0.bindingElements("must not %s framework types", this.this$0.bindingElementTypeVerb()));
            }
        }
    }
}

