/*
 * Decompiled with CFR 0.152.
 */
package dagger.errorprone;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.io.Serializable;

@BugPattern(name="AndroidSupportInjectionModuleMigrator", providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, summary="Inlines usages of AndroidSupportInjectionModule to AndroidInjectionModule", explanation="AndroidSupportInjectionModule is now an empty module and acts as an alias for AndroidInjectionModule. This migration rewrites usages of the former to the latter.", severity=BugPattern.SeverityLevel.SUGGESTION)
public final class AndroidSupportInjectionModuleMigrator
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher {
    private static final Matcher<ExpressionTree> MODULE_CLASS_LITERAL = Matchers.classLiteral((Matcher & Serializable)(expressionTree, state) -> {
        Symbol symbol = ASTHelpers.getSymbol((Tree)expressionTree);
        if (symbol == null) {
            return false;
        }
        return symbol.getQualifiedName().contentEquals("dagger.android.support.AndroidSupportInjectionModule");
    });

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        if (MODULE_CLASS_LITERAL.matches((Tree)tree, state)) {
            return this.describeMatch(tree, (Fix)SuggestedFix.builder().replace((Tree)tree, "AndroidInjectionModule.class").addImport("dagger.android.AndroidInjectionModule").build());
        }
        return Description.NO_MATCH;
    }
}

