/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.video;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.ParsableByteArray;

public final class DolbyVisionConfig {
    public final int profile;
    public final int level;
    public final String codecs;

    @Nullable
    public static DolbyVisionConfig parse(ParsableByteArray data) {
        String codecsPrefix;
        data.skipBytes(2);
        int profileData = data.readUnsignedByte();
        int dvProfile = profileData >> 1;
        int dvLevel = (profileData & 1) << 5 | data.readUnsignedByte() >> 3 & 0x1F;
        if (dvProfile == 4 || dvProfile == 5) {
            codecsPrefix = "dvhe";
        } else if (dvProfile == 8) {
            codecsPrefix = "hev1";
        } else if (dvProfile == 9) {
            codecsPrefix = "avc3";
        } else {
            return null;
        }
        String codecs = codecsPrefix + ".0" + dvProfile + ".0" + dvLevel;
        return new DolbyVisionConfig(dvProfile, dvLevel, codecs);
    }

    private DolbyVisionConfig(int profile, int level, String codecs) {
        this.profile = profile;
        this.level = level;
        this.codecs = codecs;
    }
}

