/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import com.google.android.exoplayer2.util.Assertions;

public final class TimestampAdjuster {
    public static final long DO_NOT_OFFSET = Long.MAX_VALUE;
    private static final long MAX_PTS_PLUS_ONE = 0x200000000L;
    private long firstSampleTimestampUs;
    private long timestampOffsetUs;
    private volatile long lastSampleTimestampUs = -9223372036854775807L;

    public TimestampAdjuster(long firstSampleTimestampUs) {
        this.setFirstSampleTimestampUs(firstSampleTimestampUs);
    }

    public synchronized void setFirstSampleTimestampUs(long firstSampleTimestampUs) {
        Assertions.checkState(this.lastSampleTimestampUs == -9223372036854775807L);
        this.firstSampleTimestampUs = firstSampleTimestampUs;
    }

    public long getFirstSampleTimestampUs() {
        return this.firstSampleTimestampUs;
    }

    public long getLastAdjustedTimestampUs() {
        return this.lastSampleTimestampUs != -9223372036854775807L ? this.lastSampleTimestampUs + this.timestampOffsetUs : (this.firstSampleTimestampUs != Long.MAX_VALUE ? this.firstSampleTimestampUs : -9223372036854775807L);
    }

    public long getTimestampOffsetUs() {
        return this.firstSampleTimestampUs == Long.MAX_VALUE ? 0L : (this.lastSampleTimestampUs == -9223372036854775807L ? -9223372036854775807L : this.timestampOffsetUs);
    }

    public void reset() {
        this.lastSampleTimestampUs = -9223372036854775807L;
    }

    public long adjustTsTimestamp(long pts90Khz) {
        if (pts90Khz == -9223372036854775807L) {
            return -9223372036854775807L;
        }
        if (this.lastSampleTimestampUs != -9223372036854775807L) {
            long lastPts = TimestampAdjuster.usToPts(this.lastSampleTimestampUs);
            long closestWrapCount = (lastPts + 0x100000000L) / 0x200000000L;
            long ptsWrapBelow = pts90Khz + 0x200000000L * (closestWrapCount - 1L);
            long ptsWrapAbove = pts90Khz + 0x200000000L * closestWrapCount;
            pts90Khz = Math.abs(ptsWrapBelow - lastPts) < Math.abs(ptsWrapAbove - lastPts) ? ptsWrapBelow : ptsWrapAbove;
        }
        return this.adjustSampleTimestamp(TimestampAdjuster.ptsToUs(pts90Khz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long adjustSampleTimestamp(long timeUs) {
        if (timeUs == -9223372036854775807L) {
            return -9223372036854775807L;
        }
        if (this.lastSampleTimestampUs != -9223372036854775807L) {
            this.lastSampleTimestampUs = timeUs;
        } else {
            if (this.firstSampleTimestampUs != Long.MAX_VALUE) {
                this.timestampOffsetUs = this.firstSampleTimestampUs - timeUs;
            }
            TimestampAdjuster timestampAdjuster = this;
            synchronized (timestampAdjuster) {
                this.lastSampleTimestampUs = timeUs;
                this.notifyAll();
            }
        }
        return timeUs + this.timestampOffsetUs;
    }

    public synchronized void waitUntilInitialized() throws InterruptedException {
        while (this.lastSampleTimestampUs == -9223372036854775807L) {
            this.wait();
        }
    }

    public static long ptsToUs(long pts) {
        return pts * 1000000L / 90000L;
    }

    public static long usToPts(long us) {
        return us * 90000L / 1000000L;
    }
}

