/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import androidx.annotation.Nullable;
import java.util.Arrays;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public final class TimedValueQueue<V> {
    private static final int INITIAL_BUFFER_SIZE = 10;
    private long[] timestamps;
    private @NullableType V[] values;
    private int first;
    private int size;

    public TimedValueQueue() {
        this(10);
    }

    public TimedValueQueue(int initialBufferSize) {
        this.timestamps = new long[initialBufferSize];
        this.values = TimedValueQueue.newArray(initialBufferSize);
    }

    public synchronized void add(long timestamp, V value) {
        this.clearBufferOnTimeDiscontinuity(timestamp);
        this.doubleCapacityIfFull();
        this.addUnchecked(timestamp, value);
    }

    public synchronized void clear() {
        this.first = 0;
        this.size = 0;
        Arrays.fill(this.values, null);
    }

    public synchronized int size() {
        return this.size;
    }

    @Nullable
    public synchronized V pollFloor(long timestamp) {
        return this.poll(timestamp, true);
    }

    @Nullable
    public synchronized V poll(long timestamp) {
        return this.poll(timestamp, false);
    }

    @Nullable
    private V poll(long timestamp, boolean onlyOlder) {
        long timeDiff;
        V value = null;
        long previousTimeDiff = Long.MAX_VALUE;
        while (this.size > 0 && ((timeDiff = timestamp - this.timestamps[this.first]) >= 0L || !onlyOlder && -timeDiff < previousTimeDiff)) {
            previousTimeDiff = timeDiff;
            value = this.values[this.first];
            this.values[this.first] = null;
            this.first = (this.first + 1) % this.values.length;
            --this.size;
        }
        return value;
    }

    private void clearBufferOnTimeDiscontinuity(long timestamp) {
        int last;
        if (this.size > 0 && timestamp <= this.timestamps[last = (this.first + this.size - 1) % this.values.length]) {
            this.clear();
        }
    }

    private void doubleCapacityIfFull() {
        int capacity = this.values.length;
        if (this.size < capacity) {
            return;
        }
        int newCapacity = capacity * 2;
        long[] newTimestamps = new long[newCapacity];
        V[] newValues = TimedValueQueue.newArray(newCapacity);
        int length = capacity - this.first;
        System.arraycopy(this.timestamps, this.first, newTimestamps, 0, length);
        System.arraycopy(this.values, this.first, newValues, 0, length);
        if (this.first > 0) {
            System.arraycopy(this.timestamps, 0, newTimestamps, length, this.first);
            System.arraycopy(this.values, 0, newValues, length, this.first);
        }
        this.timestamps = newTimestamps;
        this.values = newValues;
        this.first = 0;
    }

    private void addUnchecked(long timestamp, V value) {
        int next = (this.first + this.size) % this.values.length;
        this.timestamps[next] = timestamp;
        this.values[next] = value;
        ++this.size;
    }

    private static <V> V[] newArray(int length) {
        return new Object[length];
    }
}

