/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.text.TextUtils;
import androidx.annotation.Nullable;

public final class Log {
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_INFO = 1;
    public static final int LOG_LEVEL_WARNING = 2;
    public static final int LOG_LEVEL_ERROR = 3;
    public static final int LOG_LEVEL_OFF = Integer.MAX_VALUE;
    private static int logLevel = 0;
    private static boolean logStackTraces = true;

    private Log() {
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public boolean getLogStackTraces() {
        return logStackTraces;
    }

    public static void setLogLevel(int logLevel) {
        Log.logLevel = logLevel;
    }

    public static void setLogStackTraces(boolean logStackTraces) {
        Log.logStackTraces = logStackTraces;
    }

    public static void d(String tag, String message) {
        if (logLevel == 0) {
            android.util.Log.d((String)tag, (String)message);
        }
    }

    public static void d(String tag, String message, @Nullable Throwable throwable) {
        if (!logStackTraces) {
            Log.d(tag, Log.appendThrowableMessage(message, throwable));
        } else if (logLevel == 0) {
            android.util.Log.d((String)tag, (String)message, (Throwable)throwable);
        }
    }

    public static void i(String tag, String message) {
        if (logLevel <= 1) {
            android.util.Log.i((String)tag, (String)message);
        }
    }

    public static void i(String tag, String message, @Nullable Throwable throwable) {
        if (!logStackTraces) {
            Log.i(tag, Log.appendThrowableMessage(message, throwable));
        } else if (logLevel <= 1) {
            android.util.Log.i((String)tag, (String)message, (Throwable)throwable);
        }
    }

    public static void w(String tag, String message) {
        if (logLevel <= 2) {
            android.util.Log.w((String)tag, (String)message);
        }
    }

    public static void w(String tag, String message, @Nullable Throwable throwable) {
        if (!logStackTraces) {
            Log.w(tag, Log.appendThrowableMessage(message, throwable));
        } else if (logLevel <= 2) {
            android.util.Log.w((String)tag, (String)message, (Throwable)throwable);
        }
    }

    public static void e(String tag, String message) {
        if (logLevel <= 3) {
            android.util.Log.e((String)tag, (String)message);
        }
    }

    public static void e(String tag, String message, @Nullable Throwable throwable) {
        if (!logStackTraces) {
            Log.e(tag, Log.appendThrowableMessage(message, throwable));
        } else if (logLevel <= 3) {
            android.util.Log.e((String)tag, (String)message, (Throwable)throwable);
        }
    }

    private static String appendThrowableMessage(String message, @Nullable Throwable throwable) {
        if (throwable == null) {
            return message;
        }
        String throwableMessage = throwable.getMessage();
        return TextUtils.isEmpty((CharSequence)throwableMessage) ? message : message + " - " + throwableMessage;
    }
}

