/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.os.Handler;
import com.google.android.exoplayer2.util.Assertions;
import java.util.concurrent.CopyOnWriteArrayList;

public final class EventDispatcher<T> {
    private final CopyOnWriteArrayList<HandlerAndListener<T>> listeners = new CopyOnWriteArrayList();

    public void addListener(Handler handler, T eventListener) {
        Assertions.checkArgument(handler != null && eventListener != null);
        this.removeListener(eventListener);
        this.listeners.add(new HandlerAndListener<T>(handler, eventListener));
    }

    public void removeListener(T eventListener) {
        for (HandlerAndListener<T> handlerAndListener : this.listeners) {
            if (((HandlerAndListener)handlerAndListener).listener != eventListener) continue;
            handlerAndListener.release();
            this.listeners.remove(handlerAndListener);
        }
    }

    public void dispatch(Event<T> event) {
        for (HandlerAndListener<T> handlerAndListener : this.listeners) {
            handlerAndListener.dispatch(event);
        }
    }

    private static final class HandlerAndListener<T> {
        private final Handler handler;
        private final T listener;
        private boolean released;

        public HandlerAndListener(Handler handler, T eventListener) {
            this.handler = handler;
            this.listener = eventListener;
        }

        public void release() {
            this.released = true;
        }

        public void dispatch(Event<T> event) {
            this.handler.post(() -> {
                if (!this.released) {
                    event.sendTo(this.listener);
                }
            });
        }
    }

    public static interface Event<T> {
        public void sendTo(T var1);
    }
}

