/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import androidx.annotation.NonNull;
import com.google.android.exoplayer2.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class AtomicFile {
    private static final String TAG = "AtomicFile";
    private final File baseName;
    private final File backupName;

    public AtomicFile(File baseName) {
        this.baseName = baseName;
        this.backupName = new File(baseName.getPath() + ".bak");
    }

    public boolean exists() {
        return this.baseName.exists() || this.backupName.exists();
    }

    public void delete() {
        this.baseName.delete();
        this.backupName.delete();
    }

    public OutputStream startWrite() throws IOException {
        AtomicFileOutputStream str;
        if (this.baseName.exists()) {
            if (!this.backupName.exists()) {
                if (!this.baseName.renameTo(this.backupName)) {
                    Log.w(TAG, "Couldn't rename file " + this.baseName + " to backup file " + this.backupName);
                }
            } else {
                this.baseName.delete();
            }
        }
        try {
            str = new AtomicFileOutputStream(this.baseName);
        }
        catch (FileNotFoundException e) {
            File parent = this.baseName.getParentFile();
            if (parent == null || !parent.mkdirs()) {
                throw new IOException("Couldn't create directory " + this.baseName, e);
            }
            try {
                str = new AtomicFileOutputStream(this.baseName);
            }
            catch (FileNotFoundException e2) {
                throw new IOException("Couldn't create " + this.baseName, e2);
            }
        }
        return str;
    }

    public void endWrite(OutputStream str) throws IOException {
        str.close();
        this.backupName.delete();
    }

    public InputStream openRead() throws FileNotFoundException {
        this.restoreBackup();
        return new FileInputStream(this.baseName);
    }

    private void restoreBackup() {
        if (this.backupName.exists()) {
            this.baseName.delete();
            this.backupName.renameTo(this.baseName);
        }
    }

    private static final class AtomicFileOutputStream
    extends OutputStream {
        private final FileOutputStream fileOutputStream;
        private boolean closed = false;

        public AtomicFileOutputStream(File file) throws FileNotFoundException {
            this.fileOutputStream = new FileOutputStream(file);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.flush();
            try {
                this.fileOutputStream.getFD().sync();
            }
            catch (IOException e) {
                Log.w(AtomicFile.TAG, "Failed to sync file descriptor:", e);
            }
            this.fileOutputStream.close();
        }

        @Override
        public void flush() throws IOException {
            this.fileOutputStream.flush();
        }

        @Override
        public void write(int b) throws IOException {
            this.fileOutputStream.write(b);
        }

        @Override
        public void write(@NonNull byte[] b) throws IOException {
            this.fileOutputStream.write(b);
        }

        @Override
        public void write(@NonNull byte[] b, int off, int len) throws IOException {
            this.fileOutputStream.write(b, off, len);
        }
    }
}

