/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.cache;

import android.os.ConditionVariable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.database.DatabaseIOException;
import com.google.android.exoplayer2.database.DatabaseProvider;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheEvictor;
import com.google.android.exoplayer2.upstream.cache.CacheFileMetadata;
import com.google.android.exoplayer2.upstream.cache.CacheFileMetadataIndex;
import com.google.android.exoplayer2.upstream.cache.CacheSpan;
import com.google.android.exoplayer2.upstream.cache.CachedContent;
import com.google.android.exoplayer2.upstream.cache.CachedContentIndex;
import com.google.android.exoplayer2.upstream.cache.ContentMetadata;
import com.google.android.exoplayer2.upstream.cache.ContentMetadataMutations;
import com.google.android.exoplayer2.upstream.cache.SimpleCacheSpan;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class SimpleCache
implements Cache {
    private static final String TAG = "SimpleCache";
    private static final int SUBDIRECTORY_COUNT = 10;
    private static final String UID_FILE_SUFFIX = ".uid";
    private static final HashSet<File> lockedCacheDirs = new HashSet();
    private static boolean cacheFolderLockingDisabled;
    private static boolean cacheInitializationExceptionsDisabled;
    private final File cacheDir;
    private final CacheEvictor evictor;
    private final CachedContentIndex contentIndex;
    @Nullable
    private final CacheFileMetadataIndex fileIndex;
    private final HashMap<String, ArrayList<Cache.Listener>> listeners;
    private final Random random;
    private final boolean touchCacheSpans;
    private long uid;
    private long totalSpace;
    private boolean released;
    private @MonotonicNonNull Cache.CacheException initializationException;

    public static synchronized boolean isCacheFolderLocked(File cacheFolder) {
        return lockedCacheDirs.contains(cacheFolder.getAbsoluteFile());
    }

    @Deprecated
    public static synchronized void disableCacheFolderLocking() {
        cacheFolderLockingDisabled = true;
        lockedCacheDirs.clear();
    }

    @Deprecated
    public static void disableCacheInitializationExceptions() {
        cacheInitializationExceptionsDisabled = true;
    }

    public static void delete(File cacheDir, @Nullable DatabaseProvider databaseProvider) {
        long uid;
        if (!cacheDir.exists()) {
            return;
        }
        File[] files = cacheDir.listFiles();
        if (files == null) {
            cacheDir.delete();
            return;
        }
        if (databaseProvider != null && (uid = SimpleCache.loadUid(files)) != -1L) {
            try {
                CacheFileMetadataIndex.delete(databaseProvider, uid);
            }
            catch (DatabaseIOException e) {
                Log.w(TAG, "Failed to delete file metadata: " + uid);
            }
            try {
                CachedContentIndex.delete(databaseProvider, uid);
            }
            catch (DatabaseIOException e) {
                Log.w(TAG, "Failed to delete file metadata: " + uid);
            }
        }
        Util.recursiveDelete(cacheDir);
    }

    @Deprecated
    public SimpleCache(File cacheDir, CacheEvictor evictor) {
        this(cacheDir, evictor, null, false);
    }

    @Deprecated
    public SimpleCache(File cacheDir, CacheEvictor evictor, @Nullable byte[] secretKey) {
        this(cacheDir, evictor, secretKey, secretKey != null);
    }

    @Deprecated
    public SimpleCache(File cacheDir, CacheEvictor evictor, @Nullable byte[] secretKey, boolean encrypt) {
        this(cacheDir, evictor, null, secretKey, encrypt, true);
    }

    public SimpleCache(File cacheDir, CacheEvictor evictor, DatabaseProvider databaseProvider) {
        this(cacheDir, evictor, databaseProvider, null, false, false);
    }

    public SimpleCache(File cacheDir, CacheEvictor evictor, @Nullable DatabaseProvider databaseProvider, @Nullable byte[] legacyIndexSecretKey, boolean legacyIndexEncrypt, boolean preferLegacyIndex) {
        this(cacheDir, evictor, new CachedContentIndex(databaseProvider, cacheDir, legacyIndexSecretKey, legacyIndexEncrypt, preferLegacyIndex), databaseProvider != null && !preferLegacyIndex ? new CacheFileMetadataIndex(databaseProvider) : null);
    }

    SimpleCache(File cacheDir, CacheEvictor evictor, CachedContentIndex contentIndex, @Nullable CacheFileMetadataIndex fileIndex) {
        if (!SimpleCache.lockFolder(cacheDir)) {
            throw new IllegalStateException("Another SimpleCache instance uses the folder: " + cacheDir);
        }
        this.cacheDir = cacheDir;
        this.evictor = evictor;
        this.contentIndex = contentIndex;
        this.fileIndex = fileIndex;
        this.listeners = new HashMap();
        this.random = new Random();
        this.touchCacheSpans = evictor.requiresCacheSpanTouches();
        this.uid = -1L;
        final ConditionVariable conditionVariable = new ConditionVariable();
        new Thread("SimpleCache.initialize()"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SimpleCache simpleCache = SimpleCache.this;
                synchronized (simpleCache) {
                    conditionVariable.open();
                    SimpleCache.this.initialize();
                    SimpleCache.this.evictor.onCacheInitialized();
                }
            }
        }.start();
        conditionVariable.block();
    }

    public synchronized void checkInitialization() throws Cache.CacheException {
        if (!cacheInitializationExceptionsDisabled && this.initializationException != null) {
            throw this.initializationException;
        }
    }

    @Override
    public synchronized long getUid() {
        return this.uid;
    }

    @Override
    public synchronized void release() {
        if (this.released) {
            return;
        }
        this.listeners.clear();
        this.removeStaleSpans();
        try {
            this.contentIndex.store();
        }
        catch (IOException e) {
            Log.e(TAG, "Storing index file failed", e);
        }
        finally {
            SimpleCache.unlockFolder(this.cacheDir);
            this.released = true;
        }
    }

    @Override
    public synchronized NavigableSet<CacheSpan> addListener(String key, Cache.Listener listener) {
        Assertions.checkState(!this.released);
        ArrayList<Cache.Listener> listenersForKey = this.listeners.get(key);
        if (listenersForKey == null) {
            listenersForKey = new ArrayList();
            this.listeners.put(key, listenersForKey);
        }
        listenersForKey.add(listener);
        return this.getCachedSpans(key);
    }

    @Override
    public synchronized void removeListener(String key, Cache.Listener listener) {
        if (this.released) {
            return;
        }
        ArrayList<Cache.Listener> listenersForKey = this.listeners.get(key);
        if (listenersForKey != null) {
            listenersForKey.remove(listener);
            if (listenersForKey.isEmpty()) {
                this.listeners.remove(key);
            }
        }
    }

    @Override
    @NonNull
    public synchronized NavigableSet<CacheSpan> getCachedSpans(String key) {
        Assertions.checkState(!this.released);
        CachedContent cachedContent = this.contentIndex.get(key);
        return cachedContent == null || cachedContent.isEmpty() ? new TreeSet<SimpleCacheSpan>() : new TreeSet<SimpleCacheSpan>((Collection<SimpleCacheSpan>)cachedContent.getSpans());
    }

    @Override
    public synchronized Set<String> getKeys() {
        Assertions.checkState(!this.released);
        return new HashSet<String>(this.contentIndex.getKeys());
    }

    @Override
    public synchronized long getCacheSpace() {
        Assertions.checkState(!this.released);
        return this.totalSpace;
    }

    @Override
    public synchronized SimpleCacheSpan startReadWrite(String key, long position) throws InterruptedException, Cache.CacheException {
        Assertions.checkState(!this.released);
        this.checkInitialization();
        SimpleCacheSpan span;
        while ((span = this.startReadWriteNonBlocking(key, position)) == null) {
            this.wait();
        }
        return span;
    }

    @Override
    @Nullable
    public synchronized SimpleCacheSpan startReadWriteNonBlocking(String key, long position) throws Cache.CacheException {
        Assertions.checkState(!this.released);
        this.checkInitialization();
        SimpleCacheSpan span = this.getSpan(key, position);
        if (span.isCached) {
            if (!this.touchCacheSpans) {
                return span;
            }
            String fileName = Assertions.checkNotNull(span.file).getName();
            long length = span.length;
            long lastTouchTimestamp = System.currentTimeMillis();
            boolean updateFile = false;
            if (this.fileIndex != null) {
                try {
                    this.fileIndex.set(fileName, length, lastTouchTimestamp);
                }
                catch (IOException e) {
                    Log.w(TAG, "Failed to update index with new touch timestamp.");
                }
            } else {
                updateFile = true;
            }
            SimpleCacheSpan newSpan = this.contentIndex.get(key).setLastTouchTimestamp(span, lastTouchTimestamp, updateFile);
            this.notifySpanTouched(span, newSpan);
            return newSpan;
        }
        CachedContent cachedContent = this.contentIndex.getOrAdd(key);
        if (!cachedContent.isLocked()) {
            cachedContent.setLocked(true);
            return span;
        }
        return null;
    }

    @Override
    public synchronized File startFile(String key, long position, long length) throws Cache.CacheException {
        Assertions.checkState(!this.released);
        this.checkInitialization();
        CachedContent cachedContent = this.contentIndex.get(key);
        Assertions.checkNotNull(cachedContent);
        Assertions.checkState(cachedContent.isLocked());
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
            this.removeStaleSpans();
        }
        this.evictor.onStartFile(this, key, position, length);
        File fileDir = new File(this.cacheDir, Integer.toString(this.random.nextInt(10)));
        if (!fileDir.exists()) {
            fileDir.mkdir();
        }
        long lastTouchTimestamp = System.currentTimeMillis();
        return SimpleCacheSpan.getCacheFile(fileDir, cachedContent.id, position, lastTouchTimestamp);
    }

    @Override
    public synchronized void commitFile(File file, long length) throws Cache.CacheException {
        Assertions.checkState(!this.released);
        if (!file.exists()) {
            return;
        }
        if (length == 0L) {
            file.delete();
            return;
        }
        SimpleCacheSpan span = Assertions.checkNotNull(SimpleCacheSpan.createCacheEntry(file, length, this.contentIndex));
        CachedContent cachedContent = Assertions.checkNotNull(this.contentIndex.get(span.key));
        Assertions.checkState(cachedContent.isLocked());
        long contentLength = ContentMetadata.getContentLength(cachedContent.getMetadata());
        if (contentLength != -1L) {
            Assertions.checkState(span.position + span.length <= contentLength);
        }
        if (this.fileIndex != null) {
            String fileName = file.getName();
            try {
                this.fileIndex.set(fileName, span.length, span.lastTouchTimestamp);
            }
            catch (IOException e) {
                throw new Cache.CacheException(e);
            }
        }
        this.addSpan(span);
        try {
            this.contentIndex.store();
        }
        catch (IOException e) {
            throw new Cache.CacheException(e);
        }
        this.notifyAll();
    }

    @Override
    public synchronized void releaseHoleSpan(CacheSpan holeSpan) {
        Assertions.checkState(!this.released);
        CachedContent cachedContent = this.contentIndex.get(holeSpan.key);
        Assertions.checkNotNull(cachedContent);
        Assertions.checkState(cachedContent.isLocked());
        cachedContent.setLocked(false);
        this.contentIndex.maybeRemove(cachedContent.key);
        this.notifyAll();
    }

    @Override
    public synchronized void removeSpan(CacheSpan span) {
        Assertions.checkState(!this.released);
        this.removeSpanInternal(span);
    }

    @Override
    public synchronized boolean isCached(String key, long position, long length) {
        Assertions.checkState(!this.released);
        CachedContent cachedContent = this.contentIndex.get(key);
        return cachedContent != null && cachedContent.getCachedBytesLength(position, length) >= length;
    }

    @Override
    public synchronized long getCachedLength(String key, long position, long length) {
        Assertions.checkState(!this.released);
        CachedContent cachedContent = this.contentIndex.get(key);
        return cachedContent != null ? cachedContent.getCachedBytesLength(position, length) : -length;
    }

    @Override
    public synchronized void applyContentMetadataMutations(String key, ContentMetadataMutations mutations) throws Cache.CacheException {
        Assertions.checkState(!this.released);
        this.checkInitialization();
        this.contentIndex.applyContentMetadataMutations(key, mutations);
        try {
            this.contentIndex.store();
        }
        catch (IOException e) {
            throw new Cache.CacheException(e);
        }
    }

    @Override
    public synchronized ContentMetadata getContentMetadata(String key) {
        Assertions.checkState(!this.released);
        return this.contentIndex.getContentMetadata(key);
    }

    private SimpleCacheSpan getSpan(String key, long position) {
        SimpleCacheSpan span;
        CachedContent cachedContent = this.contentIndex.get(key);
        if (cachedContent == null) {
            return SimpleCacheSpan.createOpenHole(key, position);
        }
        while (true) {
            span = cachedContent.getSpan(position);
            if (!span.isCached || span.file.exists()) break;
            this.removeStaleSpans();
        }
        return span;
    }

    private void initialize() {
        if (!this.cacheDir.exists() && !this.cacheDir.mkdirs()) {
            String message = "Failed to create cache directory: " + this.cacheDir;
            Log.e(TAG, message);
            this.initializationException = new Cache.CacheException(message);
            return;
        }
        File[] files = this.cacheDir.listFiles();
        if (files == null) {
            String message = "Failed to list cache directory files: " + this.cacheDir;
            Log.e(TAG, message);
            this.initializationException = new Cache.CacheException(message);
            return;
        }
        this.uid = SimpleCache.loadUid(files);
        if (this.uid == -1L) {
            try {
                this.uid = SimpleCache.createUid(this.cacheDir);
            }
            catch (IOException e) {
                String message = "Failed to create cache UID: " + this.cacheDir;
                Log.e(TAG, message, e);
                this.initializationException = new Cache.CacheException(message, e);
                return;
            }
        }
        try {
            this.contentIndex.initialize(this.uid);
            if (this.fileIndex != null) {
                this.fileIndex.initialize(this.uid);
                Map<String, CacheFileMetadata> fileMetadata = this.fileIndex.getAll();
                this.loadDirectory(this.cacheDir, true, files, fileMetadata);
                this.fileIndex.removeAll(fileMetadata.keySet());
            } else {
                this.loadDirectory(this.cacheDir, true, files, null);
            }
        }
        catch (IOException e) {
            String message = "Failed to initialize cache indices: " + this.cacheDir;
            Log.e(TAG, message, e);
            this.initializationException = new Cache.CacheException(message, e);
            return;
        }
        this.contentIndex.removeEmpty();
        try {
            this.contentIndex.store();
        }
        catch (IOException e) {
            Log.e(TAG, "Storing index file failed", e);
        }
    }

    private void loadDirectory(File directory, boolean isRoot, @Nullable File[] files, @Nullable Map<String, CacheFileMetadata> fileMetadata) {
        if (files == null || files.length == 0) {
            if (!isRoot) {
                directory.delete();
            }
            return;
        }
        for (File file : files) {
            SimpleCacheSpan span;
            CacheFileMetadata metadata;
            String fileName = file.getName();
            if (isRoot && fileName.indexOf(46) == -1) {
                this.loadDirectory(file, false, file.listFiles(), fileMetadata);
                continue;
            }
            if (isRoot && (CachedContentIndex.isIndexFile(fileName) || fileName.endsWith(UID_FILE_SUFFIX))) continue;
            long length = -1L;
            long lastTouchTimestamp = -9223372036854775807L;
            CacheFileMetadata cacheFileMetadata = metadata = fileMetadata != null ? fileMetadata.remove(fileName) : null;
            if (metadata != null) {
                length = metadata.length;
                lastTouchTimestamp = metadata.lastTouchTimestamp;
            }
            if ((span = SimpleCacheSpan.createCacheEntry(file, length, lastTouchTimestamp, this.contentIndex)) != null) {
                this.addSpan(span);
                continue;
            }
            file.delete();
        }
    }

    private void addSpan(SimpleCacheSpan span) {
        this.contentIndex.getOrAdd(span.key).addSpan(span);
        this.totalSpace += span.length;
        this.notifySpanAdded(span);
    }

    private void removeSpanInternal(CacheSpan span) {
        CachedContent cachedContent = this.contentIndex.get(span.key);
        if (cachedContent == null || !cachedContent.removeSpan(span)) {
            return;
        }
        this.totalSpace -= span.length;
        if (this.fileIndex != null) {
            String fileName = span.file.getName();
            try {
                this.fileIndex.remove(fileName);
            }
            catch (IOException e) {
                Log.w(TAG, "Failed to remove file index entry for: " + fileName);
            }
        }
        this.contentIndex.maybeRemove(cachedContent.key);
        this.notifySpanRemoved(span);
    }

    private void removeStaleSpans() {
        ArrayList<CacheSpan> spansToBeRemoved = new ArrayList<CacheSpan>();
        for (CachedContent cachedContent : this.contentIndex.getAll()) {
            for (CacheSpan cacheSpan : cachedContent.getSpans()) {
                if (cacheSpan.file.exists()) continue;
                spansToBeRemoved.add(cacheSpan);
            }
        }
        for (int i = 0; i < spansToBeRemoved.size(); ++i) {
            this.removeSpanInternal((CacheSpan)spansToBeRemoved.get(i));
        }
    }

    private void notifySpanRemoved(CacheSpan span) {
        ArrayList<Cache.Listener> keyListeners = this.listeners.get(span.key);
        if (keyListeners != null) {
            for (int i = keyListeners.size() - 1; i >= 0; --i) {
                keyListeners.get(i).onSpanRemoved(this, span);
            }
        }
        this.evictor.onSpanRemoved(this, span);
    }

    private void notifySpanAdded(SimpleCacheSpan span) {
        ArrayList<Cache.Listener> keyListeners = this.listeners.get(span.key);
        if (keyListeners != null) {
            for (int i = keyListeners.size() - 1; i >= 0; --i) {
                keyListeners.get(i).onSpanAdded(this, span);
            }
        }
        this.evictor.onSpanAdded(this, span);
    }

    private void notifySpanTouched(SimpleCacheSpan oldSpan, CacheSpan newSpan) {
        ArrayList<Cache.Listener> keyListeners = this.listeners.get(oldSpan.key);
        if (keyListeners != null) {
            for (int i = keyListeners.size() - 1; i >= 0; --i) {
                keyListeners.get(i).onSpanTouched(this, oldSpan, newSpan);
            }
        }
        this.evictor.onSpanTouched(this, oldSpan, newSpan);
    }

    private static long loadUid(File[] files) {
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.endsWith(UID_FILE_SUFFIX)) continue;
            try {
                return SimpleCache.parseUid(fileName);
            }
            catch (NumberFormatException e) {
                Log.e(TAG, "Malformed UID file: " + file);
                file.delete();
            }
        }
        return -1L;
    }

    private static long createUid(File directory) throws IOException {
        long uid = new SecureRandom().nextLong();
        uid = uid == Long.MIN_VALUE ? 0L : Math.abs(uid);
        String hexUid = Long.toString(uid, 16);
        File hexUidFile = new File(directory, hexUid + UID_FILE_SUFFIX);
        if (!hexUidFile.createNewFile()) {
            throw new IOException("Failed to create UID file: " + hexUidFile);
        }
        return uid;
    }

    private static long parseUid(String fileName) {
        return Long.parseLong(fileName.substring(0, fileName.indexOf(46)), 16);
    }

    private static synchronized boolean lockFolder(File cacheDir) {
        if (cacheFolderLockingDisabled) {
            return true;
        }
        return lockedCacheDirs.add(cacheDir.getAbsoluteFile());
    }

    private static synchronized void unlockFolder(File cacheDir) {
        if (!cacheFolderLockingDisabled) {
            lockedCacheDirs.remove(cacheDir.getAbsoluteFile());
        }
    }
}

