/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.cache;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContentMetadataMutations {
    private final Map<String, Object> editedValues = new HashMap<String, Object>();
    private final List<String> removedValues = new ArrayList<String>();

    public static ContentMetadataMutations setContentLength(ContentMetadataMutations mutations, long length) {
        return mutations.set("exo_len", length);
    }

    public static ContentMetadataMutations setRedirectedUri(ContentMetadataMutations mutations, @Nullable Uri uri) {
        if (uri == null) {
            return mutations.remove("exo_redir");
        }
        return mutations.set("exo_redir", uri.toString());
    }

    public ContentMetadataMutations set(String name, String value) {
        return this.checkAndSet(name, value);
    }

    public ContentMetadataMutations set(String name, long value) {
        return this.checkAndSet(name, value);
    }

    public ContentMetadataMutations set(String name, byte[] value) {
        return this.checkAndSet(name, Arrays.copyOf(value, value.length));
    }

    public ContentMetadataMutations remove(String name) {
        this.removedValues.add(name);
        this.editedValues.remove(name);
        return this;
    }

    public List<String> getRemovedValues() {
        return Collections.unmodifiableList(new ArrayList<String>(this.removedValues));
    }

    public Map<String, Object> getEditedValues() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.editedValues);
        for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof byte[])) continue;
            byte[] bytes = (byte[])value;
            entry.setValue(Arrays.copyOf(bytes, bytes.length));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private ContentMetadataMutations checkAndSet(String name, Object value) {
        this.editedValues.put(Assertions.checkNotNull(name), Assertions.checkNotNull(value));
        this.removedValues.remove(name);
        return this;
    }
}

