/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.cache;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.cache.CacheSpan;
import com.google.android.exoplayer2.upstream.cache.ContentMetadataMutations;
import com.google.android.exoplayer2.upstream.cache.DefaultContentMetadata;
import com.google.android.exoplayer2.upstream.cache.SimpleCacheSpan;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import java.io.File;
import java.util.TreeSet;

final class CachedContent {
    private static final String TAG = "CachedContent";
    public final int id;
    public final String key;
    private final TreeSet<SimpleCacheSpan> cachedSpans;
    private DefaultContentMetadata metadata;
    private boolean locked;

    public CachedContent(int id, String key) {
        this(id, key, DefaultContentMetadata.EMPTY);
    }

    public CachedContent(int id, String key, DefaultContentMetadata metadata) {
        this.id = id;
        this.key = key;
        this.metadata = metadata;
        this.cachedSpans = new TreeSet();
    }

    public DefaultContentMetadata getMetadata() {
        return this.metadata;
    }

    public boolean applyMetadataMutations(ContentMetadataMutations mutations) {
        DefaultContentMetadata oldMetadata = this.metadata;
        this.metadata = this.metadata.copyWithMutationsApplied(mutations);
        return !this.metadata.equals(oldMetadata);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void addSpan(SimpleCacheSpan span) {
        this.cachedSpans.add(span);
    }

    public TreeSet<SimpleCacheSpan> getSpans() {
        return this.cachedSpans;
    }

    public SimpleCacheSpan getSpan(long position) {
        SimpleCacheSpan lookupSpan = SimpleCacheSpan.createLookup(this.key, position);
        SimpleCacheSpan floorSpan = this.cachedSpans.floor(lookupSpan);
        if (floorSpan != null && floorSpan.position + floorSpan.length > position) {
            return floorSpan;
        }
        SimpleCacheSpan ceilSpan = this.cachedSpans.ceiling(lookupSpan);
        return ceilSpan == null ? SimpleCacheSpan.createOpenHole(this.key, position) : SimpleCacheSpan.createClosedHole(this.key, position, ceilSpan.position - position);
    }

    public long getCachedBytesLength(long position, long length) {
        SimpleCacheSpan span = this.getSpan(position);
        if (span.isHoleSpan()) {
            return -Math.min(span.isOpenEnded() ? Long.MAX_VALUE : span.length, length);
        }
        long currentEndPosition = span.position + span.length;
        long queryEndPosition = position + length;
        if (currentEndPosition < queryEndPosition) {
            for (SimpleCacheSpan next : this.cachedSpans.tailSet(span, false)) {
                if (next.position <= currentEndPosition && (currentEndPosition = Math.max(currentEndPosition, next.position + next.length)) < queryEndPosition) continue;
                break;
            }
        }
        return Math.min(currentEndPosition - position, length);
    }

    public SimpleCacheSpan setLastTouchTimestamp(SimpleCacheSpan cacheSpan, long lastTouchTimestamp, boolean updateFile) {
        Assertions.checkState(this.cachedSpans.remove(cacheSpan));
        File file = cacheSpan.file;
        if (updateFile) {
            long position;
            File directory = file.getParentFile();
            File newFile = SimpleCacheSpan.getCacheFile(directory, this.id, position = cacheSpan.position, lastTouchTimestamp);
            if (file.renameTo(newFile)) {
                file = newFile;
            } else {
                Log.w(TAG, "Failed to rename " + file + " to " + newFile);
            }
        }
        SimpleCacheSpan newCacheSpan = cacheSpan.copyWithFileAndLastTouchTimestamp(file, lastTouchTimestamp);
        this.cachedSpans.add(newCacheSpan);
        return newCacheSpan;
    }

    public boolean isEmpty() {
        return this.cachedSpans.isEmpty();
    }

    public boolean removeSpan(CacheSpan span) {
        if (this.cachedSpans.remove(span)) {
            span.file.delete();
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.metadata.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachedContent that = (CachedContent)o;
        return this.id == that.id && this.key.equals(that.key) && this.cachedSpans.equals(that.cachedSpans) && this.metadata.equals(that.metadata);
    }
}

