/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.cache;

import android.net.Uri;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSource;
import com.google.android.exoplayer2.upstream.cache.CacheKeyFactory;
import com.google.android.exoplayer2.upstream.cache.CacheSpan;
import com.google.android.exoplayer2.upstream.cache.ContentMetadata;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.PriorityTaskManager;
import com.google.android.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.util.NavigableSet;
import java.util.concurrent.atomic.AtomicBoolean;

public final class CacheUtil {
    public static final int DEFAULT_BUFFER_SIZE_BYTES = 131072;
    public static final CacheKeyFactory DEFAULT_CACHE_KEY_FACTORY = dataSpec -> dataSpec.key != null ? dataSpec.key : CacheUtil.generateKey(dataSpec.uri);

    public static String generateKey(Uri uri) {
        return uri.toString();
    }

    public static Pair<Long, Long> getCached(DataSpec dataSpec, Cache cache, @Nullable CacheKeyFactory cacheKeyFactory) {
        long blockLength;
        long contentLength;
        String key = CacheUtil.buildCacheKey(dataSpec, cacheKeyFactory);
        long position = dataSpec.absoluteStreamPosition;
        long requestLength = dataSpec.length != -1L ? dataSpec.length : ((contentLength = ContentMetadata.getContentLength(cache.getContentMetadata(key))) == -1L ? -1L : contentLength - position);
        long bytesAlreadyCached = 0L;
        for (long bytesLeft = requestLength; bytesLeft != 0L; bytesLeft -= bytesLeft == -1L ? 0L : blockLength) {
            blockLength = cache.getCachedLength(key, position, bytesLeft != -1L ? bytesLeft : Long.MAX_VALUE);
            if (blockLength > 0L) {
                bytesAlreadyCached += blockLength;
            } else if ((blockLength = -blockLength) == Long.MAX_VALUE) break;
            position += blockLength;
        }
        return Pair.create((Object)requestLength, (Object)bytesAlreadyCached);
    }

    public static void cache(DataSpec dataSpec, Cache cache, @Nullable CacheKeyFactory cacheKeyFactory, DataSource upstream, @Nullable ProgressListener progressListener, @Nullable AtomicBoolean isCanceled) throws IOException, InterruptedException {
        CacheUtil.cache(dataSpec, cache, cacheKeyFactory, new CacheDataSource(cache, upstream), new byte[131072], null, 0, progressListener, isCanceled, false);
    }

    public static void cache(DataSpec dataSpec, Cache cache, @Nullable CacheKeyFactory cacheKeyFactory, CacheDataSource dataSource, byte[] buffer, PriorityTaskManager priorityTaskManager, int priority, @Nullable ProgressListener progressListener, @Nullable AtomicBoolean isCanceled, boolean enableEOFException) throws IOException, InterruptedException {
        long bytesLeft;
        Assertions.checkNotNull(dataSource);
        Assertions.checkNotNull(buffer);
        ProgressNotifier progressNotifier = null;
        if (progressListener != null) {
            progressNotifier = new ProgressNotifier(progressListener);
            Pair<Long, Long> lengthAndBytesAlreadyCached = CacheUtil.getCached(dataSpec, cache, cacheKeyFactory);
            progressNotifier.init((Long)lengthAndBytesAlreadyCached.first, (Long)lengthAndBytesAlreadyCached.second);
        }
        String key = CacheUtil.buildCacheKey(dataSpec, cacheKeyFactory);
        long position = dataSpec.absoluteStreamPosition;
        if (dataSpec.length != -1L) {
            bytesLeft = dataSpec.length;
        } else {
            long contentLength = ContentMetadata.getContentLength(cache.getContentMetadata(key));
            long l = bytesLeft = contentLength == -1L ? -1L : contentLength - position;
        }
        while (bytesLeft != 0L) {
            long read;
            CacheUtil.throwExceptionIfInterruptedOrCancelled(isCanceled);
            long blockLength = cache.getCachedLength(key, position, bytesLeft != -1L ? bytesLeft : Long.MAX_VALUE);
            if (blockLength <= 0L && (read = CacheUtil.readAndDiscard(dataSpec, position, blockLength = -blockLength, dataSource, buffer, priorityTaskManager, priority, progressNotifier, isCanceled)) < blockLength) {
                if (!enableEOFException || bytesLeft == -1L) break;
                throw new EOFException();
            }
            position += blockLength;
            bytesLeft -= bytesLeft == -1L ? 0L : blockLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long readAndDiscard(DataSpec dataSpec, long absoluteStreamPosition, long length, DataSource dataSource, byte[] buffer, PriorityTaskManager priorityTaskManager, int priority, @Nullable ProgressNotifier progressNotifier, AtomicBoolean isCanceled) throws IOException, InterruptedException {
        long positionOffset = absoluteStreamPosition - dataSpec.absoluteStreamPosition;
        while (true) {
            if (priorityTaskManager != null) {
                priorityTaskManager.proceed(priority);
            }
            try {
                long totalBytesRead;
                int bytesRead;
                CacheUtil.throwExceptionIfInterruptedOrCancelled(isCanceled);
                dataSpec = new DataSpec(dataSpec.uri, dataSpec.httpMethod, dataSpec.httpBody, absoluteStreamPosition, dataSpec.position + positionOffset, -1L, dataSpec.key, dataSpec.flags);
                long resolvedLength = dataSource.open(dataSpec);
                if (progressNotifier != null && resolvedLength != -1L) {
                    progressNotifier.onRequestLengthResolved(positionOffset + resolvedLength);
                }
                for (totalBytesRead = 0L; totalBytesRead != length; totalBytesRead += (long)bytesRead) {
                    CacheUtil.throwExceptionIfInterruptedOrCancelled(isCanceled);
                    bytesRead = dataSource.read(buffer, 0, length != -1L ? (int)Math.min((long)buffer.length, length - totalBytesRead) : buffer.length);
                    if (bytesRead != -1) continue;
                    if (progressNotifier == null) break;
                    progressNotifier.onRequestLengthResolved(positionOffset + totalBytesRead);
                    break;
                }
                long l = totalBytesRead;
                return l;
            }
            catch (PriorityTaskManager.PriorityTooLowException priorityTooLowException) {}
            continue;
            finally {
                Util.closeQuietly(dataSource);
                continue;
            }
            break;
        }
    }

    public static void remove(DataSpec dataSpec, Cache cache, @Nullable CacheKeyFactory cacheKeyFactory) {
        CacheUtil.remove(cache, CacheUtil.buildCacheKey(dataSpec, cacheKeyFactory));
    }

    public static void remove(Cache cache, String key) {
        NavigableSet<CacheSpan> cachedSpans = cache.getCachedSpans(key);
        for (CacheSpan cachedSpan : cachedSpans) {
            try {
                cache.removeSpan(cachedSpan);
            }
            catch (Cache.CacheException cacheException) {}
        }
    }

    private static String buildCacheKey(DataSpec dataSpec, @Nullable CacheKeyFactory cacheKeyFactory) {
        return (cacheKeyFactory != null ? cacheKeyFactory : DEFAULT_CACHE_KEY_FACTORY).buildCacheKey(dataSpec);
    }

    private static void throwExceptionIfInterruptedOrCancelled(AtomicBoolean isCanceled) throws InterruptedException {
        if (Thread.interrupted() || isCanceled != null && isCanceled.get()) {
            throw new InterruptedException();
        }
    }

    private CacheUtil() {
    }

    private static final class ProgressNotifier {
        private final ProgressListener listener;
        private long requestLength;
        private long bytesCached;

        public ProgressNotifier(ProgressListener listener) {
            this.listener = listener;
        }

        public void init(long requestLength, long bytesCached) {
            this.requestLength = requestLength;
            this.bytesCached = bytesCached;
            this.listener.onProgress(requestLength, bytesCached, 0L);
        }

        public void onRequestLengthResolved(long requestLength) {
            if (this.requestLength == -1L && requestLength != -1L) {
                this.requestLength = requestLength;
                this.listener.onProgress(requestLength, this.bytesCached, 0L);
            }
        }

        public void onBytesCached(long newBytesCached) {
            this.bytesCached += newBytesCached;
            this.listener.onProgress(this.requestLength, this.bytesCached, newBytesCached);
        }
    }

    public static interface ProgressListener {
        public void onProgress(long var1, long var3, long var5);
    }
}

