/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.cache;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import com.google.android.exoplayer2.database.DatabaseIOException;
import com.google.android.exoplayer2.database.DatabaseProvider;
import com.google.android.exoplayer2.database.VersionTable;
import com.google.android.exoplayer2.upstream.cache.CacheFileMetadata;
import com.google.android.exoplayer2.util.Assertions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class CacheFileMetadataIndex {
    private static final String TABLE_PREFIX = "ExoPlayerCacheFileMetadata";
    private static final int TABLE_VERSION = 1;
    private static final String COLUMN_NAME = "name";
    private static final String COLUMN_LENGTH = "length";
    private static final String COLUMN_LAST_TOUCH_TIMESTAMP = "last_touch_timestamp";
    private static final int COLUMN_INDEX_NAME = 0;
    private static final int COLUMN_INDEX_LENGTH = 1;
    private static final int COLUMN_INDEX_LAST_TOUCH_TIMESTAMP = 2;
    private static final String WHERE_NAME_EQUALS = "0 = ?";
    private static final String[] COLUMNS = new String[]{"name", "length", "last_touch_timestamp"};
    private static final String TABLE_SCHEMA = "(name TEXT PRIMARY KEY NOT NULL,length INTEGER NOT NULL,last_touch_timestamp INTEGER NOT NULL)";
    private final DatabaseProvider databaseProvider;
    private @MonotonicNonNull String tableName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(DatabaseProvider databaseProvider, long uid) throws DatabaseIOException {
        String hexUid = Long.toHexString(uid);
        try {
            String tableName = CacheFileMetadataIndex.getTableName(hexUid);
            SQLiteDatabase writableDatabase = databaseProvider.getWritableDatabase();
            writableDatabase.beginTransaction();
            try {
                VersionTable.removeVersion(writableDatabase, 2, hexUid);
                CacheFileMetadataIndex.dropTable(writableDatabase, tableName);
                writableDatabase.setTransactionSuccessful();
            }
            finally {
                writableDatabase.endTransaction();
            }
        }
        catch (SQLException e) {
            throw new DatabaseIOException(e);
        }
    }

    public CacheFileMetadataIndex(DatabaseProvider databaseProvider) {
        this.databaseProvider = databaseProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(long uid) throws DatabaseIOException {
        block5: {
            try {
                String hexUid = Long.toHexString(uid);
                this.tableName = CacheFileMetadataIndex.getTableName(hexUid);
                SQLiteDatabase readableDatabase = this.databaseProvider.getReadableDatabase();
                int version = VersionTable.getVersion(readableDatabase, 2, hexUid);
                if (version == 1) break block5;
                SQLiteDatabase writableDatabase = this.databaseProvider.getWritableDatabase();
                writableDatabase.beginTransaction();
                try {
                    VersionTable.setVersion(writableDatabase, 2, hexUid, 1);
                    CacheFileMetadataIndex.dropTable(writableDatabase, this.tableName);
                    writableDatabase.execSQL("CREATE TABLE " + this.tableName + " " + TABLE_SCHEMA);
                    writableDatabase.setTransactionSuccessful();
                }
                finally {
                    writableDatabase.endTransaction();
                }
            }
            catch (SQLException e) {
                throw new DatabaseIOException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, CacheFileMetadata> getAll() throws DatabaseIOException {
        try (Cursor cursor = this.getCursor();){
            HashMap<String, CacheFileMetadata> fileMetadata = new HashMap<String, CacheFileMetadata>(cursor.getCount());
            while (cursor.moveToNext()) {
                String name = cursor.getString(0);
                long length = cursor.getLong(1);
                long lastTouchTimestamp = cursor.getLong(2);
                fileMetadata.put(name, new CacheFileMetadata(length, lastTouchTimestamp));
            }
            HashMap<String, CacheFileMetadata> hashMap = fileMetadata;
            return hashMap;
        }
        catch (SQLException e) {
            throw new DatabaseIOException(e);
        }
    }

    public void set(String name, long length, long lastTouchTimestamp) throws DatabaseIOException {
        Assertions.checkNotNull(this.tableName);
        try {
            SQLiteDatabase writableDatabase = this.databaseProvider.getWritableDatabase();
            ContentValues values = new ContentValues();
            values.put(COLUMN_NAME, name);
            values.put(COLUMN_LENGTH, Long.valueOf(length));
            values.put(COLUMN_LAST_TOUCH_TIMESTAMP, Long.valueOf(lastTouchTimestamp));
            writableDatabase.replaceOrThrow(this.tableName, null, values);
        }
        catch (SQLException e) {
            throw new DatabaseIOException(e);
        }
    }

    public void remove(String name) throws DatabaseIOException {
        Assertions.checkNotNull(this.tableName);
        try {
            SQLiteDatabase writableDatabase = this.databaseProvider.getWritableDatabase();
            writableDatabase.delete(this.tableName, WHERE_NAME_EQUALS, new String[]{name});
        }
        catch (SQLException e) {
            throw new DatabaseIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Set<String> names) throws DatabaseIOException {
        Assertions.checkNotNull(this.tableName);
        try {
            SQLiteDatabase writableDatabase = this.databaseProvider.getWritableDatabase();
            writableDatabase.beginTransaction();
            try {
                for (String name : names) {
                    writableDatabase.delete(this.tableName, WHERE_NAME_EQUALS, new String[]{name});
                }
                writableDatabase.setTransactionSuccessful();
            }
            finally {
                writableDatabase.endTransaction();
            }
        }
        catch (SQLException e) {
            throw new DatabaseIOException(e);
        }
    }

    private Cursor getCursor() {
        Assertions.checkNotNull(this.tableName);
        return this.databaseProvider.getReadableDatabase().query(this.tableName, COLUMNS, null, null, null, null, null);
    }

    private static void dropTable(SQLiteDatabase writableDatabase, String tableName) {
        writableDatabase.execSQL("DROP TABLE IF EXISTS " + tableName);
    }

    private static String getTableName(String hexUid) {
        return TABLE_PREFIX + hexUid;
    }
}

