/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.cache;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.DataSink;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSourceException;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.FileDataSource;
import com.google.android.exoplayer2.upstream.TeeDataSource;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSink;
import com.google.android.exoplayer2.upstream.cache.CacheKeyFactory;
import com.google.android.exoplayer2.upstream.cache.CacheSpan;
import com.google.android.exoplayer2.upstream.cache.CacheUtil;
import com.google.android.exoplayer2.upstream.cache.ContentMetadata;
import com.google.android.exoplayer2.upstream.cache.ContentMetadataMutations;
import com.google.android.exoplayer2.util.Assertions;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class CacheDataSource
implements DataSource {
    public static final int FLAG_BLOCK_ON_CACHE = 1;
    public static final int FLAG_IGNORE_CACHE_ON_ERROR = 2;
    public static final int FLAG_IGNORE_CACHE_FOR_UNSET_LENGTH_REQUESTS = 4;
    private static final int CACHE_NOT_IGNORED = -1;
    public static final int CACHE_IGNORED_REASON_ERROR = 0;
    public static final int CACHE_IGNORED_REASON_UNSET_LENGTH = 1;
    private static final long MIN_READ_BEFORE_CHECKING_CACHE = 102400L;
    private final Cache cache;
    private final DataSource cacheReadDataSource;
    @Nullable
    private final DataSource cacheWriteDataSource;
    private final DataSource upstreamDataSource;
    private final CacheKeyFactory cacheKeyFactory;
    @Nullable
    private final EventListener eventListener;
    private final boolean blockOnCache;
    private final boolean ignoreCacheOnError;
    private final boolean ignoreCacheForUnsetLengthRequests;
    @Nullable
    private DataSource currentDataSource;
    private boolean currentDataSpecLengthUnset;
    @Nullable
    private Uri uri;
    @Nullable
    private Uri actualUri;
    private int httpMethod;
    private int flags;
    @Nullable
    private String key;
    private long readPosition;
    private long bytesRemaining;
    @Nullable
    private CacheSpan currentHoleSpan;
    private boolean seenCacheError;
    private boolean currentRequestIgnoresCache;
    private long totalCachedBytesRead;
    private long checkCachePosition;

    public CacheDataSource(Cache cache, DataSource upstream) {
        this(cache, upstream, 0);
    }

    public CacheDataSource(Cache cache, DataSource upstream, int flags) {
        this(cache, upstream, new FileDataSource(), new CacheDataSink(cache, 0x500000L), flags, null);
    }

    public CacheDataSource(Cache cache, DataSource upstream, DataSource cacheReadDataSource, @Nullable DataSink cacheWriteDataSink, int flags, @Nullable EventListener eventListener) {
        this(cache, upstream, cacheReadDataSource, cacheWriteDataSink, flags, eventListener, null);
    }

    public CacheDataSource(Cache cache, DataSource upstream, DataSource cacheReadDataSource, @Nullable DataSink cacheWriteDataSink, int flags, @Nullable EventListener eventListener, @Nullable CacheKeyFactory cacheKeyFactory) {
        this.cache = cache;
        this.cacheReadDataSource = cacheReadDataSource;
        this.cacheKeyFactory = cacheKeyFactory != null ? cacheKeyFactory : CacheUtil.DEFAULT_CACHE_KEY_FACTORY;
        this.blockOnCache = (flags & 1) != 0;
        this.ignoreCacheOnError = (flags & 2) != 0;
        this.ignoreCacheForUnsetLengthRequests = (flags & 4) != 0;
        this.upstreamDataSource = upstream;
        this.cacheWriteDataSource = cacheWriteDataSink != null ? new TeeDataSource(upstream, cacheWriteDataSink) : null;
        this.eventListener = eventListener;
    }

    @Override
    public void addTransferListener(TransferListener transferListener) {
        this.cacheReadDataSource.addTransferListener(transferListener);
        this.upstreamDataSource.addTransferListener(transferListener);
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        try {
            this.key = this.cacheKeyFactory.buildCacheKey(dataSpec);
            this.uri = dataSpec.uri;
            this.actualUri = CacheDataSource.getRedirectedUriOrDefault(this.cache, this.key, this.uri);
            this.httpMethod = dataSpec.httpMethod;
            this.flags = dataSpec.flags;
            this.readPosition = dataSpec.position;
            int reason = this.shouldIgnoreCacheForRequest(dataSpec);
            boolean bl = this.currentRequestIgnoresCache = reason != -1;
            if (this.currentRequestIgnoresCache) {
                this.notifyCacheIgnored(reason);
            }
            if (dataSpec.length != -1L || this.currentRequestIgnoresCache) {
                this.bytesRemaining = dataSpec.length;
            } else {
                this.bytesRemaining = ContentMetadata.getContentLength(this.cache.getContentMetadata(this.key));
                if (this.bytesRemaining != -1L) {
                    this.bytesRemaining -= dataSpec.position;
                    if (this.bytesRemaining <= 0L) {
                        throw new DataSourceException(0);
                    }
                }
            }
            this.openNextSource(false);
            return this.bytesRemaining;
        }
        catch (IOException e) {
            this.handleBeforeThrow(e);
            throw e;
        }
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) throws IOException {
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        try {
            int bytesRead;
            if (this.readPosition >= this.checkCachePosition) {
                this.openNextSource(true);
            }
            if ((bytesRead = this.currentDataSource.read(buffer, offset, readLength)) != -1) {
                if (this.isReadingFromCache()) {
                    this.totalCachedBytesRead += (long)bytesRead;
                }
                this.readPosition += (long)bytesRead;
                if (this.bytesRemaining != -1L) {
                    this.bytesRemaining -= (long)bytesRead;
                }
            } else if (this.currentDataSpecLengthUnset) {
                this.setNoBytesRemainingAndMaybeStoreLength();
            } else if (this.bytesRemaining > 0L || this.bytesRemaining == -1L) {
                this.closeCurrentSource();
                this.openNextSource(false);
                return this.read(buffer, offset, readLength);
            }
            return bytesRead;
        }
        catch (IOException e) {
            if (this.currentDataSpecLengthUnset && CacheDataSource.isCausedByPositionOutOfRange(e)) {
                this.setNoBytesRemainingAndMaybeStoreLength();
                return -1;
            }
            this.handleBeforeThrow(e);
            throw e;
        }
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.actualUri;
    }

    @Override
    public Map<String, List<String>> getResponseHeaders() {
        return this.isReadingFromUpstream() ? this.upstreamDataSource.getResponseHeaders() : Collections.emptyMap();
    }

    @Override
    public void close() throws IOException {
        this.uri = null;
        this.actualUri = null;
        this.httpMethod = 1;
        this.notifyBytesRead();
        try {
            this.closeCurrentSource();
        }
        catch (IOException e) {
            this.handleBeforeThrow(e);
            throw e;
        }
    }

    private void openNextSource(boolean checkCache) throws IOException {
        DataSpec nextDataSpec;
        DataSource nextDataSource;
        CacheSpan nextSpan;
        if (this.currentRequestIgnoresCache) {
            nextSpan = null;
        } else if (this.blockOnCache) {
            try {
                nextSpan = this.cache.startReadWrite(this.key, this.readPosition);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        } else {
            nextSpan = this.cache.startReadWriteNonBlocking(this.key, this.readPosition);
        }
        if (nextSpan == null) {
            nextDataSource = this.upstreamDataSource;
            nextDataSpec = new DataSpec(this.uri, this.httpMethod, null, this.readPosition, this.readPosition, this.bytesRemaining, this.key, this.flags);
        } else if (nextSpan.isCached) {
            Uri fileUri = Uri.fromFile((File)nextSpan.file);
            long filePosition = this.readPosition - nextSpan.position;
            long length = nextSpan.length - filePosition;
            if (this.bytesRemaining != -1L) {
                length = Math.min(length, this.bytesRemaining);
            }
            nextDataSpec = new DataSpec(fileUri, this.readPosition, filePosition, length, this.key, this.flags);
            nextDataSource = this.cacheReadDataSource;
        } else {
            long length;
            if (nextSpan.isOpenEnded()) {
                length = this.bytesRemaining;
            } else {
                length = nextSpan.length;
                if (this.bytesRemaining != -1L) {
                    length = Math.min(length, this.bytesRemaining);
                }
            }
            nextDataSpec = new DataSpec(this.uri, this.httpMethod, null, this.readPosition, this.readPosition, length, this.key, this.flags);
            if (this.cacheWriteDataSource != null) {
                nextDataSource = this.cacheWriteDataSource;
            } else {
                nextDataSource = this.upstreamDataSource;
                this.cache.releaseHoleSpan(nextSpan);
                nextSpan = null;
            }
        }
        long l = this.checkCachePosition = !this.currentRequestIgnoresCache && nextDataSource == this.upstreamDataSource ? this.readPosition + 102400L : Long.MAX_VALUE;
        if (checkCache) {
            Assertions.checkState(this.isBypassingCache());
            if (nextDataSource == this.upstreamDataSource) {
                return;
            }
            try {
                this.closeCurrentSource();
            }
            catch (Throwable e) {
                if (nextSpan.isHoleSpan()) {
                    this.cache.releaseHoleSpan(nextSpan);
                }
                throw e;
            }
        }
        if (nextSpan != null && nextSpan.isHoleSpan()) {
            this.currentHoleSpan = nextSpan;
        }
        this.currentDataSource = nextDataSource;
        this.currentDataSpecLengthUnset = nextDataSpec.length == -1L;
        long resolvedLength = nextDataSource.open(nextDataSpec);
        ContentMetadataMutations mutations = new ContentMetadataMutations();
        if (this.currentDataSpecLengthUnset && resolvedLength != -1L) {
            this.bytesRemaining = resolvedLength;
            ContentMetadataMutations.setContentLength(mutations, this.readPosition + this.bytesRemaining);
        }
        if (this.isReadingFromUpstream()) {
            this.actualUri = this.currentDataSource.getUri();
            boolean isRedirected = !this.uri.equals((Object)this.actualUri);
            ContentMetadataMutations.setRedirectedUri(mutations, isRedirected ? this.actualUri : null);
        }
        if (this.isWritingToCache()) {
            this.cache.applyContentMetadataMutations(this.key, mutations);
        }
    }

    private void setNoBytesRemainingAndMaybeStoreLength() throws IOException {
        this.bytesRemaining = 0L;
        if (this.isWritingToCache()) {
            ContentMetadataMutations mutations = new ContentMetadataMutations();
            ContentMetadataMutations.setContentLength(mutations, this.readPosition);
            this.cache.applyContentMetadataMutations(this.key, mutations);
        }
    }

    private static Uri getRedirectedUriOrDefault(Cache cache, String key, Uri defaultUri) {
        Uri redirectedUri = ContentMetadata.getRedirectedUri(cache.getContentMetadata(key));
        return redirectedUri != null ? redirectedUri : defaultUri;
    }

    private static boolean isCausedByPositionOutOfRange(IOException e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            int reason;
            if (!(cause instanceof DataSourceException) || (reason = ((DataSourceException)cause).reason) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean isReadingFromUpstream() {
        return !this.isReadingFromCache();
    }

    private boolean isBypassingCache() {
        return this.currentDataSource == this.upstreamDataSource;
    }

    private boolean isReadingFromCache() {
        return this.currentDataSource == this.cacheReadDataSource;
    }

    private boolean isWritingToCache() {
        return this.currentDataSource == this.cacheWriteDataSource;
    }

    private void closeCurrentSource() throws IOException {
        if (this.currentDataSource == null) {
            return;
        }
        try {
            this.currentDataSource.close();
        }
        finally {
            this.currentDataSource = null;
            this.currentDataSpecLengthUnset = false;
            if (this.currentHoleSpan != null) {
                this.cache.releaseHoleSpan(this.currentHoleSpan);
                this.currentHoleSpan = null;
            }
        }
    }

    private void handleBeforeThrow(IOException exception) {
        if (this.isReadingFromCache() || exception instanceof Cache.CacheException) {
            this.seenCacheError = true;
        }
    }

    private int shouldIgnoreCacheForRequest(DataSpec dataSpec) {
        if (this.ignoreCacheOnError && this.seenCacheError) {
            return 0;
        }
        if (this.ignoreCacheForUnsetLengthRequests && dataSpec.length == -1L) {
            return 1;
        }
        return -1;
    }

    private void notifyCacheIgnored(int reason) {
        if (this.eventListener != null) {
            this.eventListener.onCacheIgnored(reason);
        }
    }

    private void notifyBytesRead() {
        if (this.eventListener != null && this.totalCachedBytesRead > 0L) {
            this.eventListener.onCachedBytesRead(this.cache.getCacheSpace(), this.totalCachedBytesRead);
            this.totalCachedBytesRead = 0L;
        }
    }

    public static interface EventListener {
        public void onCachedBytesRead(long var1, long var3);

        public void onCacheIgnored(int var1);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CacheIgnoredReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

