/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.cache;

import com.google.android.exoplayer2.upstream.DataSink;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ReusableBufferedOutputStream;
import com.google.android.exoplayer2.util.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class CacheDataSink
implements DataSink {
    public static final long DEFAULT_FRAGMENT_SIZE = 0x500000L;
    public static final int DEFAULT_BUFFER_SIZE = 20480;
    private static final long MIN_RECOMMENDED_FRAGMENT_SIZE = 0x200000L;
    private static final String TAG = "CacheDataSink";
    private final Cache cache;
    private final long fragmentSize;
    private final int bufferSize;
    private boolean syncFileDescriptor;
    private DataSpec dataSpec;
    private long dataSpecFragmentSize;
    private File file;
    private OutputStream outputStream;
    private FileOutputStream underlyingFileOutputStream;
    private long outputStreamBytesWritten;
    private long dataSpecBytesWritten;
    private ReusableBufferedOutputStream bufferedOutputStream;

    public CacheDataSink(Cache cache, long fragmentSize) {
        this(cache, fragmentSize, 20480);
    }

    public CacheDataSink(Cache cache, long fragmentSize, int bufferSize) {
        Assertions.checkState(fragmentSize > 0L || fragmentSize == -1L, "fragmentSize must be positive or C.LENGTH_UNSET.");
        if (fragmentSize != -1L && fragmentSize < 0x200000L) {
            Log.w(TAG, "fragmentSize is below the minimum recommended value of 2097152. This may cause poor cache performance.");
        }
        this.cache = Assertions.checkNotNull(cache);
        this.fragmentSize = fragmentSize == -1L ? Long.MAX_VALUE : fragmentSize;
        this.bufferSize = bufferSize;
        this.syncFileDescriptor = true;
    }

    public void experimental_setSyncFileDescriptor(boolean syncFileDescriptor) {
        this.syncFileDescriptor = syncFileDescriptor;
    }

    @Override
    public void open(DataSpec dataSpec) throws CacheDataSinkException {
        if (dataSpec.length == -1L && dataSpec.isFlagSet(4)) {
            this.dataSpec = null;
            return;
        }
        this.dataSpec = dataSpec;
        this.dataSpecFragmentSize = dataSpec.isFlagSet(16) ? this.fragmentSize : Long.MAX_VALUE;
        this.dataSpecBytesWritten = 0L;
        try {
            this.openNextOutputStream();
        }
        catch (IOException e) {
            throw new CacheDataSinkException(e);
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws CacheDataSinkException {
        if (this.dataSpec == null) {
            return;
        }
        try {
            int bytesWritten = 0;
            while (bytesWritten < length) {
                if (this.outputStreamBytesWritten == this.dataSpecFragmentSize) {
                    this.closeCurrentOutputStream();
                    this.openNextOutputStream();
                }
                int bytesToWrite = (int)Math.min((long)(length - bytesWritten), this.dataSpecFragmentSize - this.outputStreamBytesWritten);
                this.outputStream.write(buffer, offset + bytesWritten, bytesToWrite);
                bytesWritten += bytesToWrite;
                this.outputStreamBytesWritten += (long)bytesToWrite;
                this.dataSpecBytesWritten += (long)bytesToWrite;
            }
        }
        catch (IOException e) {
            throw new CacheDataSinkException(e);
        }
    }

    @Override
    public void close() throws CacheDataSinkException {
        if (this.dataSpec == null) {
            return;
        }
        try {
            this.closeCurrentOutputStream();
        }
        catch (IOException e) {
            throw new CacheDataSinkException(e);
        }
    }

    private void openNextOutputStream() throws IOException {
        long length = this.dataSpec.length == -1L ? -1L : Math.min(this.dataSpec.length - this.dataSpecBytesWritten, this.dataSpecFragmentSize);
        this.file = this.cache.startFile(this.dataSpec.key, this.dataSpec.absoluteStreamPosition + this.dataSpecBytesWritten, length);
        this.underlyingFileOutputStream = new FileOutputStream(this.file);
        if (this.bufferSize > 0) {
            if (this.bufferedOutputStream == null) {
                this.bufferedOutputStream = new ReusableBufferedOutputStream(this.underlyingFileOutputStream, this.bufferSize);
            } else {
                this.bufferedOutputStream.reset(this.underlyingFileOutputStream);
            }
            this.outputStream = this.bufferedOutputStream;
        } else {
            this.outputStream = this.underlyingFileOutputStream;
        }
        this.outputStreamBytesWritten = 0L;
    }

    private void closeCurrentOutputStream() throws IOException {
        if (this.outputStream == null) {
            return;
        }
        boolean success = false;
        try {
            this.outputStream.flush();
            if (this.syncFileDescriptor) {
                this.underlyingFileOutputStream.getFD().sync();
            }
            success = true;
        }
        finally {
            Util.closeQuietly(this.outputStream);
            this.outputStream = null;
            File fileToCommit = this.file;
            this.file = null;
            if (success) {
                this.cache.commitFile(fileToCommit, this.outputStreamBytesWritten);
            } else {
                fileToCommit.delete();
            }
        }
    }

    public static class CacheDataSinkException
    extends Cache.CacheException {
        public CacheDataSinkException(IOException cause) {
            super(cause);
        }
    }
}

