/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import com.google.android.exoplayer2.upstream.DataSink;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Assertions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class ByteArrayDataSink
implements DataSink {
    private ByteArrayOutputStream stream;

    @Override
    public void open(DataSpec dataSpec) throws IOException {
        if (dataSpec.length == -1L) {
            this.stream = new ByteArrayOutputStream();
        } else {
            Assertions.checkArgument(dataSpec.length <= Integer.MAX_VALUE);
            this.stream = new ByteArrayOutputStream((int)dataSpec.length);
        }
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.stream.write(buffer, offset, length);
    }

    public byte[] getData() {
        return this.stream == null ? null : this.stream.toByteArray();
    }
}

