/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.source.chunk.MediaChunkIterator;
import com.google.android.exoplayer2.trackselection.TrackBitrateEstimator;
import com.google.android.exoplayer2.trackselection.TrackSelectionUtil;
import java.util.List;

public final class WindowedTrackBitrateEstimator
implements TrackBitrateEstimator {
    private final long maxPastDurationUs;
    private final long maxFutureDurationUs;
    private final boolean useFormatBitrateAsLowerBound;

    public WindowedTrackBitrateEstimator(long maxPastDurationMs, long maxFutureDurationMs, boolean useFormatBitrateAsLowerBound) {
        this.maxPastDurationUs = C.msToUs(maxPastDurationMs);
        this.maxFutureDurationUs = C.msToUs(maxFutureDurationMs);
        this.useFormatBitrateAsLowerBound = useFormatBitrateAsLowerBound;
    }

    @Override
    public int[] getBitrates(Format[] formats, List<? extends MediaChunk> queue, MediaChunkIterator[] iterators, @Nullable int[] bitrates) {
        if (this.maxFutureDurationUs > 0L || this.maxPastDurationUs > 0L) {
            return TrackSelectionUtil.getBitratesUsingPastAndFutureInfo(formats, queue, this.maxPastDurationUs, iterators, this.maxFutureDurationUs, this.useFormatBitrateAsLowerBound, bitrates);
        }
        return TrackSelectionUtil.getFormatBitrates(formats, bitrates);
    }
}

