/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Util;

public class TrackSelectionParameters
implements Parcelable {
    public static final TrackSelectionParameters DEFAULT = new TrackSelectionParameters();
    @Nullable
    public final String preferredAudioLanguage;
    @Nullable
    public final String preferredTextLanguage;
    public final boolean selectUndeterminedTextLanguage;
    public final int disabledTextTrackSelectionFlags;
    public static final Parcelable.Creator<TrackSelectionParameters> CREATOR = new Parcelable.Creator<TrackSelectionParameters>(){

        public TrackSelectionParameters createFromParcel(Parcel in) {
            return new TrackSelectionParameters(in);
        }

        public TrackSelectionParameters[] newArray(int size) {
            return new TrackSelectionParameters[size];
        }
    };

    TrackSelectionParameters() {
        this(null, null, false, 0);
    }

    TrackSelectionParameters(@Nullable String preferredAudioLanguage, @Nullable String preferredTextLanguage, boolean selectUndeterminedTextLanguage, int disabledTextTrackSelectionFlags) {
        this.preferredAudioLanguage = Util.normalizeLanguageCode(preferredAudioLanguage);
        this.preferredTextLanguage = Util.normalizeLanguageCode(preferredTextLanguage);
        this.selectUndeterminedTextLanguage = selectUndeterminedTextLanguage;
        this.disabledTextTrackSelectionFlags = disabledTextTrackSelectionFlags;
    }

    TrackSelectionParameters(Parcel in) {
        this.preferredAudioLanguage = in.readString();
        this.preferredTextLanguage = in.readString();
        this.selectUndeterminedTextLanguage = Util.readBoolean(in);
        this.disabledTextTrackSelectionFlags = in.readInt();
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrackSelectionParameters other = (TrackSelectionParameters)obj;
        return TextUtils.equals((CharSequence)this.preferredAudioLanguage, (CharSequence)other.preferredAudioLanguage) && TextUtils.equals((CharSequence)this.preferredTextLanguage, (CharSequence)other.preferredTextLanguage) && this.selectUndeterminedTextLanguage == other.selectUndeterminedTextLanguage && this.disabledTextTrackSelectionFlags == other.disabledTextTrackSelectionFlags;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.preferredAudioLanguage == null ? 0 : this.preferredAudioLanguage.hashCode());
        result = 31 * result + (this.preferredTextLanguage == null ? 0 : this.preferredTextLanguage.hashCode());
        result = 31 * result + (this.selectUndeterminedTextLanguage ? 1 : 0);
        result = 31 * result + this.disabledTextTrackSelectionFlags;
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.preferredAudioLanguage);
        dest.writeString(this.preferredTextLanguage);
        Util.writeBoolean(dest, this.selectUndeterminedTextLanguage);
        dest.writeInt(this.disabledTextTrackSelectionFlags);
    }

    public static class Builder {
        @Nullable
        String preferredAudioLanguage;
        @Nullable
        String preferredTextLanguage;
        boolean selectUndeterminedTextLanguage;
        int disabledTextTrackSelectionFlags;

        public Builder() {
            this(DEFAULT);
        }

        Builder(TrackSelectionParameters initialValues) {
            this.preferredAudioLanguage = initialValues.preferredAudioLanguage;
            this.preferredTextLanguage = initialValues.preferredTextLanguage;
            this.selectUndeterminedTextLanguage = initialValues.selectUndeterminedTextLanguage;
            this.disabledTextTrackSelectionFlags = initialValues.disabledTextTrackSelectionFlags;
        }

        public Builder setPreferredAudioLanguage(@Nullable String preferredAudioLanguage) {
            this.preferredAudioLanguage = preferredAudioLanguage;
            return this;
        }

        public Builder setPreferredTextLanguage(@Nullable String preferredTextLanguage) {
            this.preferredTextLanguage = preferredTextLanguage;
            return this;
        }

        public Builder setSelectUndeterminedTextLanguage(boolean selectUndeterminedTextLanguage) {
            this.selectUndeterminedTextLanguage = selectUndeterminedTextLanguage;
            return this;
        }

        public Builder setDisabledTextTrackSelectionFlags(int disabledTextTrackSelectionFlags) {
            this.disabledTextTrackSelectionFlags = disabledTextTrackSelectionFlags;
            return this;
        }

        public TrackSelectionParameters build() {
            return new TrackSelectionParameters(this.preferredAudioLanguage, this.preferredTextLanguage, this.selectUndeterminedTextLanguage, this.disabledTextTrackSelectionFlags);
        }
    }
}

