/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.source.chunk.MediaChunkIterator;
import com.google.android.exoplayer2.trackselection.TrackSelectionUtil;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public interface TrackSelection {
    public void enable();

    public void disable();

    public TrackGroup getTrackGroup();

    public int length();

    public Format getFormat(int var1);

    public int getIndexInTrackGroup(int var1);

    public int indexOf(Format var1);

    public int indexOf(int var1);

    public Format getSelectedFormat();

    public int getSelectedIndexInTrackGroup();

    public int getSelectedIndex();

    public int getSelectionReason();

    @Nullable
    public Object getSelectionData();

    public void onPlaybackSpeed(float var1);

    default public void onDiscontinuity() {
    }

    @Deprecated
    default public void updateSelectedTrack(long playbackPositionUs, long bufferedDurationUs, long availableDurationUs) {
        throw new UnsupportedOperationException();
    }

    default public void updateSelectedTrack(long playbackPositionUs, long bufferedDurationUs, long availableDurationUs, List<? extends MediaChunk> queue, MediaChunkIterator[] mediaChunkIterators) {
        this.updateSelectedTrack(playbackPositionUs, bufferedDurationUs, availableDurationUs);
    }

    public int evaluateQueueSize(long var1, List<? extends MediaChunk> var3);

    public boolean blacklist(int var1, long var2);

    public static interface Factory {
        @Deprecated
        default public TrackSelection createTrackSelection(TrackGroup group, BandwidthMeter bandwidthMeter, int ... tracks) {
            throw new UnsupportedOperationException();
        }

        default public @NullableType TrackSelection[] createTrackSelections(@NullableType Definition[] definitions, BandwidthMeter bandwidthMeter) {
            return TrackSelectionUtil.createTrackSelectionsForDefinitions(definitions, definition -> this.createTrackSelection(definition.group, bandwidthMeter, definition.tracks));
        }
    }

    public static final class Definition {
        public final TrackGroup group;
        public final int[] tracks;
        public final int reason;
        @Nullable
        public final Object data;

        public Definition(TrackGroup group, int ... tracks) {
            this(group, tracks, 0, null);
        }

        public Definition(TrackGroup group, int[] tracks, int reason, @Nullable Object data) {
            this.group = group;
            this.tracks = tracks;
            this.reason = reason;
            this.data = data;
        }
    }
}

