/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.util.Pair;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.RendererConfiguration;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectorResult;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public abstract class MappingTrackSelector
extends TrackSelector {
    @Nullable
    private MappedTrackInfo currentMappedTrackInfo;

    @Nullable
    public final MappedTrackInfo getCurrentMappedTrackInfo() {
        return this.currentMappedTrackInfo;
    }

    @Override
    public final void onSelectionActivated(Object info) {
        this.currentMappedTrackInfo = (MappedTrackInfo)info;
    }

    @Override
    public final TrackSelectorResult selectTracks(RendererCapabilities[] rendererCapabilities, TrackGroupArray trackGroups, MediaSource.MediaPeriodId periodId, Timeline timeline) throws ExoPlaybackException {
        int[] rendererTrackGroupCounts = new int[rendererCapabilities.length + 1];
        TrackGroup[][] rendererTrackGroups = new TrackGroup[rendererCapabilities.length + 1][];
        int[][][] rendererFormatSupports = new int[rendererCapabilities.length + 1][][];
        for (int i = 0; i < rendererTrackGroups.length; ++i) {
            rendererTrackGroups[i] = new TrackGroup[trackGroups.length];
            rendererFormatSupports[i] = new int[trackGroups.length][];
        }
        int[] rendererMixedMimeTypeAdaptationSupports = MappingTrackSelector.getMixedMimeTypeAdaptationSupports(rendererCapabilities);
        for (int groupIndex = 0; groupIndex < trackGroups.length; ++groupIndex) {
            TrackGroup group = trackGroups.get(groupIndex);
            int rendererIndex = MappingTrackSelector.findRenderer(rendererCapabilities, group);
            int[] rendererFormatSupport = rendererIndex == rendererCapabilities.length ? new int[group.length] : MappingTrackSelector.getFormatSupport(rendererCapabilities[rendererIndex], group);
            int rendererTrackGroupCount = rendererTrackGroupCounts[rendererIndex];
            rendererTrackGroups[rendererIndex][rendererTrackGroupCount] = group;
            rendererFormatSupports[rendererIndex][rendererTrackGroupCount] = rendererFormatSupport;
            int n = rendererIndex;
            rendererTrackGroupCounts[n] = rendererTrackGroupCounts[n] + 1;
        }
        TrackGroupArray[] rendererTrackGroupArrays = new TrackGroupArray[rendererCapabilities.length];
        int[] rendererTrackTypes = new int[rendererCapabilities.length];
        for (int i = 0; i < rendererCapabilities.length; ++i) {
            int rendererTrackGroupCount = rendererTrackGroupCounts[i];
            rendererTrackGroupArrays[i] = new TrackGroupArray(Util.nullSafeArrayCopy(rendererTrackGroups[i], rendererTrackGroupCount));
            rendererFormatSupports[i] = (int[][])Util.nullSafeArrayCopy(rendererFormatSupports[i], rendererTrackGroupCount);
            rendererTrackTypes[i] = rendererCapabilities[i].getTrackType();
        }
        int unmappedTrackGroupCount = rendererTrackGroupCounts[rendererCapabilities.length];
        TrackGroupArray unmappedTrackGroupArray = new TrackGroupArray(Util.nullSafeArrayCopy(rendererTrackGroups[rendererCapabilities.length], unmappedTrackGroupCount));
        MappedTrackInfo mappedTrackInfo = new MappedTrackInfo(rendererTrackTypes, rendererTrackGroupArrays, rendererMixedMimeTypeAdaptationSupports, rendererFormatSupports, unmappedTrackGroupArray);
        Pair<@NullableType RendererConfiguration[], @NullableType TrackSelection[]> result = this.selectTracks(mappedTrackInfo, rendererFormatSupports, rendererMixedMimeTypeAdaptationSupports);
        return new TrackSelectorResult((RendererConfiguration[])result.first, (TrackSelection[])result.second, mappedTrackInfo);
    }

    protected abstract Pair<@NullableType RendererConfiguration[], @NullableType TrackSelection[]> selectTracks(MappedTrackInfo var1, int[][][] var2, int[] var3) throws ExoPlaybackException;

    private static int findRenderer(RendererCapabilities[] rendererCapabilities, TrackGroup group) throws ExoPlaybackException {
        int bestRendererIndex = rendererCapabilities.length;
        int bestFormatSupportLevel = 0;
        for (int rendererIndex = 0; rendererIndex < rendererCapabilities.length; ++rendererIndex) {
            RendererCapabilities rendererCapability = rendererCapabilities[rendererIndex];
            for (int trackIndex = 0; trackIndex < group.length; ++trackIndex) {
                int formatSupportLevel = rendererCapability.supportsFormat(group.getFormat(trackIndex)) & 7;
                if (formatSupportLevel <= bestFormatSupportLevel) continue;
                bestRendererIndex = rendererIndex;
                bestFormatSupportLevel = formatSupportLevel;
                if (bestFormatSupportLevel != 4) continue;
                return bestRendererIndex;
            }
        }
        return bestRendererIndex;
    }

    private static int[] getFormatSupport(RendererCapabilities rendererCapabilities, TrackGroup group) throws ExoPlaybackException {
        int[] formatSupport = new int[group.length];
        for (int i = 0; i < group.length; ++i) {
            formatSupport[i] = rendererCapabilities.supportsFormat(group.getFormat(i));
        }
        return formatSupport;
    }

    private static int[] getMixedMimeTypeAdaptationSupports(RendererCapabilities[] rendererCapabilities) throws ExoPlaybackException {
        int[] mixedMimeTypeAdaptationSupport = new int[rendererCapabilities.length];
        for (int i = 0; i < mixedMimeTypeAdaptationSupport.length; ++i) {
            mixedMimeTypeAdaptationSupport[i] = rendererCapabilities[i].supportsMixedMimeTypeAdaptation();
        }
        return mixedMimeTypeAdaptationSupport;
    }

    public static final class MappedTrackInfo {
        public static final int RENDERER_SUPPORT_NO_TRACKS = 0;
        public static final int RENDERER_SUPPORT_UNSUPPORTED_TRACKS = 1;
        public static final int RENDERER_SUPPORT_EXCEEDS_CAPABILITIES_TRACKS = 2;
        public static final int RENDERER_SUPPORT_PLAYABLE_TRACKS = 3;
        @Deprecated
        public final int length;
        private final int rendererCount;
        private final int[] rendererTrackTypes;
        private final TrackGroupArray[] rendererTrackGroups;
        private final int[] rendererMixedMimeTypeAdaptiveSupports;
        private final int[][][] rendererFormatSupports;
        private final TrackGroupArray unmappedTrackGroups;

        MappedTrackInfo(int[] rendererTrackTypes, TrackGroupArray[] rendererTrackGroups, int[] rendererMixedMimeTypeAdaptiveSupports, int[][][] rendererFormatSupports, TrackGroupArray unmappedTrackGroups) {
            this.rendererTrackTypes = rendererTrackTypes;
            this.rendererTrackGroups = rendererTrackGroups;
            this.rendererFormatSupports = rendererFormatSupports;
            this.rendererMixedMimeTypeAdaptiveSupports = rendererMixedMimeTypeAdaptiveSupports;
            this.unmappedTrackGroups = unmappedTrackGroups;
            this.length = this.rendererCount = rendererTrackTypes.length;
        }

        public int getRendererCount() {
            return this.rendererCount;
        }

        public int getRendererType(int rendererIndex) {
            return this.rendererTrackTypes[rendererIndex];
        }

        public TrackGroupArray getTrackGroups(int rendererIndex) {
            return this.rendererTrackGroups[rendererIndex];
        }

        public int getRendererSupport(int rendererIndex) {
            int bestRendererSupport = 0;
            int[][] rendererFormatSupport = this.rendererFormatSupports[rendererIndex];
            for (int i = 0; i < rendererFormatSupport.length; ++i) {
                for (int j = 0; j < rendererFormatSupport[i].length; ++j) {
                    int trackRendererSupport;
                    switch (rendererFormatSupport[i][j] & 7) {
                        case 4: {
                            return 3;
                        }
                        case 3: {
                            trackRendererSupport = 2;
                            break;
                        }
                        default: {
                            trackRendererSupport = 1;
                        }
                    }
                    bestRendererSupport = Math.max(bestRendererSupport, trackRendererSupport);
                }
            }
            return bestRendererSupport;
        }

        @Deprecated
        public int getTrackTypeRendererSupport(int trackType) {
            return this.getTypeSupport(trackType);
        }

        public int getTypeSupport(int trackType) {
            int bestRendererSupport = 0;
            for (int i = 0; i < this.rendererCount; ++i) {
                if (this.rendererTrackTypes[i] != trackType) continue;
                bestRendererSupport = Math.max(bestRendererSupport, this.getRendererSupport(i));
            }
            return bestRendererSupport;
        }

        @Deprecated
        public int getTrackFormatSupport(int rendererIndex, int groupIndex, int trackIndex) {
            return this.getTrackSupport(rendererIndex, groupIndex, trackIndex);
        }

        public int getTrackSupport(int rendererIndex, int groupIndex, int trackIndex) {
            return this.rendererFormatSupports[rendererIndex][groupIndex][trackIndex] & 7;
        }

        public int getAdaptiveSupport(int rendererIndex, int groupIndex, boolean includeCapabilitiesExceededTracks) {
            int trackCount = this.rendererTrackGroups[rendererIndex].get((int)groupIndex).length;
            int[] trackIndices = new int[trackCount];
            int trackIndexCount = 0;
            for (int i = 0; i < trackCount; ++i) {
                int fixedSupport = this.getTrackSupport(rendererIndex, groupIndex, i);
                if (fixedSupport != 4 && (!includeCapabilitiesExceededTracks || fixedSupport != 3)) continue;
                trackIndices[trackIndexCount++] = i;
            }
            trackIndices = Arrays.copyOf(trackIndices, trackIndexCount);
            return this.getAdaptiveSupport(rendererIndex, groupIndex, trackIndices);
        }

        public int getAdaptiveSupport(int rendererIndex, int groupIndex, int[] trackIndices) {
            int handledTrackCount = 0;
            int adaptiveSupport = 16;
            boolean multipleMimeTypes = false;
            String firstSampleMimeType = null;
            for (int i = 0; i < trackIndices.length; ++i) {
                int trackIndex = trackIndices[i];
                String sampleMimeType = this.rendererTrackGroups[rendererIndex].get((int)groupIndex).getFormat((int)trackIndex).sampleMimeType;
                if (handledTrackCount++ == 0) {
                    firstSampleMimeType = sampleMimeType;
                } else {
                    multipleMimeTypes |= !Util.areEqual(firstSampleMimeType, sampleMimeType);
                }
                adaptiveSupport = Math.min(adaptiveSupport, this.rendererFormatSupports[rendererIndex][groupIndex][i] & 0x18);
            }
            return multipleMimeTypes ? Math.min(adaptiveSupport, this.rendererMixedMimeTypeAdaptiveSupports[rendererIndex]) : adaptiveSupport;
        }

        @Deprecated
        public TrackGroupArray getUnassociatedTrackGroups() {
            return this.getUnmappedTrackGroups();
        }

        public TrackGroupArray getUnmappedTrackGroups() {
            return this.unmappedTrackGroups;
        }
    }
}

