/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.webvtt;

import android.text.TextUtils;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.text.SimpleSubtitleDecoder;
import com.google.android.exoplayer2.text.SubtitleDecoderException;
import com.google.android.exoplayer2.text.webvtt.CssParser;
import com.google.android.exoplayer2.text.webvtt.WebvttCssStyle;
import com.google.android.exoplayer2.text.webvtt.WebvttCue;
import com.google.android.exoplayer2.text.webvtt.WebvttCueParser;
import com.google.android.exoplayer2.text.webvtt.WebvttParserUtil;
import com.google.android.exoplayer2.text.webvtt.WebvttSubtitle;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.util.ArrayList;
import java.util.List;

public final class WebvttDecoder
extends SimpleSubtitleDecoder {
    private static final int EVENT_NONE = -1;
    private static final int EVENT_END_OF_FILE = 0;
    private static final int EVENT_COMMENT = 1;
    private static final int EVENT_STYLE_BLOCK = 2;
    private static final int EVENT_CUE = 3;
    private static final String COMMENT_START = "NOTE";
    private static final String STYLE_START = "STYLE";
    private final WebvttCueParser cueParser = new WebvttCueParser();
    private final ParsableByteArray parsableWebvttData = new ParsableByteArray();
    private final WebvttCue.Builder webvttCueBuilder = new WebvttCue.Builder();
    private final CssParser cssParser = new CssParser();
    private final List<WebvttCssStyle> definedStyles = new ArrayList<WebvttCssStyle>();

    public WebvttDecoder() {
        super("WebvttDecoder");
    }

    @Override
    protected WebvttSubtitle decode(byte[] bytes, int length, boolean reset) throws SubtitleDecoderException {
        int event;
        this.parsableWebvttData.reset(bytes, length);
        this.webvttCueBuilder.reset();
        this.definedStyles.clear();
        try {
            WebvttParserUtil.validateWebvttHeaderLine(this.parsableWebvttData);
        }
        catch (ParserException e) {
            throw new SubtitleDecoderException(e);
        }
        while (!TextUtils.isEmpty((CharSequence)this.parsableWebvttData.readLine())) {
        }
        ArrayList<WebvttCue> subtitles = new ArrayList<WebvttCue>();
        while ((event = WebvttDecoder.getNextEvent(this.parsableWebvttData)) != 0) {
            if (event == 1) {
                WebvttDecoder.skipComment(this.parsableWebvttData);
                continue;
            }
            if (event == 2) {
                if (!subtitles.isEmpty()) {
                    throw new SubtitleDecoderException("A style block was found after the first cue.");
                }
                this.parsableWebvttData.readLine();
                WebvttCssStyle styleBlock = this.cssParser.parseBlock(this.parsableWebvttData);
                if (styleBlock == null) continue;
                this.definedStyles.add(styleBlock);
                continue;
            }
            if (event != 3 || !this.cueParser.parseCue(this.parsableWebvttData, this.webvttCueBuilder, this.definedStyles)) continue;
            subtitles.add(this.webvttCueBuilder.build());
            this.webvttCueBuilder.reset();
        }
        return new WebvttSubtitle(subtitles);
    }

    private static int getNextEvent(ParsableByteArray parsableWebvttData) {
        int foundEvent = -1;
        int currentInputPosition = 0;
        while (foundEvent == -1) {
            currentInputPosition = parsableWebvttData.getPosition();
            String line = parsableWebvttData.readLine();
            if (line == null) {
                foundEvent = 0;
                continue;
            }
            if (STYLE_START.equals(line)) {
                foundEvent = 2;
                continue;
            }
            if (line.startsWith(COMMENT_START)) {
                foundEvent = 1;
                continue;
            }
            foundEvent = 3;
        }
        parsableWebvttData.setPosition(currentInputPosition);
        return foundEvent;
    }

    private static void skipComment(ParsableByteArray parsableWebvttData) {
        while (!TextUtils.isEmpty((CharSequence)parsableWebvttData.readLine())) {
        }
    }
}

