/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.webvtt;

import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.TypefaceSpan;
import android.text.style.UnderlineSpan;
import androidx.annotation.NonNull;
import com.google.android.exoplayer2.text.webvtt.WebvttCssStyle;
import com.google.android.exoplayer2.text.webvtt.WebvttCue;
import com.google.android.exoplayer2.text.webvtt.WebvttParserUtil;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class WebvttCueParser {
    public static final Pattern CUE_HEADER_PATTERN = Pattern.compile("^(\\S+)\\s+-->\\s+(\\S+)(.*)?$");
    private static final Pattern CUE_SETTING_PATTERN = Pattern.compile("(\\S+?):(\\S+)");
    private static final char CHAR_LESS_THAN = '<';
    private static final char CHAR_GREATER_THAN = '>';
    private static final char CHAR_SLASH = '/';
    private static final char CHAR_AMPERSAND = '&';
    private static final char CHAR_SEMI_COLON = ';';
    private static final char CHAR_SPACE = ' ';
    private static final String ENTITY_LESS_THAN = "lt";
    private static final String ENTITY_GREATER_THAN = "gt";
    private static final String ENTITY_AMPERSAND = "amp";
    private static final String ENTITY_NON_BREAK_SPACE = "nbsp";
    private static final String TAG_BOLD = "b";
    private static final String TAG_ITALIC = "i";
    private static final String TAG_UNDERLINE = "u";
    private static final String TAG_CLASS = "c";
    private static final String TAG_VOICE = "v";
    private static final String TAG_LANG = "lang";
    private static final int STYLE_BOLD = 1;
    private static final int STYLE_ITALIC = 2;
    private static final String TAG = "WebvttCueParser";
    private final StringBuilder textBuilder = new StringBuilder();

    public boolean parseCue(ParsableByteArray webvttData, WebvttCue.Builder builder, List<WebvttCssStyle> styles) {
        String firstLine = webvttData.readLine();
        if (firstLine == null) {
            return false;
        }
        Matcher cueHeaderMatcher = CUE_HEADER_PATTERN.matcher(firstLine);
        if (cueHeaderMatcher.matches()) {
            return WebvttCueParser.parseCue(null, cueHeaderMatcher, webvttData, builder, this.textBuilder, styles);
        }
        String secondLine = webvttData.readLine();
        if (secondLine == null) {
            return false;
        }
        cueHeaderMatcher = CUE_HEADER_PATTERN.matcher(secondLine);
        if (cueHeaderMatcher.matches()) {
            return WebvttCueParser.parseCue(firstLine.trim(), cueHeaderMatcher, webvttData, builder, this.textBuilder, styles);
        }
        return false;
    }

    static void parseCueSettingsList(String cueSettingsList, WebvttCue.Builder builder) {
        Matcher cueSettingMatcher = CUE_SETTING_PATTERN.matcher(cueSettingsList);
        while (cueSettingMatcher.find()) {
            String name = cueSettingMatcher.group(1);
            String value = cueSettingMatcher.group(2);
            try {
                if ("line".equals(name)) {
                    WebvttCueParser.parseLineAttribute(value, builder);
                    continue;
                }
                if ("align".equals(name)) {
                    builder.setTextAlignment(WebvttCueParser.parseTextAlignment(value));
                    continue;
                }
                if ("position".equals(name)) {
                    WebvttCueParser.parsePositionAttribute(value, builder);
                    continue;
                }
                if ("size".equals(name)) {
                    builder.setWidth(WebvttParserUtil.parsePercentage(value));
                    continue;
                }
                Log.w(TAG, "Unknown cue setting " + name + ":" + value);
            }
            catch (NumberFormatException e) {
                Log.w(TAG, "Skipping bad cue setting: " + cueSettingMatcher.group());
            }
        }
    }

    static void parseCueText(String id, String markup, WebvttCue.Builder builder, List<WebvttCssStyle> styles) {
        SpannableStringBuilder spannedText = new SpannableStringBuilder();
        ArrayDeque<StartTag> startTagStack = new ArrayDeque<StartTag>();
        ArrayList<StyleMatch> scratchStyleMatches = new ArrayList<StyleMatch>();
        int pos = 0;
        block4: while (pos < markup.length()) {
            char curr = markup.charAt(pos);
            block0 : switch (curr) {
                case '<': {
                    boolean isVoidTag;
                    int ltPos;
                    if (pos + 1 >= markup.length()) {
                        ++pos;
                        break;
                    }
                    boolean isClosingTag = markup.charAt((ltPos = pos) + 1) == '/';
                    String fullTagExpression = markup.substring(ltPos + (isClosingTag ? 2 : 1), (isVoidTag = markup.charAt((pos = WebvttCueParser.findEndOfTag(markup, ltPos + 1)) - 2) == '/') ? pos - 2 : pos - 1);
                    String tagName = WebvttCueParser.getTagName(fullTagExpression);
                    if (tagName == null || !WebvttCueParser.isSupportedTag(tagName)) continue block4;
                    if (isClosingTag) {
                        while (!startTagStack.isEmpty()) {
                            StartTag startTag = (StartTag)startTagStack.pop();
                            WebvttCueParser.applySpansForTag(id, startTag, spannedText, styles, scratchStyleMatches);
                            if (!startTag.name.equals(tagName)) continue;
                            break block0;
                        }
                        continue block4;
                    }
                    if (isVoidTag) continue block4;
                    startTagStack.push(StartTag.buildStartTag(fullTagExpression, spannedText.length()));
                    break;
                }
                case '&': {
                    int entityEndIndex;
                    int semiColonEndIndex = markup.indexOf(59, pos + 1);
                    int spaceEndIndex = markup.indexOf(32, pos + 1);
                    int n = semiColonEndIndex == -1 ? spaceEndIndex : (entityEndIndex = spaceEndIndex == -1 ? semiColonEndIndex : Math.min(semiColonEndIndex, spaceEndIndex));
                    if (entityEndIndex != -1) {
                        WebvttCueParser.applyEntity(markup.substring(pos + 1, entityEndIndex), spannedText);
                        if (entityEndIndex == spaceEndIndex) {
                            spannedText.append((CharSequence)" ");
                        }
                        pos = entityEndIndex + 1;
                        break;
                    }
                    spannedText.append(curr);
                    ++pos;
                    break;
                }
                default: {
                    spannedText.append(curr);
                    ++pos;
                }
            }
        }
        while (!startTagStack.isEmpty()) {
            WebvttCueParser.applySpansForTag(id, (StartTag)startTagStack.pop(), spannedText, styles, scratchStyleMatches);
        }
        WebvttCueParser.applySpansForTag(id, StartTag.buildWholeCueVirtualTag(), spannedText, styles, scratchStyleMatches);
        builder.setText(spannedText);
    }

    private static boolean parseCue(String id, Matcher cueHeaderMatcher, ParsableByteArray webvttData, WebvttCue.Builder builder, StringBuilder textBuilder, List<WebvttCssStyle> styles) {
        String line;
        try {
            builder.setStartTime(WebvttParserUtil.parseTimestampUs(cueHeaderMatcher.group(1))).setEndTime(WebvttParserUtil.parseTimestampUs(cueHeaderMatcher.group(2)));
        }
        catch (NumberFormatException e) {
            Log.w(TAG, "Skipping cue with bad header: " + cueHeaderMatcher.group());
            return false;
        }
        WebvttCueParser.parseCueSettingsList(cueHeaderMatcher.group(3), builder);
        textBuilder.setLength(0);
        while (!TextUtils.isEmpty((CharSequence)(line = webvttData.readLine()))) {
            if (textBuilder.length() > 0) {
                textBuilder.append("\n");
            }
            textBuilder.append(line.trim());
        }
        WebvttCueParser.parseCueText(id, textBuilder.toString(), builder, styles);
        return true;
    }

    private static void parseLineAttribute(String s, WebvttCue.Builder builder) throws NumberFormatException {
        int commaIndex = s.indexOf(44);
        if (commaIndex != -1) {
            builder.setLineAnchor(WebvttCueParser.parsePositionAnchor(s.substring(commaIndex + 1)));
            s = s.substring(0, commaIndex);
        } else {
            builder.setLineAnchor(Integer.MIN_VALUE);
        }
        if (s.endsWith("%")) {
            builder.setLine(WebvttParserUtil.parsePercentage(s)).setLineType(0);
        } else {
            int lineNumber = Integer.parseInt(s);
            if (lineNumber < 0) {
                --lineNumber;
            }
            builder.setLine(lineNumber).setLineType(1);
        }
    }

    private static void parsePositionAttribute(String s, WebvttCue.Builder builder) throws NumberFormatException {
        int commaIndex = s.indexOf(44);
        if (commaIndex != -1) {
            builder.setPositionAnchor(WebvttCueParser.parsePositionAnchor(s.substring(commaIndex + 1)));
            s = s.substring(0, commaIndex);
        } else {
            builder.setPositionAnchor(Integer.MIN_VALUE);
        }
        builder.setPosition(WebvttParserUtil.parsePercentage(s));
    }

    private static int parsePositionAnchor(String s) {
        switch (s) {
            case "start": {
                return 0;
            }
            case "center": 
            case "middle": {
                return 1;
            }
            case "end": {
                return 2;
            }
        }
        Log.w(TAG, "Invalid anchor value: " + s);
        return Integer.MIN_VALUE;
    }

    private static Layout.Alignment parseTextAlignment(String s) {
        switch (s) {
            case "start": 
            case "left": {
                return Layout.Alignment.ALIGN_NORMAL;
            }
            case "center": 
            case "middle": {
                return Layout.Alignment.ALIGN_CENTER;
            }
            case "end": 
            case "right": {
                return Layout.Alignment.ALIGN_OPPOSITE;
            }
        }
        Log.w(TAG, "Invalid alignment value: " + s);
        return null;
    }

    private static int findEndOfTag(String markup, int startPos) {
        int index = markup.indexOf(62, startPos);
        return index == -1 ? markup.length() : index + 1;
    }

    private static void applyEntity(String entity, SpannableStringBuilder spannedText) {
        switch (entity) {
            case "lt": {
                spannedText.append('<');
                break;
            }
            case "gt": {
                spannedText.append('>');
                break;
            }
            case "nbsp": {
                spannedText.append(' ');
                break;
            }
            case "amp": {
                spannedText.append('&');
                break;
            }
            default: {
                Log.w(TAG, "ignoring unsupported entity: '&" + entity + ";'");
            }
        }
    }

    private static boolean isSupportedTag(String tagName) {
        switch (tagName) {
            case "b": 
            case "c": 
            case "i": 
            case "lang": 
            case "u": 
            case "v": {
                return true;
            }
        }
        return false;
    }

    private static void applySpansForTag(String cueId, StartTag startTag, SpannableStringBuilder text, List<WebvttCssStyle> styles, List<StyleMatch> scratchStyleMatches) {
        int start = startTag.position;
        int end = text.length();
        switch (startTag.name) {
            case "b": {
                text.setSpan((Object)new StyleSpan(1), start, end, 33);
                break;
            }
            case "i": {
                text.setSpan((Object)new StyleSpan(2), start, end, 33);
                break;
            }
            case "u": {
                text.setSpan((Object)new UnderlineSpan(), start, end, 33);
                break;
            }
            case "c": 
            case "lang": 
            case "v": 
            case "": {
                break;
            }
            default: {
                return;
            }
        }
        scratchStyleMatches.clear();
        WebvttCueParser.getApplicableStyles(styles, cueId, startTag, scratchStyleMatches);
        int styleMatchesCount = scratchStyleMatches.size();
        for (int i = 0; i < styleMatchesCount; ++i) {
            WebvttCueParser.applyStyleToText(text, scratchStyleMatches.get((int)i).style, start, end);
        }
    }

    private static void applyStyleToText(SpannableStringBuilder spannedText, WebvttCssStyle style, int start, int end) {
        if (style == null) {
            return;
        }
        if (style.getStyle() != -1) {
            spannedText.setSpan((Object)new StyleSpan(style.getStyle()), start, end, 33);
        }
        if (style.isLinethrough()) {
            spannedText.setSpan((Object)new StrikethroughSpan(), start, end, 33);
        }
        if (style.isUnderline()) {
            spannedText.setSpan((Object)new UnderlineSpan(), start, end, 33);
        }
        if (style.hasFontColor()) {
            spannedText.setSpan((Object)new ForegroundColorSpan(style.getFontColor()), start, end, 33);
        }
        if (style.hasBackgroundColor()) {
            spannedText.setSpan((Object)new BackgroundColorSpan(style.getBackgroundColor()), start, end, 33);
        }
        if (style.getFontFamily() != null) {
            spannedText.setSpan((Object)new TypefaceSpan(style.getFontFamily()), start, end, 33);
        }
        if (style.getTextAlign() != null) {
            spannedText.setSpan((Object)new AlignmentSpan.Standard(style.getTextAlign()), start, end, 33);
        }
        switch (style.getFontSizeUnit()) {
            case 1: {
                spannedText.setSpan((Object)new AbsoluteSizeSpan((int)style.getFontSize(), true), start, end, 33);
                break;
            }
            case 2: {
                spannedText.setSpan((Object)new RelativeSizeSpan(style.getFontSize()), start, end, 33);
                break;
            }
            case 3: {
                spannedText.setSpan((Object)new RelativeSizeSpan(style.getFontSize() / 100.0f), start, end, 33);
                break;
            }
        }
    }

    private static String getTagName(String tagExpression) {
        if ((tagExpression = tagExpression.trim()).isEmpty()) {
            return null;
        }
        return Util.splitAtFirst(tagExpression, "[ \\.]")[0];
    }

    private static void getApplicableStyles(List<WebvttCssStyle> declaredStyles, String id, StartTag tag, List<StyleMatch> output) {
        int styleCount = declaredStyles.size();
        for (int i = 0; i < styleCount; ++i) {
            WebvttCssStyle style = declaredStyles.get(i);
            int score = style.getSpecificityScore(id, tag.name, tag.classes, tag.voice);
            if (score <= 0) continue;
            output.add(new StyleMatch(score, style));
        }
        Collections.sort(output);
    }

    private static final class StartTag {
        private static final String[] NO_CLASSES = new String[0];
        public final String name;
        public final int position;
        public final String voice;
        public final String[] classes;

        private StartTag(String name, int position, String voice, String[] classes) {
            this.position = position;
            this.name = name;
            this.voice = voice;
            this.classes = classes;
        }

        public static StartTag buildStartTag(String fullTagExpression, int position) {
            String voice;
            if ((fullTagExpression = fullTagExpression.trim()).isEmpty()) {
                return null;
            }
            int voiceStartIndex = fullTagExpression.indexOf(" ");
            if (voiceStartIndex == -1) {
                voice = "";
            } else {
                voice = fullTagExpression.substring(voiceStartIndex).trim();
                fullTagExpression = fullTagExpression.substring(0, voiceStartIndex);
            }
            String[] nameAndClasses = Util.split(fullTagExpression, "\\.");
            String name = nameAndClasses[0];
            String[] classes = nameAndClasses.length > 1 ? Arrays.copyOfRange(nameAndClasses, 1, nameAndClasses.length) : NO_CLASSES;
            return new StartTag(name, position, voice, classes);
        }

        public static StartTag buildWholeCueVirtualTag() {
            return new StartTag("", 0, "", new String[0]);
        }
    }

    private static final class StyleMatch
    implements Comparable<StyleMatch> {
        public final int score;
        public final WebvttCssStyle style;

        public StyleMatch(int score, WebvttCssStyle style) {
            this.score = score;
            this.style = style;
        }

        @Override
        public int compareTo(@NonNull StyleMatch another) {
            return this.score - another.score;
        }
    }
}

