/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.subrip;

import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.SimpleSubtitleDecoder;
import com.google.android.exoplayer2.text.subrip.SubripSubtitle;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.LongArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SubripDecoder
extends SimpleSubtitleDecoder {
    static final float START_FRACTION = 0.08f;
    static final float END_FRACTION = 0.92f;
    static final float MID_FRACTION = 0.5f;
    private static final String TAG = "SubripDecoder";
    private static final String SUBRIP_TIMECODE = "(?:(\\d+):)?(\\d+):(\\d+),(\\d+)";
    private static final Pattern SUBRIP_TIMING_LINE = Pattern.compile("\\s*((?:(\\d+):)?(\\d+):(\\d+),(\\d+))\\s*-->\\s*((?:(\\d+):)?(\\d+):(\\d+),(\\d+))?\\s*");
    private static final Pattern SUBRIP_TAG_PATTERN = Pattern.compile("\\{\\\\.*?\\}");
    private static final String SUBRIP_ALIGNMENT_TAG = "\\{\\\\an[1-9]\\}";
    private static final String ALIGN_BOTTOM_LEFT = "{\\an1}";
    private static final String ALIGN_BOTTOM_MID = "{\\an2}";
    private static final String ALIGN_BOTTOM_RIGHT = "{\\an3}";
    private static final String ALIGN_MID_LEFT = "{\\an4}";
    private static final String ALIGN_MID_MID = "{\\an5}";
    private static final String ALIGN_MID_RIGHT = "{\\an6}";
    private static final String ALIGN_TOP_LEFT = "{\\an7}";
    private static final String ALIGN_TOP_MID = "{\\an8}";
    private static final String ALIGN_TOP_RIGHT = "{\\an9}";
    private final StringBuilder textBuilder = new StringBuilder();
    private final ArrayList<String> tags = new ArrayList();

    public SubripDecoder() {
        super(TAG);
    }

    @Override
    protected SubripSubtitle decode(byte[] bytes, int length, boolean reset) {
        String currentLine;
        ArrayList<Cue> cues = new ArrayList<Cue>();
        LongArray cueTimesUs = new LongArray();
        ParsableByteArray subripData = new ParsableByteArray(bytes, length);
        while ((currentLine = subripData.readLine()) != null) {
            if (currentLine.length() == 0) continue;
            try {
                Integer.parseInt(currentLine);
            }
            catch (NumberFormatException e) {
                Log.w(TAG, "Skipping invalid index: " + currentLine);
                continue;
            }
            boolean haveEndTimecode = false;
            currentLine = subripData.readLine();
            if (currentLine == null) {
                Log.w(TAG, "Unexpected end");
                break;
            }
            Matcher matcher = SUBRIP_TIMING_LINE.matcher(currentLine);
            if (matcher.matches()) {
                cueTimesUs.add(SubripDecoder.parseTimecode(matcher, 1));
                if (!TextUtils.isEmpty((CharSequence)matcher.group(6))) {
                    haveEndTimecode = true;
                    cueTimesUs.add(SubripDecoder.parseTimecode(matcher, 6));
                }
            } else {
                Log.w(TAG, "Skipping invalid timing: " + currentLine);
                continue;
            }
            this.textBuilder.setLength(0);
            this.tags.clear();
            while (!TextUtils.isEmpty((CharSequence)(currentLine = subripData.readLine()))) {
                if (this.textBuilder.length() > 0) {
                    this.textBuilder.append("<br>");
                }
                this.textBuilder.append(this.processLine(currentLine, this.tags));
            }
            Spanned text = Html.fromHtml((String)this.textBuilder.toString());
            String alignmentTag = null;
            for (int i = 0; i < this.tags.size(); ++i) {
                String tag = this.tags.get(i);
                if (!tag.matches(SUBRIP_ALIGNMENT_TAG)) continue;
                alignmentTag = tag;
                break;
            }
            cues.add(this.buildCue(text, alignmentTag));
            if (!haveEndTimecode) continue;
            cues.add(null);
        }
        Cue[] cuesArray = new Cue[cues.size()];
        cues.toArray(cuesArray);
        long[] cueTimesUsArray = cueTimesUs.toArray();
        return new SubripSubtitle(cuesArray, cueTimesUsArray);
    }

    private String processLine(String line, ArrayList<String> tags) {
        line = line.trim();
        int removedCharacterCount = 0;
        StringBuilder processedLine = new StringBuilder(line);
        Matcher matcher = SUBRIP_TAG_PATTERN.matcher(line);
        while (matcher.find()) {
            String tag = matcher.group();
            tags.add(tag);
            int start = matcher.start() - removedCharacterCount;
            int tagLength = tag.length();
            processedLine.replace(start, start + tagLength, "");
            removedCharacterCount += tagLength;
        }
        return processedLine.toString();
    }

    private Cue buildCue(Spanned text, @Nullable String alignmentTag) {
        int lineAnchor;
        int positionAnchor;
        if (alignmentTag == null) {
            return new Cue((CharSequence)text);
        }
        switch (alignmentTag) {
            case "{\\an1}": 
            case "{\\an4}": 
            case "{\\an7}": {
                positionAnchor = 0;
                break;
            }
            case "{\\an3}": 
            case "{\\an6}": 
            case "{\\an9}": {
                positionAnchor = 2;
                break;
            }
            default: {
                positionAnchor = 1;
            }
        }
        switch (alignmentTag) {
            case "{\\an1}": 
            case "{\\an2}": 
            case "{\\an3}": {
                lineAnchor = 2;
                break;
            }
            case "{\\an7}": 
            case "{\\an8}": 
            case "{\\an9}": {
                lineAnchor = 0;
                break;
            }
            default: {
                lineAnchor = 1;
            }
        }
        return new Cue((CharSequence)text, null, SubripDecoder.getFractionalPositionForAnchorType(lineAnchor), 0, lineAnchor, SubripDecoder.getFractionalPositionForAnchorType(positionAnchor), positionAnchor, Float.MIN_VALUE);
    }

    private static long parseTimecode(Matcher matcher, int groupOffset) {
        long timestampMs = Long.parseLong(matcher.group(groupOffset + 1)) * 60L * 60L * 1000L;
        timestampMs += Long.parseLong(matcher.group(groupOffset + 2)) * 60L * 1000L;
        timestampMs += Long.parseLong(matcher.group(groupOffset + 3)) * 1000L;
        return (timestampMs += Long.parseLong(matcher.group(groupOffset + 4))) * 1000L;
    }

    static float getFractionalPositionForAnchorType(int anchorType) {
        switch (anchorType) {
            case 0: {
                return 0.08f;
            }
            case 1: {
                return 0.5f;
            }
            case 2: {
                return 0.92f;
            }
        }
        throw new IllegalArgumentException();
    }
}

