/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.chunk;

import com.google.android.exoplayer2.source.chunk.BaseMediaChunkIterator;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.upstream.DataSpec;
import java.util.List;

public final class MediaChunkListIterator
extends BaseMediaChunkIterator {
    private final List<? extends MediaChunk> chunks;
    private final boolean reverseOrder;

    public MediaChunkListIterator(List<? extends MediaChunk> chunks, boolean reverseOrder) {
        super(0L, chunks.size() - 1);
        this.chunks = chunks;
        this.reverseOrder = reverseOrder;
    }

    @Override
    public DataSpec getDataSpec() {
        return this.getCurrentChunk().dataSpec;
    }

    @Override
    public long getChunkStartTimeUs() {
        return this.getCurrentChunk().startTimeUs;
    }

    @Override
    public long getChunkEndTimeUs() {
        return this.getCurrentChunk().endTimeUs;
    }

    private MediaChunk getCurrentChunk() {
        int index = (int)super.getCurrentIndex();
        if (this.reverseOrder) {
            index = this.chunks.size() - 1 - index;
        }
        return this.chunks.get(index);
    }
}

