/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.chunk;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.SampleQueue;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SequenceableLoader;
import com.google.android.exoplayer2.source.chunk.BaseMediaChunk;
import com.google.android.exoplayer2.source.chunk.BaseMediaChunkOutput;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.chunk.ChunkHolder;
import com.google.android.exoplayer2.source.chunk.ChunkSource;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DefaultLoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChunkSampleStream<T extends ChunkSource>
implements SampleStream,
SequenceableLoader,
Loader.Callback<Chunk>,
Loader.ReleaseCallback {
    private static final String TAG = "ChunkSampleStream";
    public final int primaryTrackType;
    private final int[] embeddedTrackTypes;
    private final Format[] embeddedTrackFormats;
    private final boolean[] embeddedTracksSelected;
    private final T chunkSource;
    private final SequenceableLoader.Callback<ChunkSampleStream<T>> callback;
    private final MediaSourceEventListener.EventDispatcher eventDispatcher;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final Loader loader;
    private final ChunkHolder nextChunkHolder;
    private final ArrayList<BaseMediaChunk> mediaChunks;
    private final List<BaseMediaChunk> readOnlyMediaChunks;
    private final SampleQueue primarySampleQueue;
    private final SampleQueue[] embeddedSampleQueues;
    private final BaseMediaChunkOutput mediaChunkOutput;
    private Format primaryDownstreamTrackFormat;
    @Nullable
    private ReleaseCallback<T> releaseCallback;
    private long pendingResetPositionUs;
    private long lastSeekPositionUs;
    private int nextNotifyPrimaryFormatMediaChunkIndex;
    long decodeOnlyUntilPositionUs;
    boolean loadingFinished;

    @Deprecated
    public ChunkSampleStream(int primaryTrackType, int[] embeddedTrackTypes, Format[] embeddedTrackFormats, T chunkSource, SequenceableLoader.Callback<ChunkSampleStream<T>> callback, Allocator allocator, long positionUs, int minLoadableRetryCount, MediaSourceEventListener.EventDispatcher eventDispatcher) {
        this(primaryTrackType, embeddedTrackTypes, embeddedTrackFormats, chunkSource, callback, allocator, positionUs, new DefaultLoadErrorHandlingPolicy(minLoadableRetryCount), eventDispatcher);
    }

    public ChunkSampleStream(int primaryTrackType, int[] embeddedTrackTypes, Format[] embeddedTrackFormats, T chunkSource, SequenceableLoader.Callback<ChunkSampleStream<T>> callback, Allocator allocator, long positionUs, LoadErrorHandlingPolicy loadErrorHandlingPolicy, MediaSourceEventListener.EventDispatcher eventDispatcher) {
        this.primaryTrackType = primaryTrackType;
        this.embeddedTrackTypes = embeddedTrackTypes;
        this.embeddedTrackFormats = embeddedTrackFormats;
        this.chunkSource = chunkSource;
        this.callback = callback;
        this.eventDispatcher = eventDispatcher;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.loader = new Loader("Loader:ChunkSampleStream");
        this.nextChunkHolder = new ChunkHolder();
        this.mediaChunks = new ArrayList();
        this.readOnlyMediaChunks = Collections.unmodifiableList(this.mediaChunks);
        int embeddedTrackCount = embeddedTrackTypes == null ? 0 : embeddedTrackTypes.length;
        this.embeddedSampleQueues = new SampleQueue[embeddedTrackCount];
        this.embeddedTracksSelected = new boolean[embeddedTrackCount];
        int[] trackTypes = new int[1 + embeddedTrackCount];
        SampleQueue[] sampleQueues = new SampleQueue[1 + embeddedTrackCount];
        this.primarySampleQueue = new SampleQueue(allocator);
        trackTypes[0] = primaryTrackType;
        sampleQueues[0] = this.primarySampleQueue;
        for (int i = 0; i < embeddedTrackCount; ++i) {
            SampleQueue sampleQueue;
            this.embeddedSampleQueues[i] = sampleQueue = new SampleQueue(allocator);
            sampleQueues[i + 1] = sampleQueue;
            trackTypes[i + 1] = embeddedTrackTypes[i];
        }
        this.mediaChunkOutput = new BaseMediaChunkOutput(trackTypes, sampleQueues);
        this.pendingResetPositionUs = positionUs;
        this.lastSeekPositionUs = positionUs;
    }

    public void discardBuffer(long positionUs, boolean toKeyframe) {
        if (this.isPendingReset()) {
            return;
        }
        int oldFirstSampleIndex = this.primarySampleQueue.getFirstIndex();
        this.primarySampleQueue.discardTo(positionUs, toKeyframe, true);
        int newFirstSampleIndex = this.primarySampleQueue.getFirstIndex();
        if (newFirstSampleIndex > oldFirstSampleIndex) {
            long discardToUs = this.primarySampleQueue.getFirstTimestampUs();
            for (int i = 0; i < this.embeddedSampleQueues.length; ++i) {
                this.embeddedSampleQueues[i].discardTo(discardToUs, toKeyframe, this.embeddedTracksSelected[i]);
            }
        }
        this.discardDownstreamMediaChunks(newFirstSampleIndex);
    }

    public EmbeddedSampleStream selectEmbeddedTrack(long positionUs, int trackType) {
        for (int i = 0; i < this.embeddedSampleQueues.length; ++i) {
            if (this.embeddedTrackTypes[i] != trackType) continue;
            Assertions.checkState(!this.embeddedTracksSelected[i]);
            this.embeddedTracksSelected[i] = true;
            this.embeddedSampleQueues[i].rewind();
            this.embeddedSampleQueues[i].advanceTo(positionUs, true, true);
            return new EmbeddedSampleStream(this, this.embeddedSampleQueues[i], i);
        }
        throw new IllegalStateException();
    }

    public T getChunkSource() {
        return this.chunkSource;
    }

    @Override
    public long getBufferedPositionUs() {
        BaseMediaChunk lastCompletedMediaChunk;
        if (this.loadingFinished) {
            return Long.MIN_VALUE;
        }
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        long bufferedPositionUs = this.lastSeekPositionUs;
        BaseMediaChunk lastMediaChunk = this.getLastMediaChunk();
        BaseMediaChunk baseMediaChunk = lastMediaChunk.isLoadCompleted() ? lastMediaChunk : (lastCompletedMediaChunk = this.mediaChunks.size() > 1 ? this.mediaChunks.get(this.mediaChunks.size() - 2) : null);
        if (lastCompletedMediaChunk != null) {
            bufferedPositionUs = Math.max(bufferedPositionUs, lastCompletedMediaChunk.endTimeUs);
        }
        return Math.max(bufferedPositionUs, this.primarySampleQueue.getLargestQueuedTimestampUs());
    }

    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        return this.chunkSource.getAdjustedSeekPositionUs(positionUs, seekParameters);
    }

    public void seekToUs(long positionUs) {
        boolean seekInsideBuffer;
        this.lastSeekPositionUs = positionUs;
        if (this.isPendingReset()) {
            this.pendingResetPositionUs = positionUs;
            return;
        }
        BaseMediaChunk seekToMediaChunk = null;
        for (int i = 0; i < this.mediaChunks.size(); ++i) {
            BaseMediaChunk mediaChunk = this.mediaChunks.get(i);
            long mediaChunkStartTimeUs = mediaChunk.startTimeUs;
            if (mediaChunkStartTimeUs == positionUs && mediaChunk.clippedStartTimeUs == -9223372036854775807L) {
                seekToMediaChunk = mediaChunk;
                break;
            }
            if (mediaChunkStartTimeUs > positionUs) break;
        }
        this.primarySampleQueue.rewind();
        if (seekToMediaChunk != null) {
            seekInsideBuffer = this.primarySampleQueue.setReadPosition(seekToMediaChunk.getFirstSampleIndex(0));
            this.decodeOnlyUntilPositionUs = 0L;
        } else {
            seekInsideBuffer = this.primarySampleQueue.advanceTo(positionUs, true, positionUs < this.getNextLoadPositionUs()) != -1;
            this.decodeOnlyUntilPositionUs = this.lastSeekPositionUs;
        }
        if (seekInsideBuffer) {
            this.nextNotifyPrimaryFormatMediaChunkIndex = this.primarySampleIndexToMediaChunkIndex(this.primarySampleQueue.getReadIndex(), 0);
            for (SampleQueue embeddedSampleQueue : this.embeddedSampleQueues) {
                embeddedSampleQueue.rewind();
                embeddedSampleQueue.advanceTo(positionUs, true, false);
            }
        } else {
            this.pendingResetPositionUs = positionUs;
            this.loadingFinished = false;
            this.mediaChunks.clear();
            this.nextNotifyPrimaryFormatMediaChunkIndex = 0;
            if (this.loader.isLoading()) {
                this.loader.cancelLoading();
            } else {
                this.primarySampleQueue.reset();
                for (SampleQueue embeddedSampleQueue : this.embeddedSampleQueues) {
                    embeddedSampleQueue.reset();
                }
            }
        }
    }

    public void release() {
        this.release(null);
    }

    public void release(@Nullable ReleaseCallback<T> callback) {
        this.releaseCallback = callback;
        this.primarySampleQueue.discardToEnd();
        for (SampleQueue embeddedSampleQueue : this.embeddedSampleQueues) {
            embeddedSampleQueue.discardToEnd();
        }
        this.loader.release(this);
    }

    @Override
    public void onLoaderReleased() {
        this.primarySampleQueue.reset();
        for (SampleQueue embeddedSampleQueue : this.embeddedSampleQueues) {
            embeddedSampleQueue.reset();
        }
        if (this.releaseCallback != null) {
            this.releaseCallback.onSampleStreamReleased(this);
        }
    }

    @Override
    public boolean isReady() {
        return this.loadingFinished || !this.isPendingReset() && this.primarySampleQueue.hasNextSample();
    }

    @Override
    public void maybeThrowError() throws IOException {
        this.loader.maybeThrowError();
        if (!this.loader.isLoading()) {
            this.chunkSource.maybeThrowError();
        }
    }

    @Override
    public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, boolean formatRequired) {
        if (this.isPendingReset()) {
            return -3;
        }
        this.maybeNotifyPrimaryTrackFormatChanged();
        return this.primarySampleQueue.read(formatHolder, buffer, formatRequired, this.loadingFinished, this.decodeOnlyUntilPositionUs);
    }

    @Override
    public int skipData(long positionUs) {
        int skipCount;
        if (this.isPendingReset()) {
            return 0;
        }
        if (this.loadingFinished && positionUs > this.primarySampleQueue.getLargestQueuedTimestampUs()) {
            skipCount = this.primarySampleQueue.advanceToEnd();
        } else {
            skipCount = this.primarySampleQueue.advanceTo(positionUs, true, true);
            if (skipCount == -1) {
                skipCount = 0;
            }
        }
        this.maybeNotifyPrimaryTrackFormatChanged();
        return skipCount;
    }

    @Override
    public void onLoadCompleted(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs) {
        this.chunkSource.onChunkLoadCompleted(loadable);
        this.eventDispatcher.loadCompleted(loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), loadable.type, this.primaryTrackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.callback.onContinueLoadingRequested(this);
    }

    @Override
    public void onLoadCanceled(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        this.eventDispatcher.loadCanceled(loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), loadable.type, this.primaryTrackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        if (!released) {
            this.primarySampleQueue.reset();
            for (SampleQueue embeddedSampleQueue : this.embeddedSampleQueues) {
                embeddedSampleQueue.reset();
            }
            this.callback.onContinueLoadingRequested(this);
        }
    }

    @Override
    public Loader.LoadErrorAction onLoadError(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
        long bytesLoaded = loadable.bytesLoaded();
        boolean isMediaChunk = this.isMediaChunk(loadable);
        int lastChunkIndex = this.mediaChunks.size() - 1;
        boolean cancelable = bytesLoaded == 0L || !isMediaChunk || !this.haveReadFromMediaChunk(lastChunkIndex);
        long blacklistDurationMs = cancelable ? this.loadErrorHandlingPolicy.getBlacklistDurationMsFor(loadable.type, loadDurationMs, error, errorCount) : -9223372036854775807L;
        Loader.LoadErrorAction loadErrorAction = null;
        if (this.chunkSource.onChunkLoadError(loadable, cancelable, error, blacklistDurationMs)) {
            if (cancelable) {
                loadErrorAction = Loader.DONT_RETRY;
                if (isMediaChunk) {
                    BaseMediaChunk removed = this.discardUpstreamMediaChunksFromIndex(lastChunkIndex);
                    Assertions.checkState(removed == loadable);
                    if (this.mediaChunks.isEmpty()) {
                        this.pendingResetPositionUs = this.lastSeekPositionUs;
                    }
                }
            } else {
                Log.w(TAG, "Ignoring attempt to cancel non-cancelable load.");
            }
        }
        if (loadErrorAction == null) {
            long retryDelayMs = this.loadErrorHandlingPolicy.getRetryDelayMsFor(loadable.type, loadDurationMs, error, errorCount);
            loadErrorAction = retryDelayMs != -9223372036854775807L ? Loader.createRetryAction(false, retryDelayMs) : Loader.DONT_RETRY_FATAL;
        }
        boolean canceled = !loadErrorAction.isRetry();
        this.eventDispatcher.loadError(loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), loadable.type, this.primaryTrackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs, loadDurationMs, bytesLoaded, error, canceled);
        if (canceled) {
            this.callback.onContinueLoadingRequested(this);
        }
        return loadErrorAction;
    }

    @Override
    public boolean continueLoading(long positionUs) {
        long loadPositionUs;
        List<Object> chunkQueue;
        if (this.loadingFinished || this.loader.isLoading()) {
            return false;
        }
        boolean pendingReset = this.isPendingReset();
        if (pendingReset) {
            chunkQueue = Collections.emptyList();
            loadPositionUs = this.pendingResetPositionUs;
        } else {
            chunkQueue = this.readOnlyMediaChunks;
            loadPositionUs = this.getLastMediaChunk().endTimeUs;
        }
        this.chunkSource.getNextChunk(positionUs, loadPositionUs, chunkQueue, this.nextChunkHolder);
        boolean endOfStream = this.nextChunkHolder.endOfStream;
        Chunk loadable = this.nextChunkHolder.chunk;
        this.nextChunkHolder.clear();
        if (endOfStream) {
            this.pendingResetPositionUs = -9223372036854775807L;
            this.loadingFinished = true;
            return true;
        }
        if (loadable == null) {
            return false;
        }
        if (this.isMediaChunk(loadable)) {
            BaseMediaChunk mediaChunk = (BaseMediaChunk)loadable;
            if (pendingReset) {
                boolean resetToMediaChunk = mediaChunk.startTimeUs == this.pendingResetPositionUs;
                this.decodeOnlyUntilPositionUs = resetToMediaChunk ? 0L : this.pendingResetPositionUs;
                this.pendingResetPositionUs = -9223372036854775807L;
            }
            mediaChunk.init(this.mediaChunkOutput);
            this.mediaChunks.add(mediaChunk);
        }
        long elapsedRealtimeMs = this.loader.startLoading(loadable, this, this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(loadable.type));
        this.eventDispatcher.loadStarted(loadable.dataSpec, loadable.type, this.primaryTrackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs);
        return true;
    }

    @Override
    public long getNextLoadPositionUs() {
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        return this.loadingFinished ? Long.MIN_VALUE : this.getLastMediaChunk().endTimeUs;
    }

    @Override
    public void reevaluateBuffer(long positionUs) {
        int preferredQueueSize;
        if (this.loader.isLoading() || this.isPendingReset()) {
            return;
        }
        int currentQueueSize = this.mediaChunks.size();
        if (currentQueueSize <= (preferredQueueSize = this.chunkSource.getPreferredQueueSize(positionUs, this.readOnlyMediaChunks))) {
            return;
        }
        int newQueueSize = currentQueueSize;
        for (int i = preferredQueueSize; i < currentQueueSize; ++i) {
            if (this.haveReadFromMediaChunk(i)) continue;
            newQueueSize = i;
            break;
        }
        if (newQueueSize == currentQueueSize) {
            return;
        }
        long endTimeUs = this.getLastMediaChunk().endTimeUs;
        BaseMediaChunk firstRemovedChunk = this.discardUpstreamMediaChunksFromIndex(newQueueSize);
        if (this.mediaChunks.isEmpty()) {
            this.pendingResetPositionUs = this.lastSeekPositionUs;
        }
        this.loadingFinished = false;
        this.eventDispatcher.upstreamDiscarded(this.primaryTrackType, firstRemovedChunk.startTimeUs, endTimeUs);
    }

    private boolean isMediaChunk(Chunk chunk) {
        return chunk instanceof BaseMediaChunk;
    }

    private boolean haveReadFromMediaChunk(int mediaChunkIndex) {
        BaseMediaChunk mediaChunk = this.mediaChunks.get(mediaChunkIndex);
        if (this.primarySampleQueue.getReadIndex() > mediaChunk.getFirstSampleIndex(0)) {
            return true;
        }
        for (int i = 0; i < this.embeddedSampleQueues.length; ++i) {
            if (this.embeddedSampleQueues[i].getReadIndex() <= mediaChunk.getFirstSampleIndex(i + 1)) continue;
            return true;
        }
        return false;
    }

    boolean isPendingReset() {
        return this.pendingResetPositionUs != -9223372036854775807L;
    }

    private void discardDownstreamMediaChunks(int discardToSampleIndex) {
        int discardToMediaChunkIndex = this.primarySampleIndexToMediaChunkIndex(discardToSampleIndex, 0);
        if ((discardToMediaChunkIndex = Math.min(discardToMediaChunkIndex, this.nextNotifyPrimaryFormatMediaChunkIndex)) > 0) {
            Util.removeRange(this.mediaChunks, 0, discardToMediaChunkIndex);
            this.nextNotifyPrimaryFormatMediaChunkIndex -= discardToMediaChunkIndex;
        }
    }

    private void maybeNotifyPrimaryTrackFormatChanged() {
        int readSampleIndex = this.primarySampleQueue.getReadIndex();
        int notifyToMediaChunkIndex = this.primarySampleIndexToMediaChunkIndex(readSampleIndex, this.nextNotifyPrimaryFormatMediaChunkIndex - 1);
        while (this.nextNotifyPrimaryFormatMediaChunkIndex <= notifyToMediaChunkIndex) {
            this.maybeNotifyPrimaryTrackFormatChanged(this.nextNotifyPrimaryFormatMediaChunkIndex++);
        }
    }

    private void maybeNotifyPrimaryTrackFormatChanged(int mediaChunkReadIndex) {
        BaseMediaChunk currentChunk = this.mediaChunks.get(mediaChunkReadIndex);
        Format trackFormat = currentChunk.trackFormat;
        if (!trackFormat.equals(this.primaryDownstreamTrackFormat)) {
            this.eventDispatcher.downstreamFormatChanged(this.primaryTrackType, trackFormat, currentChunk.trackSelectionReason, currentChunk.trackSelectionData, currentChunk.startTimeUs);
        }
        this.primaryDownstreamTrackFormat = trackFormat;
    }

    private int primarySampleIndexToMediaChunkIndex(int primarySampleIndex, int minChunkIndex) {
        for (int i = minChunkIndex + 1; i < this.mediaChunks.size(); ++i) {
            if (this.mediaChunks.get(i).getFirstSampleIndex(0) <= primarySampleIndex) continue;
            return i - 1;
        }
        return this.mediaChunks.size() - 1;
    }

    private BaseMediaChunk getLastMediaChunk() {
        return this.mediaChunks.get(this.mediaChunks.size() - 1);
    }

    private BaseMediaChunk discardUpstreamMediaChunksFromIndex(int chunkIndex) {
        BaseMediaChunk firstRemovedChunk = this.mediaChunks.get(chunkIndex);
        Util.removeRange(this.mediaChunks, chunkIndex, this.mediaChunks.size());
        this.nextNotifyPrimaryFormatMediaChunkIndex = Math.max(this.nextNotifyPrimaryFormatMediaChunkIndex, this.mediaChunks.size());
        this.primarySampleQueue.discardUpstreamSamples(firstRemovedChunk.getFirstSampleIndex(0));
        for (int i = 0; i < this.embeddedSampleQueues.length; ++i) {
            this.embeddedSampleQueues[i].discardUpstreamSamples(firstRemovedChunk.getFirstSampleIndex(i + 1));
        }
        return firstRemovedChunk;
    }

    public final class EmbeddedSampleStream
    implements SampleStream {
        public final ChunkSampleStream<T> parent;
        private final SampleQueue sampleQueue;
        private final int index;
        private boolean notifiedDownstreamFormat;

        public EmbeddedSampleStream(ChunkSampleStream<T> parent, SampleQueue sampleQueue, int index) {
            this.parent = parent;
            this.sampleQueue = sampleQueue;
            this.index = index;
        }

        @Override
        public boolean isReady() {
            return ChunkSampleStream.this.loadingFinished || !ChunkSampleStream.this.isPendingReset() && this.sampleQueue.hasNextSample();
        }

        @Override
        public int skipData(long positionUs) {
            int skipCount;
            if (ChunkSampleStream.this.isPendingReset()) {
                return 0;
            }
            this.maybeNotifyDownstreamFormat();
            if (ChunkSampleStream.this.loadingFinished && positionUs > this.sampleQueue.getLargestQueuedTimestampUs()) {
                skipCount = this.sampleQueue.advanceToEnd();
            } else {
                skipCount = this.sampleQueue.advanceTo(positionUs, true, true);
                if (skipCount == -1) {
                    skipCount = 0;
                }
            }
            return skipCount;
        }

        @Override
        public void maybeThrowError() throws IOException {
        }

        @Override
        public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, boolean formatRequired) {
            if (ChunkSampleStream.this.isPendingReset()) {
                return -3;
            }
            this.maybeNotifyDownstreamFormat();
            return this.sampleQueue.read(formatHolder, buffer, formatRequired, ChunkSampleStream.this.loadingFinished, ChunkSampleStream.this.decodeOnlyUntilPositionUs);
        }

        public void release() {
            Assertions.checkState(ChunkSampleStream.this.embeddedTracksSelected[this.index]);
            ((ChunkSampleStream)ChunkSampleStream.this).embeddedTracksSelected[this.index] = false;
        }

        private void maybeNotifyDownstreamFormat() {
            if (!this.notifiedDownstreamFormat) {
                ChunkSampleStream.this.eventDispatcher.downstreamFormatChanged(ChunkSampleStream.this.embeddedTrackTypes[this.index], ChunkSampleStream.this.embeddedTrackFormats[this.index], 0, null, ChunkSampleStream.this.lastSeekPositionUs);
                this.notifiedDownstreamFormat = true;
            }
        }
    }

    public static interface ReleaseCallback<T extends ChunkSource> {
        public void onSampleStreamReleased(ChunkSampleStream<T> var1);
    }
}

