/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.ads;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.CompositeMediaSource;
import com.google.android.exoplayer2.source.DeferredMediaPeriod;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.source.ads.AdPlaybackState;
import com.google.android.exoplayer2.source.ads.AdsLoader;
import com.google.android.exoplayer2.source.ads.SinglePeriodAdTimeline;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AdsMediaSource
extends CompositeMediaSource<MediaSource.MediaPeriodId> {
    private static final MediaSource.MediaPeriodId DUMMY_CONTENT_MEDIA_PERIOD_ID = new MediaSource.MediaPeriodId(new Object());
    private final MediaSource contentMediaSource;
    private final MediaSourceFactory adMediaSourceFactory;
    private final AdsLoader adsLoader;
    private final AdsLoader.AdViewProvider adViewProvider;
    private final Handler mainHandler;
    private final Map<MediaSource, List<DeferredMediaPeriod>> deferredMediaPeriodByAdMediaSource;
    private final Timeline.Period period;
    private ComponentListener componentListener;
    private Timeline contentTimeline;
    private Object contentManifest;
    private AdPlaybackState adPlaybackState;
    private MediaSource[][] adGroupMediaSources;
    private Timeline[][] adGroupTimelines;

    public AdsMediaSource(MediaSource contentMediaSource, DataSource.Factory dataSourceFactory, AdsLoader adsLoader, AdsLoader.AdViewProvider adViewProvider) {
        this(contentMediaSource, new ProgressiveMediaSource.Factory(dataSourceFactory), adsLoader, adViewProvider);
    }

    public AdsMediaSource(MediaSource contentMediaSource, MediaSourceFactory adMediaSourceFactory, AdsLoader adsLoader, AdsLoader.AdViewProvider adViewProvider) {
        this.contentMediaSource = contentMediaSource;
        this.adMediaSourceFactory = adMediaSourceFactory;
        this.adsLoader = adsLoader;
        this.adViewProvider = adViewProvider;
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.deferredMediaPeriodByAdMediaSource = new HashMap<MediaSource, List<DeferredMediaPeriod>>();
        this.period = new Timeline.Period();
        this.adGroupMediaSources = new MediaSource[0][];
        this.adGroupTimelines = new Timeline[0][];
        adsLoader.setSupportedContentTypes(adMediaSourceFactory.getSupportedTypes());
    }

    @Override
    @Nullable
    public Object getTag() {
        return this.contentMediaSource.getTag();
    }

    @Override
    public void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        ComponentListener componentListener;
        super.prepareSourceInternal(mediaTransferListener);
        this.componentListener = componentListener = new ComponentListener();
        this.prepareChildSource(DUMMY_CONTENT_MEDIA_PERIOD_ID, this.contentMediaSource);
        this.mainHandler.post(() -> this.adsLoader.start(componentListener, this.adViewProvider));
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        if (this.adPlaybackState.adGroupCount > 0 && id.isAd()) {
            int adGroupIndex = id.adGroupIndex;
            int adIndexInAdGroup = id.adIndexInAdGroup;
            Uri adUri = this.adPlaybackState.adGroups[adGroupIndex].uris[adIndexInAdGroup];
            if (this.adGroupMediaSources[adGroupIndex].length <= adIndexInAdGroup) {
                MediaSource adMediaSource = this.adMediaSourceFactory.createMediaSource(adUri);
                int oldAdCount = this.adGroupMediaSources[adGroupIndex].length;
                if (adIndexInAdGroup >= oldAdCount) {
                    int adCount = adIndexInAdGroup + 1;
                    this.adGroupMediaSources[adGroupIndex] = Arrays.copyOf(this.adGroupMediaSources[adGroupIndex], adCount);
                    this.adGroupTimelines[adGroupIndex] = Arrays.copyOf(this.adGroupTimelines[adGroupIndex], adCount);
                }
                this.adGroupMediaSources[adGroupIndex][adIndexInAdGroup] = adMediaSource;
                this.deferredMediaPeriodByAdMediaSource.put(adMediaSource, new ArrayList());
                this.prepareChildSource(id, adMediaSource);
            }
            MediaSource mediaSource = this.adGroupMediaSources[adGroupIndex][adIndexInAdGroup];
            DeferredMediaPeriod deferredMediaPeriod = new DeferredMediaPeriod(mediaSource, id, allocator, startPositionUs);
            deferredMediaPeriod.setPrepareErrorListener(new AdPrepareErrorListener(adUri, adGroupIndex, adIndexInAdGroup));
            List<DeferredMediaPeriod> mediaPeriods = this.deferredMediaPeriodByAdMediaSource.get(mediaSource);
            if (mediaPeriods == null) {
                Object periodUid = this.adGroupTimelines[adGroupIndex][adIndexInAdGroup].getUidOfPeriod(0);
                MediaSource.MediaPeriodId adSourceMediaPeriodId = new MediaSource.MediaPeriodId(periodUid, id.windowSequenceNumber);
                deferredMediaPeriod.createPeriod(adSourceMediaPeriodId);
            } else {
                mediaPeriods.add(deferredMediaPeriod);
            }
            return deferredMediaPeriod;
        }
        DeferredMediaPeriod mediaPeriod = new DeferredMediaPeriod(this.contentMediaSource, id, allocator, startPositionUs);
        mediaPeriod.createPeriod(id);
        return mediaPeriod;
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        DeferredMediaPeriod deferredMediaPeriod = (DeferredMediaPeriod)mediaPeriod;
        List<DeferredMediaPeriod> mediaPeriods = this.deferredMediaPeriodByAdMediaSource.get(deferredMediaPeriod.mediaSource);
        if (mediaPeriods != null) {
            mediaPeriods.remove(deferredMediaPeriod);
        }
        deferredMediaPeriod.releasePeriod();
    }

    @Override
    public void releaseSourceInternal() {
        super.releaseSourceInternal();
        this.componentListener.release();
        this.componentListener = null;
        this.deferredMediaPeriodByAdMediaSource.clear();
        this.contentTimeline = null;
        this.contentManifest = null;
        this.adPlaybackState = null;
        this.adGroupMediaSources = new MediaSource[0][];
        this.adGroupTimelines = new Timeline[0][];
        this.mainHandler.post(this.adsLoader::stop);
    }

    @Override
    protected void onChildSourceInfoRefreshed(MediaSource.MediaPeriodId mediaPeriodId, MediaSource mediaSource, Timeline timeline, @Nullable Object manifest) {
        if (mediaPeriodId.isAd()) {
            int adGroupIndex = mediaPeriodId.adGroupIndex;
            int adIndexInAdGroup = mediaPeriodId.adIndexInAdGroup;
            this.onAdSourceInfoRefreshed(mediaSource, adGroupIndex, adIndexInAdGroup, timeline);
        } else {
            this.onContentSourceInfoRefreshed(timeline, manifest);
        }
    }

    @Override
    @Nullable
    protected MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(MediaSource.MediaPeriodId childId, MediaSource.MediaPeriodId mediaPeriodId) {
        return childId.isAd() ? childId : mediaPeriodId;
    }

    private void onAdPlaybackState(AdPlaybackState adPlaybackState) {
        if (this.adPlaybackState == null) {
            this.adGroupMediaSources = new MediaSource[adPlaybackState.adGroupCount][];
            Arrays.fill((Object[])this.adGroupMediaSources, new MediaSource[0]);
            this.adGroupTimelines = new Timeline[adPlaybackState.adGroupCount][];
            Arrays.fill((Object[])this.adGroupTimelines, new Timeline[0]);
        }
        this.adPlaybackState = adPlaybackState;
        this.maybeUpdateSourceInfo();
    }

    private void onContentSourceInfoRefreshed(Timeline timeline, Object manifest) {
        Assertions.checkArgument(timeline.getPeriodCount() == 1);
        this.contentTimeline = timeline;
        this.contentManifest = manifest;
        this.maybeUpdateSourceInfo();
    }

    private void onAdSourceInfoRefreshed(MediaSource mediaSource, int adGroupIndex, int adIndexInAdGroup, Timeline timeline) {
        Assertions.checkArgument(timeline.getPeriodCount() == 1);
        this.adGroupTimelines[adGroupIndex][adIndexInAdGroup] = timeline;
        List<DeferredMediaPeriod> mediaPeriods = this.deferredMediaPeriodByAdMediaSource.remove(mediaSource);
        if (mediaPeriods != null) {
            Object periodUid = timeline.getUidOfPeriod(0);
            for (int i = 0; i < mediaPeriods.size(); ++i) {
                DeferredMediaPeriod mediaPeriod = mediaPeriods.get(i);
                MediaSource.MediaPeriodId adSourceMediaPeriodId = new MediaSource.MediaPeriodId(periodUid, mediaPeriod.id.windowSequenceNumber);
                mediaPeriod.createPeriod(adSourceMediaPeriodId);
            }
        }
        this.maybeUpdateSourceInfo();
    }

    private void maybeUpdateSourceInfo() {
        if (this.adPlaybackState != null && this.contentTimeline != null) {
            this.adPlaybackState = this.adPlaybackState.withAdDurationsUs(AdsMediaSource.getAdDurations(this.adGroupTimelines, this.period));
            Timeline timeline = this.adPlaybackState.adGroupCount == 0 ? this.contentTimeline : new SinglePeriodAdTimeline(this.contentTimeline, this.adPlaybackState);
            this.refreshSourceInfo(timeline, this.contentManifest);
        }
    }

    private static long[][] getAdDurations(Timeline[][] adTimelines, Timeline.Period period) {
        long[][] adDurations = new long[adTimelines.length][];
        for (int i = 0; i < adTimelines.length; ++i) {
            adDurations[i] = new long[adTimelines[i].length];
            for (int j = 0; j < adTimelines[i].length; ++j) {
                adDurations[i][j] = adTimelines[i][j] == null ? -9223372036854775807L : adTimelines[i][j].getPeriod(0, period).getDurationUs();
            }
        }
        return adDurations;
    }

    private final class AdPrepareErrorListener
    implements DeferredMediaPeriod.PrepareErrorListener {
        private final Uri adUri;
        private final int adGroupIndex;
        private final int adIndexInAdGroup;

        public AdPrepareErrorListener(Uri adUri, int adGroupIndex, int adIndexInAdGroup) {
            this.adUri = adUri;
            this.adGroupIndex = adGroupIndex;
            this.adIndexInAdGroup = adIndexInAdGroup;
        }

        @Override
        public void onPrepareError(MediaSource.MediaPeriodId mediaPeriodId, IOException exception) {
            AdsMediaSource.this.createEventDispatcher(mediaPeriodId).loadError(new DataSpec(this.adUri), this.adUri, Collections.emptyMap(), 6, -1L, 0L, 0L, AdLoadException.createForAd(exception), true);
            AdsMediaSource.this.mainHandler.post(() -> AdsMediaSource.this.adsLoader.handlePrepareError(this.adGroupIndex, this.adIndexInAdGroup, exception));
        }
    }

    private final class ComponentListener
    implements AdsLoader.EventListener {
        private final Handler playerHandler = new Handler();
        private volatile boolean released;

        public void release() {
            this.released = true;
            this.playerHandler.removeCallbacksAndMessages(null);
        }

        @Override
        public void onAdPlaybackState(AdPlaybackState adPlaybackState) {
            if (this.released) {
                return;
            }
            this.playerHandler.post(() -> {
                if (this.released) {
                    return;
                }
                AdsMediaSource.this.onAdPlaybackState(adPlaybackState);
            });
        }

        @Override
        public void onAdLoadError(AdLoadException error, DataSpec dataSpec) {
            if (this.released) {
                return;
            }
            AdsMediaSource.this.createEventDispatcher(null).loadError(dataSpec, dataSpec.uri, Collections.emptyMap(), 6, -1L, 0L, 0L, error, true);
        }
    }

    public static final class AdLoadException
    extends IOException {
        public static final int TYPE_AD = 0;
        public static final int TYPE_AD_GROUP = 1;
        public static final int TYPE_ALL_ADS = 2;
        public static final int TYPE_UNEXPECTED = 3;
        public final int type;

        public static AdLoadException createForAd(Exception error) {
            return new AdLoadException(0, error);
        }

        public static AdLoadException createForAdGroup(Exception error, int adGroupIndex) {
            return new AdLoadException(1, new IOException("Failed to load ad group " + adGroupIndex, error));
        }

        public static AdLoadException createForAllAds(Exception error) {
            return new AdLoadException(2, error);
        }

        public static AdLoadException createForUnexpected(RuntimeException error) {
            return new AdLoadException(3, error);
        }

        private AdLoadException(int type, Exception cause) {
            super(cause);
            this.type = type;
        }

        public RuntimeException getRuntimeExceptionForUnexpected() {
            Assertions.checkState(this.type == 3);
            return (RuntimeException)this.getCause();
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Type {
        }
    }

    public static interface MediaSourceFactory {
        public MediaSource createMediaSource(Uri var1);

        public int[] getSupportedTypes();
    }
}

