/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.net.Uri;
import android.os.Handler;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.extractor.DefaultExtractorInput;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.icy.IcyHeaders;
import com.google.android.exoplayer2.source.IcyDataSource;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.SampleQueue;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.UnrecognizedInputFormatException;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.upstream.StatsDataSource;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ConditionVariable;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.checkerframework.checker.nullness.compatqual.NullableType;

final class ProgressiveMediaPeriod
implements MediaPeriod,
ExtractorOutput,
Loader.Callback<ExtractingLoadable>,
Loader.ReleaseCallback,
SampleQueue.UpstreamFormatChangedListener {
    private static final long DEFAULT_LAST_SAMPLE_DURATION_US = 10000L;
    private static final Format ICY_FORMAT = Format.createSampleFormat("icy", "application/x-icy", Long.MAX_VALUE);
    private final Uri uri;
    private final DataSource dataSource;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final MediaSourceEventListener.EventDispatcher eventDispatcher;
    private final Listener listener;
    private final Allocator allocator;
    @Nullable
    private final String customCacheKey;
    private final long continueLoadingCheckIntervalBytes;
    private final Loader loader;
    private final ExtractorHolder extractorHolder;
    private final ConditionVariable loadCondition;
    private final Runnable maybeFinishPrepareRunnable;
    private final Runnable onContinueLoadingRequestedRunnable;
    private final Handler handler;
    @Nullable
    private MediaPeriod.Callback callback;
    @Nullable
    private SeekMap seekMap;
    @Nullable
    private IcyHeaders icyHeaders;
    private SampleQueue[] sampleQueues;
    private TrackId[] sampleQueueTrackIds;
    private boolean sampleQueuesBuilt;
    private boolean prepared;
    @Nullable
    private PreparedState preparedState;
    private boolean haveAudioVideoTracks;
    private int dataType;
    private boolean seenFirstTrackSelection;
    private boolean notifyDiscontinuity;
    private boolean notifiedReadingStarted;
    private int enabledTrackCount;
    private long durationUs;
    private long length;
    private long lastSeekPositionUs;
    private long pendingResetPositionUs;
    private boolean pendingDeferredRetry;
    private int extractedSamplesCountAtStartOfLoad;
    private boolean loadingFinished;
    private boolean released;

    public ProgressiveMediaPeriod(Uri uri, DataSource dataSource, Extractor[] extractors, LoadErrorHandlingPolicy loadErrorHandlingPolicy, MediaSourceEventListener.EventDispatcher eventDispatcher, Listener listener, Allocator allocator, @Nullable String customCacheKey, int continueLoadingCheckIntervalBytes) {
        this.uri = uri;
        this.dataSource = dataSource;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.eventDispatcher = eventDispatcher;
        this.listener = listener;
        this.allocator = allocator;
        this.customCacheKey = customCacheKey;
        this.continueLoadingCheckIntervalBytes = continueLoadingCheckIntervalBytes;
        this.loader = new Loader("Loader:ProgressiveMediaPeriod");
        this.extractorHolder = new ExtractorHolder(extractors);
        this.loadCondition = new ConditionVariable();
        this.maybeFinishPrepareRunnable = this::maybeFinishPrepare;
        this.onContinueLoadingRequestedRunnable = () -> {
            if (!this.released) {
                Assertions.checkNotNull(this.callback).onContinueLoadingRequested(this);
            }
        };
        this.handler = new Handler();
        this.sampleQueueTrackIds = new TrackId[0];
        this.sampleQueues = new SampleQueue[0];
        this.pendingResetPositionUs = -9223372036854775807L;
        this.length = -1L;
        this.durationUs = -9223372036854775807L;
        this.dataType = 1;
        eventDispatcher.mediaPeriodCreated();
    }

    public void release() {
        if (this.prepared) {
            for (SampleQueue sampleQueue : this.sampleQueues) {
                sampleQueue.discardToEnd();
            }
        }
        this.loader.release(this);
        this.handler.removeCallbacksAndMessages(null);
        this.callback = null;
        this.released = true;
        this.eventDispatcher.mediaPeriodReleased();
    }

    @Override
    public void onLoaderReleased() {
        for (SampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.reset();
        }
        this.extractorHolder.release();
    }

    @Override
    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        this.callback = callback;
        this.loadCondition.open();
        this.startLoading();
    }

    @Override
    public void maybeThrowPrepareError() throws IOException {
        this.maybeThrowError();
        if (this.loadingFinished && !this.prepared) {
            throw new ParserException("Loading finished before preparation is complete.");
        }
    }

    @Override
    public TrackGroupArray getTrackGroups() {
        return this.getPreparedState().tracks;
    }

    @Override
    public long selectTracks(@NullableType TrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        int i;
        PreparedState preparedState = this.getPreparedState();
        TrackGroupArray tracks = preparedState.tracks;
        boolean[] trackEnabledStates = preparedState.trackEnabledStates;
        int oldEnabledTrackCount = this.enabledTrackCount;
        for (int i2 = 0; i2 < selections.length; ++i2) {
            if (streams[i2] == null || selections[i2] != null && mayRetainStreamFlags[i2]) continue;
            int track = ((SampleStreamImpl)streams[i2]).track;
            Assertions.checkState(trackEnabledStates[track]);
            --this.enabledTrackCount;
            trackEnabledStates[track] = false;
            streams[i2] = null;
        }
        boolean seekRequired = this.seenFirstTrackSelection ? oldEnabledTrackCount == 0 : positionUs != 0L;
        for (i = 0; i < selections.length; ++i) {
            if (streams[i] != null || selections[i] == null) continue;
            TrackSelection selection = selections[i];
            Assertions.checkState(selection.length() == 1);
            Assertions.checkState(selection.getIndexInTrackGroup(0) == 0);
            int track = tracks.indexOf(selection.getTrackGroup());
            Assertions.checkState(!trackEnabledStates[track]);
            ++this.enabledTrackCount;
            trackEnabledStates[track] = true;
            streams[i] = new SampleStreamImpl(track);
            streamResetFlags[i] = true;
            if (seekRequired) continue;
            SampleQueue sampleQueue = this.sampleQueues[track];
            sampleQueue.rewind();
            seekRequired = sampleQueue.advanceTo(positionUs, true, true) == -1 && sampleQueue.getReadIndex() != 0;
        }
        if (this.enabledTrackCount == 0) {
            this.pendingDeferredRetry = false;
            this.notifyDiscontinuity = false;
            if (this.loader.isLoading()) {
                for (SampleQueue sampleQueue : this.sampleQueues) {
                    sampleQueue.discardToEnd();
                }
                this.loader.cancelLoading();
            } else {
                for (SampleQueue sampleQueue : this.sampleQueues) {
                    sampleQueue.reset();
                }
            }
        } else if (seekRequired) {
            positionUs = this.seekToUs(positionUs);
            for (i = 0; i < streams.length; ++i) {
                if (streams[i] == null) continue;
                streamResetFlags[i] = true;
            }
        }
        this.seenFirstTrackSelection = true;
        return positionUs;
    }

    @Override
    public void discardBuffer(long positionUs, boolean toKeyframe) {
        if (this.isPendingReset()) {
            return;
        }
        boolean[] trackEnabledStates = this.getPreparedState().trackEnabledStates;
        int trackCount = this.sampleQueues.length;
        for (int i = 0; i < trackCount; ++i) {
            this.sampleQueues[i].discardTo(positionUs, toKeyframe, trackEnabledStates[i]);
        }
    }

    @Override
    public void reevaluateBuffer(long positionUs) {
    }

    @Override
    public boolean continueLoading(long playbackPositionUs) {
        if (this.loadingFinished || this.pendingDeferredRetry || this.prepared && this.enabledTrackCount == 0) {
            return false;
        }
        boolean continuedLoading = this.loadCondition.open();
        if (!this.loader.isLoading()) {
            this.startLoading();
            continuedLoading = true;
        }
        return continuedLoading;
    }

    @Override
    public long getNextLoadPositionUs() {
        return this.enabledTrackCount == 0 ? Long.MIN_VALUE : this.getBufferedPositionUs();
    }

    @Override
    public long readDiscontinuity() {
        if (!this.notifiedReadingStarted) {
            this.eventDispatcher.readingStarted();
            this.notifiedReadingStarted = true;
        }
        if (this.notifyDiscontinuity && (this.loadingFinished || this.getExtractedSamplesCount() > this.extractedSamplesCountAtStartOfLoad)) {
            this.notifyDiscontinuity = false;
            return this.lastSeekPositionUs;
        }
        return -9223372036854775807L;
    }

    @Override
    public long getBufferedPositionUs() {
        boolean[] trackIsAudioVideoFlags = this.getPreparedState().trackIsAudioVideoFlags;
        if (this.loadingFinished) {
            return Long.MIN_VALUE;
        }
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        long largestQueuedTimestampUs = Long.MAX_VALUE;
        if (this.haveAudioVideoTracks) {
            int trackCount = this.sampleQueues.length;
            for (int i = 0; i < trackCount; ++i) {
                if (!trackIsAudioVideoFlags[i] || this.sampleQueues[i].isLastSampleQueued()) continue;
                largestQueuedTimestampUs = Math.min(largestQueuedTimestampUs, this.sampleQueues[i].getLargestQueuedTimestampUs());
            }
        }
        if (largestQueuedTimestampUs == Long.MAX_VALUE) {
            largestQueuedTimestampUs = this.getLargestQueuedTimestampUs();
        }
        return largestQueuedTimestampUs == Long.MIN_VALUE ? this.lastSeekPositionUs : largestQueuedTimestampUs;
    }

    @Override
    public long seekToUs(long positionUs) {
        PreparedState preparedState = this.getPreparedState();
        SeekMap seekMap = preparedState.seekMap;
        boolean[] trackIsAudioVideoFlags = preparedState.trackIsAudioVideoFlags;
        positionUs = seekMap.isSeekable() ? positionUs : 0L;
        this.notifyDiscontinuity = false;
        this.lastSeekPositionUs = positionUs;
        if (this.isPendingReset()) {
            this.pendingResetPositionUs = positionUs;
            return positionUs;
        }
        if (this.dataType != 7 && this.seekInsideBufferUs(trackIsAudioVideoFlags, positionUs)) {
            return positionUs;
        }
        this.pendingDeferredRetry = false;
        this.pendingResetPositionUs = positionUs;
        this.loadingFinished = false;
        if (this.loader.isLoading()) {
            this.loader.cancelLoading();
        } else {
            for (SampleQueue sampleQueue : this.sampleQueues) {
                sampleQueue.reset();
            }
        }
        return positionUs;
    }

    @Override
    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        SeekMap seekMap = this.getPreparedState().seekMap;
        if (!seekMap.isSeekable()) {
            return 0L;
        }
        SeekMap.SeekPoints seekPoints = seekMap.getSeekPoints(positionUs);
        return Util.resolveSeekPositionUs(positionUs, seekParameters, seekPoints.first.timeUs, seekPoints.second.timeUs);
    }

    boolean isReady(int track) {
        return !this.suppressRead() && (this.loadingFinished || this.sampleQueues[track].hasNextSample());
    }

    void maybeThrowError() throws IOException {
        this.loader.maybeThrowError(this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(this.dataType));
    }

    int readData(int track, FormatHolder formatHolder, DecoderInputBuffer buffer, boolean formatRequired) {
        if (this.suppressRead()) {
            return -3;
        }
        this.maybeNotifyDownstreamFormat(track);
        int result = this.sampleQueues[track].read(formatHolder, buffer, formatRequired, this.loadingFinished, this.lastSeekPositionUs);
        if (result == -3) {
            this.maybeStartDeferredRetry(track);
        }
        return result;
    }

    int skipData(int track, long positionUs) {
        int skipCount;
        if (this.suppressRead()) {
            return 0;
        }
        this.maybeNotifyDownstreamFormat(track);
        SampleQueue sampleQueue = this.sampleQueues[track];
        if (this.loadingFinished && positionUs > sampleQueue.getLargestQueuedTimestampUs()) {
            skipCount = sampleQueue.advanceToEnd();
        } else {
            skipCount = sampleQueue.advanceTo(positionUs, true, true);
            if (skipCount == -1) {
                skipCount = 0;
            }
        }
        if (skipCount == 0) {
            this.maybeStartDeferredRetry(track);
        }
        return skipCount;
    }

    private void maybeNotifyDownstreamFormat(int track) {
        PreparedState preparedState = this.getPreparedState();
        boolean[] trackNotifiedDownstreamFormats = preparedState.trackNotifiedDownstreamFormats;
        if (!trackNotifiedDownstreamFormats[track]) {
            Format trackFormat = preparedState.tracks.get(track).getFormat(0);
            this.eventDispatcher.downstreamFormatChanged(MimeTypes.getTrackType(trackFormat.sampleMimeType), trackFormat, 0, null, this.lastSeekPositionUs);
            trackNotifiedDownstreamFormats[track] = true;
        }
    }

    private void maybeStartDeferredRetry(int track) {
        boolean[] trackIsAudioVideoFlags = this.getPreparedState().trackIsAudioVideoFlags;
        if (!this.pendingDeferredRetry || !trackIsAudioVideoFlags[track] || this.sampleQueues[track].hasNextSample()) {
            return;
        }
        this.pendingResetPositionUs = 0L;
        this.pendingDeferredRetry = false;
        this.notifyDiscontinuity = true;
        this.lastSeekPositionUs = 0L;
        this.extractedSamplesCountAtStartOfLoad = 0;
        for (SampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.reset();
        }
        Assertions.checkNotNull(this.callback).onContinueLoadingRequested(this);
    }

    private boolean suppressRead() {
        return this.notifyDiscontinuity || this.isPendingReset();
    }

    @Override
    public void onLoadCompleted(ExtractingLoadable loadable, long elapsedRealtimeMs, long loadDurationMs) {
        if (this.durationUs == -9223372036854775807L && this.seekMap != null) {
            boolean isSeekable = this.seekMap.isSeekable();
            long largestQueuedTimestampUs = this.getLargestQueuedTimestampUs();
            this.durationUs = largestQueuedTimestampUs == Long.MIN_VALUE ? 0L : largestQueuedTimestampUs + 10000L;
            this.listener.onSourceInfoRefreshed(this.durationUs, isSeekable);
        }
        this.eventDispatcher.loadCompleted(loadable.dataSpec, loadable.dataSource.getLastOpenedUri(), loadable.dataSource.getLastResponseHeaders(), 1, -1, null, 0, null, loadable.seekTimeUs, this.durationUs, elapsedRealtimeMs, loadDurationMs, loadable.dataSource.getBytesRead());
        this.copyLengthFromLoader(loadable);
        this.loadingFinished = true;
        Assertions.checkNotNull(this.callback).onContinueLoadingRequested(this);
    }

    @Override
    public void onLoadCanceled(ExtractingLoadable loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        this.eventDispatcher.loadCanceled(loadable.dataSpec, loadable.dataSource.getLastOpenedUri(), loadable.dataSource.getLastResponseHeaders(), 1, -1, null, 0, null, loadable.seekTimeUs, this.durationUs, elapsedRealtimeMs, loadDurationMs, loadable.dataSource.getBytesRead());
        if (!released) {
            this.copyLengthFromLoader(loadable);
            for (SampleQueue sampleQueue : this.sampleQueues) {
                sampleQueue.reset();
            }
            if (this.enabledTrackCount > 0) {
                Assertions.checkNotNull(this.callback).onContinueLoadingRequested(this);
            }
        }
    }

    @Override
    public Loader.LoadErrorAction onLoadError(ExtractingLoadable loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
        Loader.LoadErrorAction loadErrorAction;
        this.copyLengthFromLoader(loadable);
        long retryDelayMs = this.loadErrorHandlingPolicy.getRetryDelayMsFor(this.dataType, loadDurationMs, error, errorCount);
        if (retryDelayMs == -9223372036854775807L) {
            loadErrorAction = Loader.DONT_RETRY_FATAL;
        } else {
            int extractedSamplesCount = this.getExtractedSamplesCount();
            boolean madeProgress = extractedSamplesCount > this.extractedSamplesCountAtStartOfLoad;
            loadErrorAction = this.configureRetry(loadable, extractedSamplesCount) ? Loader.createRetryAction(madeProgress, retryDelayMs) : Loader.DONT_RETRY;
        }
        this.eventDispatcher.loadError(loadable.dataSpec, loadable.dataSource.getLastOpenedUri(), loadable.dataSource.getLastResponseHeaders(), 1, -1, null, 0, null, loadable.seekTimeUs, this.durationUs, elapsedRealtimeMs, loadDurationMs, loadable.dataSource.getBytesRead(), error, !loadErrorAction.isRetry());
        return loadErrorAction;
    }

    @Override
    public TrackOutput track(int id, int type) {
        return this.prepareTrackOutput(new TrackId(id, false));
    }

    @Override
    public void endTracks() {
        this.sampleQueuesBuilt = true;
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    @Override
    public void seekMap(SeekMap seekMap) {
        this.seekMap = this.icyHeaders == null ? seekMap : new SeekMap.Unseekable(-9223372036854775807L);
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    TrackOutput icyTrack() {
        return this.prepareTrackOutput(new TrackId(0, true));
    }

    @Override
    public void onUpstreamFormatChanged(Format format) {
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    private TrackOutput prepareTrackOutput(TrackId id) {
        int trackCount = this.sampleQueues.length;
        for (int i = 0; i < trackCount; ++i) {
            if (!id.equals(this.sampleQueueTrackIds[i])) continue;
            return this.sampleQueues[i];
        }
        SampleQueue trackOutput = new SampleQueue(this.allocator);
        trackOutput.setUpstreamFormatChangeListener(this);
        @NullableType TrackId[] sampleQueueTrackIds = Arrays.copyOf(this.sampleQueueTrackIds, trackCount + 1);
        sampleQueueTrackIds[trackCount] = id;
        this.sampleQueueTrackIds = Util.castNonNullTypeArray(sampleQueueTrackIds);
        @NullableType SampleQueue[] sampleQueues = Arrays.copyOf(this.sampleQueues, trackCount + 1);
        sampleQueues[trackCount] = trackOutput;
        this.sampleQueues = Util.castNonNullTypeArray(sampleQueues);
        return trackOutput;
    }

    private void maybeFinishPrepare() {
        SeekMap seekMap = this.seekMap;
        if (this.released || this.prepared || !this.sampleQueuesBuilt || seekMap == null) {
            return;
        }
        for (SampleQueue sampleQueue : this.sampleQueues) {
            if (sampleQueue.getUpstreamFormat() != null) continue;
            return;
        }
        this.loadCondition.close();
        int trackCount = this.sampleQueues.length;
        TrackGroup[] trackArray = new TrackGroup[trackCount];
        boolean[] trackIsAudioVideoFlags = new boolean[trackCount];
        this.durationUs = seekMap.getDurationUs();
        for (int i = 0; i < trackCount; ++i) {
            boolean isAudioVideo;
            Format trackFormat = this.sampleQueues[i].getUpstreamFormat();
            String mimeType = trackFormat.sampleMimeType;
            boolean isAudio = MimeTypes.isAudio(mimeType);
            trackIsAudioVideoFlags[i] = isAudioVideo = isAudio || MimeTypes.isVideo(mimeType);
            this.haveAudioVideoTracks |= isAudioVideo;
            IcyHeaders icyHeaders = this.icyHeaders;
            if (icyHeaders != null) {
                if (isAudio || this.sampleQueueTrackIds[i].isIcyTrack) {
                    Metadata metadata = trackFormat.metadata;
                    trackFormat = trackFormat.copyWithMetadata(metadata == null ? new Metadata(icyHeaders) : metadata.copyWithAppendedEntries(icyHeaders));
                }
                if (isAudio && trackFormat.bitrate == -1 && icyHeaders.bitrate != -1) {
                    trackFormat = trackFormat.copyWithBitrate(icyHeaders.bitrate);
                }
            }
            trackArray[i] = new TrackGroup(trackFormat);
        }
        this.dataType = this.length == -1L && seekMap.getDurationUs() == -9223372036854775807L ? 7 : 1;
        this.preparedState = new PreparedState(seekMap, new TrackGroupArray(trackArray), trackIsAudioVideoFlags);
        this.prepared = true;
        this.listener.onSourceInfoRefreshed(this.durationUs, seekMap.isSeekable());
        Assertions.checkNotNull(this.callback).onPrepared(this);
    }

    private PreparedState getPreparedState() {
        return Assertions.checkNotNull(this.preparedState);
    }

    private void copyLengthFromLoader(ExtractingLoadable loadable) {
        if (this.length == -1L) {
            this.length = loadable.length;
        }
    }

    private void startLoading() {
        ExtractingLoadable loadable = new ExtractingLoadable(this.uri, this.dataSource, this.extractorHolder, this, this.loadCondition);
        if (this.prepared) {
            SeekMap seekMap = this.getPreparedState().seekMap;
            Assertions.checkState(this.isPendingReset());
            if (this.durationUs != -9223372036854775807L && this.pendingResetPositionUs >= this.durationUs) {
                this.loadingFinished = true;
                this.pendingResetPositionUs = -9223372036854775807L;
                return;
            }
            loadable.setLoadPosition(seekMap.getSeekPoints((long)this.pendingResetPositionUs).first.position, this.pendingResetPositionUs);
            this.pendingResetPositionUs = -9223372036854775807L;
        }
        this.extractedSamplesCountAtStartOfLoad = this.getExtractedSamplesCount();
        long elapsedRealtimeMs = this.loader.startLoading(loadable, this, this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(this.dataType));
        this.eventDispatcher.loadStarted(loadable.dataSpec, 1, -1, null, 0, null, loadable.seekTimeUs, this.durationUs, elapsedRealtimeMs);
    }

    private boolean configureRetry(ExtractingLoadable loadable, int currentExtractedSampleCount) {
        if (this.length != -1L || this.seekMap != null && this.seekMap.getDurationUs() != -9223372036854775807L) {
            this.extractedSamplesCountAtStartOfLoad = currentExtractedSampleCount;
            return true;
        }
        if (this.prepared && !this.suppressRead()) {
            this.pendingDeferredRetry = true;
            return false;
        }
        this.notifyDiscontinuity = this.prepared;
        this.lastSeekPositionUs = 0L;
        this.extractedSamplesCountAtStartOfLoad = 0;
        for (SampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.reset();
        }
        loadable.setLoadPosition(0L, 0L);
        return true;
    }

    private boolean seekInsideBufferUs(boolean[] trackIsAudioVideoFlags, long positionUs) {
        int trackCount = this.sampleQueues.length;
        for (int i = 0; i < trackCount; ++i) {
            boolean seekInsideQueue;
            SampleQueue sampleQueue = this.sampleQueues[i];
            sampleQueue.rewind();
            boolean bl = seekInsideQueue = sampleQueue.advanceTo(positionUs, true, false) != -1;
            if (seekInsideQueue || !trackIsAudioVideoFlags[i] && this.haveAudioVideoTracks) continue;
            return false;
        }
        return true;
    }

    private int getExtractedSamplesCount() {
        int extractedSamplesCount = 0;
        for (SampleQueue sampleQueue : this.sampleQueues) {
            extractedSamplesCount += sampleQueue.getWriteIndex();
        }
        return extractedSamplesCount;
    }

    private long getLargestQueuedTimestampUs() {
        long largestQueuedTimestampUs = Long.MIN_VALUE;
        for (SampleQueue sampleQueue : this.sampleQueues) {
            largestQueuedTimestampUs = Math.max(largestQueuedTimestampUs, sampleQueue.getLargestQueuedTimestampUs());
        }
        return largestQueuedTimestampUs;
    }

    private boolean isPendingReset() {
        return this.pendingResetPositionUs != -9223372036854775807L;
    }

    private static final class TrackId {
        public final int id;
        public final boolean isIcyTrack;

        public TrackId(int id, boolean isIcyTrack) {
            this.id = id;
            this.isIcyTrack = isIcyTrack;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TrackId other = (TrackId)obj;
            return this.id == other.id && this.isIcyTrack == other.isIcyTrack;
        }

        public int hashCode() {
            return 31 * this.id + (this.isIcyTrack ? 1 : 0);
        }
    }

    private static final class PreparedState {
        public final SeekMap seekMap;
        public final TrackGroupArray tracks;
        public final boolean[] trackIsAudioVideoFlags;
        public final boolean[] trackEnabledStates;
        public final boolean[] trackNotifiedDownstreamFormats;

        public PreparedState(SeekMap seekMap, TrackGroupArray tracks, boolean[] trackIsAudioVideoFlags) {
            this.seekMap = seekMap;
            this.tracks = tracks;
            this.trackIsAudioVideoFlags = trackIsAudioVideoFlags;
            this.trackEnabledStates = new boolean[tracks.length];
            this.trackNotifiedDownstreamFormats = new boolean[tracks.length];
        }
    }

    private static final class ExtractorHolder {
        private final Extractor[] extractors;
        @Nullable
        private Extractor extractor;

        public ExtractorHolder(Extractor[] extractors) {
            this.extractors = extractors;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Extractor selectExtractor(ExtractorInput input, ExtractorOutput output, Uri uri) throws IOException, InterruptedException {
            if (this.extractor != null) {
                return this.extractor;
            }
            for (Extractor extractor : this.extractors) {
                try {
                    if (!extractor.sniff(input)) continue;
                    this.extractor = extractor;
                    break;
                }
                catch (EOFException eOFException) {
                }
                finally {
                    input.resetPeekPosition();
                }
            }
            if (this.extractor == null) {
                throw new UnrecognizedInputFormatException("None of the available extractors (" + Util.getCommaDelimitedSimpleClassNames(this.extractors) + ") could read the stream.", uri);
            }
            this.extractor.init(output);
            return this.extractor;
        }

        public void release() {
            if (this.extractor != null) {
                this.extractor.release();
                this.extractor = null;
            }
        }
    }

    final class ExtractingLoadable
    implements Loader.Loadable,
    IcyDataSource.Listener {
        private final Uri uri;
        private final StatsDataSource dataSource;
        private final ExtractorHolder extractorHolder;
        private final ExtractorOutput extractorOutput;
        private final ConditionVariable loadCondition;
        private final PositionHolder positionHolder;
        private volatile boolean loadCanceled;
        private boolean pendingExtractorSeek;
        private long seekTimeUs;
        private DataSpec dataSpec;
        private long length;
        @Nullable
        private TrackOutput icyTrackOutput;
        private boolean seenIcyMetadata;

        public ExtractingLoadable(Uri uri, DataSource dataSource, ExtractorHolder extractorHolder, ExtractorOutput extractorOutput, ConditionVariable loadCondition) {
            this.uri = uri;
            this.dataSource = new StatsDataSource(dataSource);
            this.extractorHolder = extractorHolder;
            this.extractorOutput = extractorOutput;
            this.loadCondition = loadCondition;
            this.positionHolder = new PositionHolder();
            this.pendingExtractorSeek = true;
            this.length = -1L;
            this.dataSpec = this.buildDataSpec(0L);
        }

        @Override
        public void cancelLoad() {
            this.loadCanceled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load() throws IOException, InterruptedException {
            int result = 0;
            while (result == 0 && !this.loadCanceled) {
                ExtractorInput input = null;
                try {
                    long position = this.positionHolder.position;
                    this.dataSpec = this.buildDataSpec(position);
                    this.length = this.dataSource.open(this.dataSpec);
                    if (this.length != -1L) {
                        this.length += position;
                    }
                    Uri uri = Assertions.checkNotNull(this.dataSource.getUri());
                    ProgressiveMediaPeriod.this.icyHeaders = IcyHeaders.parse(this.dataSource.getResponseHeaders());
                    DataSource extractorDataSource = this.dataSource;
                    if (ProgressiveMediaPeriod.this.icyHeaders != null && ((ProgressiveMediaPeriod)ProgressiveMediaPeriod.this).icyHeaders.metadataInterval != -1) {
                        extractorDataSource = new IcyDataSource(this.dataSource, ((ProgressiveMediaPeriod)ProgressiveMediaPeriod.this).icyHeaders.metadataInterval, this);
                        this.icyTrackOutput = ProgressiveMediaPeriod.this.icyTrack();
                        this.icyTrackOutput.format(ICY_FORMAT);
                    }
                    input = new DefaultExtractorInput(extractorDataSource, position, this.length);
                    Extractor extractor = this.extractorHolder.selectExtractor(input, this.extractorOutput, uri);
                    if (this.pendingExtractorSeek) {
                        extractor.seek(position, this.seekTimeUs);
                        this.pendingExtractorSeek = false;
                    }
                    while (result == 0 && !this.loadCanceled) {
                        this.loadCondition.block();
                        result = extractor.read(input, this.positionHolder);
                        if (input.getPosition() <= position + ProgressiveMediaPeriod.this.continueLoadingCheckIntervalBytes) continue;
                        position = input.getPosition();
                        this.loadCondition.close();
                        ProgressiveMediaPeriod.this.handler.post(ProgressiveMediaPeriod.this.onContinueLoadingRequestedRunnable);
                    }
                }
                finally {
                    if (result == 1) {
                        result = 0;
                    } else if (input != null) {
                        this.positionHolder.position = input.getPosition();
                    }
                    Util.closeQuietly(this.dataSource);
                }
            }
        }

        @Override
        public void onIcyMetadata(ParsableByteArray metadata) {
            long timeUs = !this.seenIcyMetadata ? this.seekTimeUs : Math.max(ProgressiveMediaPeriod.this.getLargestQueuedTimestampUs(), this.seekTimeUs);
            int length = metadata.bytesLeft();
            TrackOutput icyTrackOutput = Assertions.checkNotNull(this.icyTrackOutput);
            icyTrackOutput.sampleData(metadata, length);
            icyTrackOutput.sampleMetadata(timeUs, 1, length, 0, null);
            this.seenIcyMetadata = true;
        }

        private DataSpec buildDataSpec(long position) {
            return new DataSpec(this.uri, position, -1L, ProgressiveMediaPeriod.this.customCacheKey, 22);
        }

        private void setLoadPosition(long position, long timeUs) {
            this.positionHolder.position = position;
            this.seekTimeUs = timeUs;
            this.pendingExtractorSeek = true;
            this.seenIcyMetadata = false;
        }
    }

    private final class SampleStreamImpl
    implements SampleStream {
        private final int track;

        public SampleStreamImpl(int track) {
            this.track = track;
        }

        @Override
        public boolean isReady() {
            return ProgressiveMediaPeriod.this.isReady(this.track);
        }

        @Override
        public void maybeThrowError() throws IOException {
            ProgressiveMediaPeriod.this.maybeThrowError();
        }

        @Override
        public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, boolean formatRequired) {
            return ProgressiveMediaPeriod.this.readData(this.track, formatHolder, buffer, formatRequired);
        }

        @Override
        public int skipData(long positionUs) {
            return ProgressiveMediaPeriod.this.skipData(this.track, positionUs);
        }
    }

    static interface Listener {
        public void onSourceInfoRefreshed(long var1, boolean var3);
    }
}

