/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.CompositeMediaSource;
import com.google.android.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.DefaultCompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MergingMediaPeriod;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.TransferListener;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public final class MergingMediaSource
extends CompositeMediaSource<Integer> {
    private static final int PERIOD_COUNT_UNSET = -1;
    private final MediaSource[] mediaSources;
    private final Timeline[] timelines;
    private final ArrayList<MediaSource> pendingTimelineSources;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    private Object primaryManifest;
    private int periodCount;
    private IllegalMergeException mergeError;

    public MergingMediaSource(MediaSource ... mediaSources) {
        this(new DefaultCompositeSequenceableLoaderFactory(), mediaSources);
    }

    public MergingMediaSource(CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, MediaSource ... mediaSources) {
        this.mediaSources = mediaSources;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.pendingTimelineSources = new ArrayList<MediaSource>(Arrays.asList(mediaSources));
        this.periodCount = -1;
        this.timelines = new Timeline[mediaSources.length];
    }

    @Override
    @Nullable
    public Object getTag() {
        return this.mediaSources.length > 0 ? this.mediaSources[0].getTag() : null;
    }

    @Override
    public void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        super.prepareSourceInternal(mediaTransferListener);
        for (int i = 0; i < this.mediaSources.length; ++i) {
            this.prepareChildSource(i, this.mediaSources[i]);
        }
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        if (this.mergeError != null) {
            throw this.mergeError;
        }
        super.maybeThrowSourceInfoRefreshError();
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        MediaPeriod[] periods = new MediaPeriod[this.mediaSources.length];
        int periodIndex = this.timelines[0].getIndexOfPeriod(id.periodUid);
        for (int i = 0; i < periods.length; ++i) {
            MediaSource.MediaPeriodId childMediaPeriodId = id.copyWithPeriodUid(this.timelines[i].getUidOfPeriod(periodIndex));
            periods[i] = this.mediaSources[i].createPeriod(childMediaPeriodId, allocator, startPositionUs);
        }
        return new MergingMediaPeriod(this.compositeSequenceableLoaderFactory, periods);
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        MergingMediaPeriod mergingPeriod = (MergingMediaPeriod)mediaPeriod;
        for (int i = 0; i < this.mediaSources.length; ++i) {
            this.mediaSources[i].releasePeriod(mergingPeriod.periods[i]);
        }
    }

    @Override
    public void releaseSourceInternal() {
        super.releaseSourceInternal();
        Arrays.fill(this.timelines, null);
        this.primaryManifest = null;
        this.periodCount = -1;
        this.mergeError = null;
        this.pendingTimelineSources.clear();
        Collections.addAll(this.pendingTimelineSources, this.mediaSources);
    }

    @Override
    protected void onChildSourceInfoRefreshed(Integer id, MediaSource mediaSource, Timeline timeline, @Nullable Object manifest) {
        if (this.mergeError == null) {
            this.mergeError = this.checkTimelineMerges(timeline);
        }
        if (this.mergeError != null) {
            return;
        }
        this.pendingTimelineSources.remove(mediaSource);
        this.timelines[id.intValue()] = timeline;
        if (mediaSource == this.mediaSources[0]) {
            this.primaryManifest = manifest;
        }
        if (this.pendingTimelineSources.isEmpty()) {
            this.refreshSourceInfo(this.timelines[0], this.primaryManifest);
        }
    }

    @Override
    @Nullable
    protected MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(Integer id, MediaSource.MediaPeriodId mediaPeriodId) {
        return id == 0 ? mediaPeriodId : null;
    }

    private IllegalMergeException checkTimelineMerges(Timeline timeline) {
        if (this.periodCount == -1) {
            this.periodCount = timeline.getPeriodCount();
        } else if (timeline.getPeriodCount() != this.periodCount) {
            return new IllegalMergeException(0);
        }
        return null;
    }

    public static final class IllegalMergeException
    extends IOException {
        public static final int REASON_PERIOD_COUNT_MISMATCH = 0;
        public final int reason;

        public IllegalMergeException(int reason) {
            this.reason = reason;
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Reason {
        }
    }
}

