/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.os.Handler;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.TransferListener;
import java.io.IOException;

public interface MediaSource {
    public void addEventListener(Handler var1, MediaSourceEventListener var2);

    public void removeEventListener(MediaSourceEventListener var1);

    @Nullable
    default public Object getTag() {
        return null;
    }

    public void prepareSource(SourceInfoRefreshListener var1, @Nullable TransferListener var2);

    public void maybeThrowSourceInfoRefreshError() throws IOException;

    public MediaPeriod createPeriod(MediaPeriodId var1, Allocator var2, long var3);

    public void releasePeriod(MediaPeriod var1);

    public void releaseSource(SourceInfoRefreshListener var1);

    public static final class MediaPeriodId {
        public final Object periodUid;
        public final int adGroupIndex;
        public final int adIndexInAdGroup;
        public final long windowSequenceNumber;
        public final int nextAdGroupIndex;

        public MediaPeriodId(Object periodUid) {
            this(periodUid, -1L);
        }

        public MediaPeriodId(Object periodUid, long windowSequenceNumber) {
            this(periodUid, -1, -1, windowSequenceNumber, -1);
        }

        public MediaPeriodId(Object periodUid, long windowSequenceNumber, int nextAdGroupIndex) {
            this(periodUid, -1, -1, windowSequenceNumber, nextAdGroupIndex);
        }

        public MediaPeriodId(Object periodUid, int adGroupIndex, int adIndexInAdGroup, long windowSequenceNumber) {
            this(periodUid, adGroupIndex, adIndexInAdGroup, windowSequenceNumber, -1);
        }

        private MediaPeriodId(Object periodUid, int adGroupIndex, int adIndexInAdGroup, long windowSequenceNumber, int nextAdGroupIndex) {
            this.periodUid = periodUid;
            this.adGroupIndex = adGroupIndex;
            this.adIndexInAdGroup = adIndexInAdGroup;
            this.windowSequenceNumber = windowSequenceNumber;
            this.nextAdGroupIndex = nextAdGroupIndex;
        }

        public MediaPeriodId copyWithPeriodUid(Object newPeriodUid) {
            return this.periodUid.equals(newPeriodUid) ? this : new MediaPeriodId(newPeriodUid, this.adGroupIndex, this.adIndexInAdGroup, this.windowSequenceNumber, this.nextAdGroupIndex);
        }

        public boolean isAd() {
            return this.adGroupIndex != -1;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MediaPeriodId periodId = (MediaPeriodId)obj;
            return this.periodUid.equals(periodId.periodUid) && this.adGroupIndex == periodId.adGroupIndex && this.adIndexInAdGroup == periodId.adIndexInAdGroup && this.windowSequenceNumber == periodId.windowSequenceNumber && this.nextAdGroupIndex == periodId.nextAdGroupIndex;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.periodUid.hashCode();
            result = 31 * result + this.adGroupIndex;
            result = 31 * result + this.adIndexInAdGroup;
            result = 31 * result + (int)this.windowSequenceNumber;
            result = 31 * result + this.nextAdGroupIndex;
            return result;
        }
    }

    public static interface SourceInfoRefreshListener {
        public void onSourceInfoRefreshed(MediaSource var1, Timeline var2, @Nullable Object var3);
    }
}

