/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.os.Handler;
import android.os.Message;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.AbstractConcatenatedTimeline;
import com.google.android.exoplayer2.source.BaseMediaSource;
import com.google.android.exoplayer2.source.CompositeMediaSource;
import com.google.android.exoplayer2.source.DeferredMediaPeriod;
import com.google.android.exoplayer2.source.ForwardingTimeline;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ShuffleOrder;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConcatenatingMediaSource
extends CompositeMediaSource<MediaSourceHolder> {
    private static final int MSG_ADD = 0;
    private static final int MSG_REMOVE = 1;
    private static final int MSG_MOVE = 2;
    private static final int MSG_SET_SHUFFLE_ORDER = 3;
    private static final int MSG_UPDATE_TIMELINE = 4;
    private static final int MSG_ON_COMPLETION = 5;
    @GuardedBy(value="this")
    private final List<MediaSourceHolder> mediaSourcesPublic;
    @GuardedBy(value="this")
    private final Set<HandlerAndRunnable> pendingOnCompletionActions;
    @GuardedBy(value="this")
    @Nullable
    private Handler playbackThreadHandler;
    private final List<MediaSourceHolder> mediaSourceHolders;
    private final Map<MediaPeriod, MediaSourceHolder> mediaSourceByMediaPeriod;
    private final Map<Object, MediaSourceHolder> mediaSourceByUid;
    private final boolean isAtomic;
    private final boolean useLazyPreparation;
    private final Timeline.Window window;
    private final Timeline.Period period;
    private boolean timelineUpdateScheduled;
    private Set<HandlerAndRunnable> nextTimelineUpdateOnCompletionActions;
    private ShuffleOrder shuffleOrder;
    private int windowCount;
    private int periodCount;

    public ConcatenatingMediaSource(MediaSource ... mediaSources) {
        this(false, mediaSources);
    }

    public ConcatenatingMediaSource(boolean isAtomic, MediaSource ... mediaSources) {
        this(isAtomic, new ShuffleOrder.DefaultShuffleOrder(0), mediaSources);
    }

    public ConcatenatingMediaSource(boolean isAtomic, ShuffleOrder shuffleOrder, MediaSource ... mediaSources) {
        this(isAtomic, false, shuffleOrder, mediaSources);
    }

    public ConcatenatingMediaSource(boolean isAtomic, boolean useLazyPreparation, ShuffleOrder shuffleOrder, MediaSource ... mediaSources) {
        for (MediaSource mediaSource : mediaSources) {
            Assertions.checkNotNull(mediaSource);
        }
        this.shuffleOrder = shuffleOrder.getLength() > 0 ? shuffleOrder.cloneAndClear() : shuffleOrder;
        this.mediaSourceByMediaPeriod = new IdentityHashMap<MediaPeriod, MediaSourceHolder>();
        this.mediaSourceByUid = new HashMap<Object, MediaSourceHolder>();
        this.mediaSourcesPublic = new ArrayList<MediaSourceHolder>();
        this.mediaSourceHolders = new ArrayList<MediaSourceHolder>();
        this.nextTimelineUpdateOnCompletionActions = new HashSet<HandlerAndRunnable>();
        this.pendingOnCompletionActions = new HashSet<HandlerAndRunnable>();
        this.isAtomic = isAtomic;
        this.useLazyPreparation = useLazyPreparation;
        this.window = new Timeline.Window();
        this.period = new Timeline.Period();
        this.addMediaSources(Arrays.asList(mediaSources));
    }

    public final synchronized void addMediaSource(MediaSource mediaSource) {
        this.addMediaSource(this.mediaSourcesPublic.size(), mediaSource);
    }

    public final synchronized void addMediaSource(MediaSource mediaSource, Handler handler, Runnable onCompletionAction) {
        this.addMediaSource(this.mediaSourcesPublic.size(), mediaSource, handler, onCompletionAction);
    }

    public final synchronized void addMediaSource(int index, MediaSource mediaSource) {
        this.addPublicMediaSources(index, Collections.singletonList(mediaSource), null, null);
    }

    public final synchronized void addMediaSource(int index, MediaSource mediaSource, Handler handler, Runnable onCompletionAction) {
        this.addPublicMediaSources(index, Collections.singletonList(mediaSource), handler, onCompletionAction);
    }

    public final synchronized void addMediaSources(Collection<MediaSource> mediaSources) {
        this.addPublicMediaSources(this.mediaSourcesPublic.size(), mediaSources, null, null);
    }

    public final synchronized void addMediaSources(Collection<MediaSource> mediaSources, Handler handler, Runnable onCompletionAction) {
        this.addPublicMediaSources(this.mediaSourcesPublic.size(), mediaSources, handler, onCompletionAction);
    }

    public final synchronized void addMediaSources(int index, Collection<MediaSource> mediaSources) {
        this.addPublicMediaSources(index, mediaSources, null, null);
    }

    public final synchronized void addMediaSources(int index, Collection<MediaSource> mediaSources, Handler handler, Runnable onCompletionAction) {
        this.addPublicMediaSources(index, mediaSources, handler, onCompletionAction);
    }

    public final synchronized void removeMediaSource(int index) {
        this.removePublicMediaSources(index, index + 1, null, null);
    }

    public final synchronized void removeMediaSource(int index, Handler handler, Runnable onCompletionAction) {
        this.removePublicMediaSources(index, index + 1, handler, onCompletionAction);
    }

    public final synchronized void removeMediaSourceRange(int fromIndex, int toIndex) {
        this.removePublicMediaSources(fromIndex, toIndex, null, null);
    }

    public final synchronized void removeMediaSourceRange(int fromIndex, int toIndex, Handler handler, Runnable onCompletionAction) {
        this.removePublicMediaSources(fromIndex, toIndex, handler, onCompletionAction);
    }

    public final synchronized void moveMediaSource(int currentIndex, int newIndex) {
        this.movePublicMediaSource(currentIndex, newIndex, null, null);
    }

    public final synchronized void moveMediaSource(int currentIndex, int newIndex, Handler handler, Runnable onCompletionAction) {
        this.movePublicMediaSource(currentIndex, newIndex, handler, onCompletionAction);
    }

    public final synchronized void clear() {
        this.removeMediaSourceRange(0, this.getSize());
    }

    public final synchronized void clear(Handler handler, Runnable onCompletionAction) {
        this.removeMediaSourceRange(0, this.getSize(), handler, onCompletionAction);
    }

    public final synchronized int getSize() {
        return this.mediaSourcesPublic.size();
    }

    public final synchronized MediaSource getMediaSource(int index) {
        return this.mediaSourcesPublic.get((int)index).mediaSource;
    }

    public final synchronized void setShuffleOrder(ShuffleOrder shuffleOrder) {
        this.setPublicShuffleOrder(shuffleOrder, null, null);
    }

    public final synchronized void setShuffleOrder(ShuffleOrder shuffleOrder, Handler handler, Runnable onCompletionAction) {
        this.setPublicShuffleOrder(shuffleOrder, handler, onCompletionAction);
    }

    @Override
    @Nullable
    public Object getTag() {
        return null;
    }

    @Override
    public final synchronized void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        super.prepareSourceInternal(mediaTransferListener);
        this.playbackThreadHandler = new Handler(this::handleMessage);
        if (this.mediaSourcesPublic.isEmpty()) {
            this.updateTimelineAndScheduleOnCompletionActions();
        } else {
            this.shuffleOrder = this.shuffleOrder.cloneAndInsert(0, this.mediaSourcesPublic.size());
            this.addMediaSourcesInternal(0, this.mediaSourcesPublic);
            this.scheduleTimelineUpdate();
        }
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
    }

    @Override
    public final MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        Object mediaSourceHolderUid = ConcatenatingMediaSource.getMediaSourceHolderUid(id.periodUid);
        MediaSourceHolder holder = this.mediaSourceByUid.get(mediaSourceHolderUid);
        if (holder == null) {
            holder = new MediaSourceHolder(new DummyMediaSource());
            holder.hasStartedPreparing = true;
        }
        DeferredMediaPeriod mediaPeriod = new DeferredMediaPeriod(holder.mediaSource, id, allocator, startPositionUs);
        this.mediaSourceByMediaPeriod.put(mediaPeriod, holder);
        holder.activeMediaPeriods.add(mediaPeriod);
        if (!holder.hasStartedPreparing) {
            holder.hasStartedPreparing = true;
            this.prepareChildSource(holder, holder.mediaSource);
        } else if (holder.isPrepared) {
            MediaSource.MediaPeriodId idInSource = id.copyWithPeriodUid(ConcatenatingMediaSource.getChildPeriodUid(holder, id.periodUid));
            mediaPeriod.createPeriod(idInSource);
        }
        return mediaPeriod;
    }

    @Override
    public final void releasePeriod(MediaPeriod mediaPeriod) {
        MediaSourceHolder holder = Assertions.checkNotNull(this.mediaSourceByMediaPeriod.remove(mediaPeriod));
        ((DeferredMediaPeriod)mediaPeriod).releasePeriod();
        holder.activeMediaPeriods.remove(mediaPeriod);
        this.maybeReleaseChildSource(holder);
    }

    @Override
    public final synchronized void releaseSourceInternal() {
        super.releaseSourceInternal();
        this.mediaSourceHolders.clear();
        this.mediaSourceByUid.clear();
        this.shuffleOrder = this.shuffleOrder.cloneAndClear();
        this.windowCount = 0;
        this.periodCount = 0;
        if (this.playbackThreadHandler != null) {
            this.playbackThreadHandler.removeCallbacksAndMessages(null);
            this.playbackThreadHandler = null;
        }
        this.timelineUpdateScheduled = false;
        this.nextTimelineUpdateOnCompletionActions.clear();
        this.dispatchOnCompletionActions(this.pendingOnCompletionActions);
    }

    @Override
    protected final void onChildSourceInfoRefreshed(MediaSourceHolder mediaSourceHolder, MediaSource mediaSource, Timeline timeline, @Nullable Object manifest) {
        this.updateMediaSourceInternal(mediaSourceHolder, timeline);
    }

    @Override
    @Nullable
    protected MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(MediaSourceHolder mediaSourceHolder, MediaSource.MediaPeriodId mediaPeriodId) {
        for (int i = 0; i < mediaSourceHolder.activeMediaPeriods.size(); ++i) {
            if (mediaSourceHolder.activeMediaPeriods.get((int)i).id.windowSequenceNumber != mediaPeriodId.windowSequenceNumber) continue;
            Object periodUid = ConcatenatingMediaSource.getPeriodUid(mediaSourceHolder, mediaPeriodId.periodUid);
            return mediaPeriodId.copyWithPeriodUid(periodUid);
        }
        return null;
    }

    @Override
    protected int getWindowIndexForChildWindowIndex(MediaSourceHolder mediaSourceHolder, int windowIndex) {
        return windowIndex + mediaSourceHolder.firstWindowIndexInChild;
    }

    @GuardedBy(value="this")
    private void addPublicMediaSources(int index, Collection<MediaSource> mediaSources, @Nullable Handler handler, @Nullable Runnable onCompletionAction) {
        Assertions.checkArgument(handler == null == (onCompletionAction == null));
        Handler playbackThreadHandler = this.playbackThreadHandler;
        for (MediaSource mediaSource : mediaSources) {
            Assertions.checkNotNull(mediaSource);
        }
        ArrayList<MediaSourceHolder> mediaSourceHolders = new ArrayList<MediaSourceHolder>(mediaSources.size());
        for (MediaSource mediaSource : mediaSources) {
            mediaSourceHolders.add(new MediaSourceHolder(mediaSource));
        }
        this.mediaSourcesPublic.addAll(index, mediaSourceHolders);
        if (playbackThreadHandler != null && !mediaSources.isEmpty()) {
            HandlerAndRunnable handlerAndRunnable = this.createOnCompletionAction(handler, onCompletionAction);
            playbackThreadHandler.obtainMessage(0, new MessageData(index, mediaSourceHolders, handlerAndRunnable)).sendToTarget();
        } else if (onCompletionAction != null && handler != null) {
            handler.post(onCompletionAction);
        }
    }

    @GuardedBy(value="this")
    private void removePublicMediaSources(int fromIndex, int toIndex, @Nullable Handler handler, @Nullable Runnable onCompletionAction) {
        Assertions.checkArgument(handler == null == (onCompletionAction == null));
        Handler playbackThreadHandler = this.playbackThreadHandler;
        Util.removeRange(this.mediaSourcesPublic, fromIndex, toIndex);
        if (playbackThreadHandler != null) {
            HandlerAndRunnable callbackAction = this.createOnCompletionAction(handler, onCompletionAction);
            playbackThreadHandler.obtainMessage(1, new MessageData<Integer>(fromIndex, toIndex, callbackAction)).sendToTarget();
        } else if (onCompletionAction != null && handler != null) {
            handler.post(onCompletionAction);
        }
    }

    @GuardedBy(value="this")
    private void movePublicMediaSource(int currentIndex, int newIndex, @Nullable Handler handler, @Nullable Runnable onCompletionAction) {
        Assertions.checkArgument(handler == null == (onCompletionAction == null));
        Handler playbackThreadHandler = this.playbackThreadHandler;
        this.mediaSourcesPublic.add(newIndex, this.mediaSourcesPublic.remove(currentIndex));
        if (playbackThreadHandler != null) {
            HandlerAndRunnable callbackAction = this.createOnCompletionAction(handler, onCompletionAction);
            playbackThreadHandler.obtainMessage(2, new MessageData<Integer>(currentIndex, newIndex, callbackAction)).sendToTarget();
        } else if (onCompletionAction != null && handler != null) {
            handler.post(onCompletionAction);
        }
    }

    @GuardedBy(value="this")
    private void setPublicShuffleOrder(ShuffleOrder shuffleOrder, @Nullable Handler handler, @Nullable Runnable onCompletionAction) {
        Assertions.checkArgument(handler == null == (onCompletionAction == null));
        Handler playbackThreadHandler = this.playbackThreadHandler;
        if (playbackThreadHandler != null) {
            int size = this.getSize();
            if (shuffleOrder.getLength() != size) {
                shuffleOrder = shuffleOrder.cloneAndClear().cloneAndInsert(0, size);
            }
            HandlerAndRunnable callbackAction = this.createOnCompletionAction(handler, onCompletionAction);
            playbackThreadHandler.obtainMessage(3, new MessageData<ShuffleOrder>(0, shuffleOrder, callbackAction)).sendToTarget();
        } else {
            ShuffleOrder shuffleOrder2 = this.shuffleOrder = shuffleOrder.getLength() > 0 ? shuffleOrder.cloneAndClear() : shuffleOrder;
            if (onCompletionAction != null && handler != null) {
                handler.post(onCompletionAction);
            }
        }
    }

    @GuardedBy(value="this")
    @Nullable
    private HandlerAndRunnable createOnCompletionAction(@Nullable Handler handler, @Nullable Runnable runnable) {
        if (handler == null || runnable == null) {
            return null;
        }
        HandlerAndRunnable handlerAndRunnable = new HandlerAndRunnable(handler, runnable);
        this.pendingOnCompletionActions.add(handlerAndRunnable);
        return handlerAndRunnable;
    }

    private boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                MessageData addMessage = (MessageData)Util.castNonNull(msg.obj);
                this.shuffleOrder = this.shuffleOrder.cloneAndInsert(addMessage.index, ((Collection)addMessage.customData).size());
                this.addMediaSourcesInternal(addMessage.index, (Collection)addMessage.customData);
                this.scheduleTimelineUpdate(addMessage.onCompletionAction);
                break;
            }
            case 1: {
                MessageData removeMessage = (MessageData)Util.castNonNull(msg.obj);
                int fromIndex = removeMessage.index;
                int toIndex = (Integer)removeMessage.customData;
                this.shuffleOrder = fromIndex == 0 && toIndex == this.shuffleOrder.getLength() ? this.shuffleOrder.cloneAndClear() : this.shuffleOrder.cloneAndRemove(fromIndex, toIndex);
                for (int index = toIndex - 1; index >= fromIndex; --index) {
                    this.removeMediaSourceInternal(index);
                }
                this.scheduleTimelineUpdate(removeMessage.onCompletionAction);
                break;
            }
            case 2: {
                MessageData moveMessage = (MessageData)Util.castNonNull(msg.obj);
                this.shuffleOrder = this.shuffleOrder.cloneAndRemove(moveMessage.index, moveMessage.index + 1);
                this.shuffleOrder = this.shuffleOrder.cloneAndInsert((Integer)moveMessage.customData, 1);
                this.moveMediaSourceInternal(moveMessage.index, (Integer)moveMessage.customData);
                this.scheduleTimelineUpdate(moveMessage.onCompletionAction);
                break;
            }
            case 3: {
                MessageData shuffleOrderMessage = (MessageData)Util.castNonNull(msg.obj);
                this.shuffleOrder = (ShuffleOrder)shuffleOrderMessage.customData;
                this.scheduleTimelineUpdate(shuffleOrderMessage.onCompletionAction);
                break;
            }
            case 4: {
                this.updateTimelineAndScheduleOnCompletionActions();
                break;
            }
            case 5: {
                Set actions = (Set)Util.castNonNull(msg.obj);
                this.dispatchOnCompletionActions(actions);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return true;
    }

    private void scheduleTimelineUpdate() {
        this.scheduleTimelineUpdate(null);
    }

    private void scheduleTimelineUpdate(@Nullable HandlerAndRunnable onCompletionAction) {
        if (!this.timelineUpdateScheduled) {
            this.getPlaybackThreadHandlerOnPlaybackThread().obtainMessage(4).sendToTarget();
            this.timelineUpdateScheduled = true;
        }
        if (onCompletionAction != null) {
            this.nextTimelineUpdateOnCompletionActions.add(onCompletionAction);
        }
    }

    private void updateTimelineAndScheduleOnCompletionActions() {
        this.timelineUpdateScheduled = false;
        Set<HandlerAndRunnable> onCompletionActions = this.nextTimelineUpdateOnCompletionActions;
        this.nextTimelineUpdateOnCompletionActions = new HashSet<HandlerAndRunnable>();
        this.refreshSourceInfo(new ConcatenatedTimeline(this.mediaSourceHolders, this.windowCount, this.periodCount, this.shuffleOrder, this.isAtomic), null);
        this.getPlaybackThreadHandlerOnPlaybackThread().obtainMessage(5, onCompletionActions).sendToTarget();
    }

    private Handler getPlaybackThreadHandlerOnPlaybackThread() {
        return Assertions.checkNotNull(this.playbackThreadHandler);
    }

    private synchronized void dispatchOnCompletionActions(Set<HandlerAndRunnable> onCompletionActions) {
        for (HandlerAndRunnable pendingAction : onCompletionActions) {
            pendingAction.dispatch();
        }
        this.pendingOnCompletionActions.removeAll(onCompletionActions);
    }

    private void addMediaSourcesInternal(int index, Collection<MediaSourceHolder> mediaSourceHolders) {
        for (MediaSourceHolder mediaSourceHolder : mediaSourceHolders) {
            this.addMediaSourceInternal(index++, mediaSourceHolder);
        }
    }

    private void addMediaSourceInternal(int newIndex, MediaSourceHolder newMediaSourceHolder) {
        if (newIndex > 0) {
            MediaSourceHolder previousHolder = this.mediaSourceHolders.get(newIndex - 1);
            newMediaSourceHolder.reset(newIndex, previousHolder.firstWindowIndexInChild + previousHolder.timeline.getWindowCount(), previousHolder.firstPeriodIndexInChild + previousHolder.timeline.getPeriodCount());
        } else {
            newMediaSourceHolder.reset(newIndex, 0, 0);
        }
        this.correctOffsets(newIndex, 1, newMediaSourceHolder.timeline.getWindowCount(), newMediaSourceHolder.timeline.getPeriodCount());
        this.mediaSourceHolders.add(newIndex, newMediaSourceHolder);
        this.mediaSourceByUid.put(newMediaSourceHolder.uid, newMediaSourceHolder);
        if (!this.useLazyPreparation) {
            newMediaSourceHolder.hasStartedPreparing = true;
            this.prepareChildSource(newMediaSourceHolder, newMediaSourceHolder.mediaSource);
        }
    }

    private void updateMediaSourceInternal(MediaSourceHolder mediaSourceHolder, Timeline timeline) {
        if (mediaSourceHolder == null) {
            throw new IllegalArgumentException();
        }
        DeferredTimeline deferredTimeline = mediaSourceHolder.timeline;
        if (deferredTimeline.getTimeline() == timeline) {
            return;
        }
        int windowOffsetUpdate = timeline.getWindowCount() - deferredTimeline.getWindowCount();
        int periodOffsetUpdate = timeline.getPeriodCount() - deferredTimeline.getPeriodCount();
        if (windowOffsetUpdate != 0 || periodOffsetUpdate != 0) {
            this.correctOffsets(mediaSourceHolder.childIndex + 1, 0, windowOffsetUpdate, periodOffsetUpdate);
        }
        if (mediaSourceHolder.isPrepared) {
            mediaSourceHolder.timeline = deferredTimeline.cloneWithUpdatedTimeline(timeline);
        } else if (timeline.isEmpty()) {
            mediaSourceHolder.timeline = DeferredTimeline.createWithRealTimeline(timeline, DeferredTimeline.DUMMY_ID);
        } else {
            long periodPreparePositionUs;
            Assertions.checkState(mediaSourceHolder.activeMediaPeriods.size() <= 1);
            DeferredMediaPeriod deferredMediaPeriod = mediaSourceHolder.activeMediaPeriods.isEmpty() ? null : mediaSourceHolder.activeMediaPeriods.get(0);
            timeline.getWindow(0, this.window);
            long windowStartPositionUs = this.window.getDefaultPositionUs();
            if (deferredMediaPeriod != null && (periodPreparePositionUs = deferredMediaPeriod.getPreparePositionUs()) != 0L) {
                windowStartPositionUs = periodPreparePositionUs;
            }
            Pair<Object, Long> periodPosition = timeline.getPeriodPosition(this.window, this.period, 0, windowStartPositionUs);
            Object periodUid = periodPosition.first;
            long periodPositionUs = (Long)periodPosition.second;
            mediaSourceHolder.timeline = DeferredTimeline.createWithRealTimeline(timeline, periodUid);
            if (deferredMediaPeriod != null) {
                deferredMediaPeriod.overridePreparePositionUs(periodPositionUs);
                MediaSource.MediaPeriodId idInSource = deferredMediaPeriod.id.copyWithPeriodUid(ConcatenatingMediaSource.getChildPeriodUid(mediaSourceHolder, deferredMediaPeriod.id.periodUid));
                deferredMediaPeriod.createPeriod(idInSource);
            }
        }
        mediaSourceHolder.isPrepared = true;
        this.scheduleTimelineUpdate();
    }

    private void removeMediaSourceInternal(int index) {
        MediaSourceHolder holder = this.mediaSourceHolders.remove(index);
        this.mediaSourceByUid.remove(holder.uid);
        DeferredTimeline oldTimeline = holder.timeline;
        this.correctOffsets(index, -1, -((Timeline)oldTimeline).getWindowCount(), -((Timeline)oldTimeline).getPeriodCount());
        holder.isRemoved = true;
        this.maybeReleaseChildSource(holder);
    }

    private void moveMediaSourceInternal(int currentIndex, int newIndex) {
        int startIndex = Math.min(currentIndex, newIndex);
        int endIndex = Math.max(currentIndex, newIndex);
        int windowOffset = this.mediaSourceHolders.get((int)startIndex).firstWindowIndexInChild;
        int periodOffset = this.mediaSourceHolders.get((int)startIndex).firstPeriodIndexInChild;
        this.mediaSourceHolders.add(newIndex, this.mediaSourceHolders.remove(currentIndex));
        for (int i = startIndex; i <= endIndex; ++i) {
            MediaSourceHolder holder = this.mediaSourceHolders.get(i);
            holder.firstWindowIndexInChild = windowOffset;
            holder.firstPeriodIndexInChild = periodOffset;
            windowOffset += holder.timeline.getWindowCount();
            periodOffset += holder.timeline.getPeriodCount();
        }
    }

    private void correctOffsets(int startIndex, int childIndexUpdate, int windowOffsetUpdate, int periodOffsetUpdate) {
        this.windowCount += windowOffsetUpdate;
        this.periodCount += periodOffsetUpdate;
        for (int i = startIndex; i < this.mediaSourceHolders.size(); ++i) {
            this.mediaSourceHolders.get((int)i).childIndex += childIndexUpdate;
            this.mediaSourceHolders.get((int)i).firstWindowIndexInChild += windowOffsetUpdate;
            this.mediaSourceHolders.get((int)i).firstPeriodIndexInChild += periodOffsetUpdate;
        }
    }

    private void maybeReleaseChildSource(MediaSourceHolder mediaSourceHolder) {
        if (mediaSourceHolder.isRemoved && mediaSourceHolder.hasStartedPreparing && mediaSourceHolder.activeMediaPeriods.isEmpty()) {
            this.releaseChildSource(mediaSourceHolder);
        }
    }

    private static Object getMediaSourceHolderUid(Object periodUid) {
        return ConcatenatedTimeline.getChildTimelineUidFromConcatenatedUid(periodUid);
    }

    private static Object getChildPeriodUid(MediaSourceHolder holder, Object periodUid) {
        Object childUid = ConcatenatedTimeline.getChildPeriodUidFromConcatenatedUid(periodUid);
        return childUid.equals(DeferredTimeline.DUMMY_ID) ? holder.timeline.replacedId : childUid;
    }

    private static Object getPeriodUid(MediaSourceHolder holder, Object childPeriodUid) {
        if (holder.timeline.replacedId.equals(childPeriodUid)) {
            childPeriodUid = DeferredTimeline.DUMMY_ID;
        }
        return ConcatenatedTimeline.getConcatenatedUid(holder.uid, childPeriodUid);
    }

    private static final class HandlerAndRunnable {
        private final Handler handler;
        private final Runnable runnable;

        public HandlerAndRunnable(Handler handler, Runnable runnable) {
            this.handler = handler;
            this.runnable = runnable;
        }

        public void dispatch() {
            this.handler.post(this.runnable);
        }
    }

    private static final class DummyMediaSource
    extends BaseMediaSource {
        private DummyMediaSource() {
        }

        @Override
        protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        }

        @Override
        @Nullable
        public Object getTag() {
            return null;
        }

        @Override
        protected void releaseSourceInternal() {
        }

        @Override
        public void maybeThrowSourceInfoRefreshError() throws IOException {
        }

        @Override
        public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void releasePeriod(MediaPeriod mediaPeriod) {
        }
    }

    private static final class DummyTimeline
    extends Timeline {
        @Nullable
        private final Object tag;

        public DummyTimeline(@Nullable Object tag) {
            this.tag = tag;
        }

        @Override
        public int getWindowCount() {
            return 1;
        }

        @Override
        public Timeline.Window getWindow(int windowIndex, Timeline.Window window, boolean setTag, long defaultPositionProjectionUs) {
            return window.set(this.tag, -9223372036854775807L, -9223372036854775807L, false, true, 0L, -9223372036854775807L, 0, 0, 0L);
        }

        @Override
        public int getPeriodCount() {
            return 1;
        }

        @Override
        public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
            return period.set(0, DeferredTimeline.DUMMY_ID, 0, -9223372036854775807L, 0L);
        }

        @Override
        public int getIndexOfPeriod(Object uid) {
            return uid == DeferredTimeline.DUMMY_ID ? 0 : -1;
        }

        @Override
        public Object getUidOfPeriod(int periodIndex) {
            return DeferredTimeline.DUMMY_ID;
        }
    }

    private static final class DeferredTimeline
    extends ForwardingTimeline {
        private static final Object DUMMY_ID = new Object();
        private final Object replacedId;

        public static DeferredTimeline createWithDummyTimeline(@Nullable Object windowTag) {
            return new DeferredTimeline(new DummyTimeline(windowTag), DUMMY_ID);
        }

        public static DeferredTimeline createWithRealTimeline(Timeline timeline, Object firstPeriodUid) {
            return new DeferredTimeline(timeline, firstPeriodUid);
        }

        private DeferredTimeline(Timeline timeline, Object replacedId) {
            super(timeline);
            this.replacedId = replacedId;
        }

        public DeferredTimeline cloneWithUpdatedTimeline(Timeline timeline) {
            return new DeferredTimeline(timeline, this.replacedId);
        }

        public Timeline getTimeline() {
            return this.timeline;
        }

        @Override
        public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
            this.timeline.getPeriod(periodIndex, period, setIds);
            if (Util.areEqual(period.uid, this.replacedId)) {
                period.uid = DUMMY_ID;
            }
            return period;
        }

        @Override
        public int getIndexOfPeriod(Object uid) {
            return this.timeline.getIndexOfPeriod(DUMMY_ID.equals(uid) ? this.replacedId : uid);
        }

        @Override
        public Object getUidOfPeriod(int periodIndex) {
            Object uid = this.timeline.getUidOfPeriod(periodIndex);
            return Util.areEqual(uid, this.replacedId) ? DUMMY_ID : uid;
        }
    }

    private static final class ConcatenatedTimeline
    extends AbstractConcatenatedTimeline {
        private final int windowCount;
        private final int periodCount;
        private final int[] firstPeriodInChildIndices;
        private final int[] firstWindowInChildIndices;
        private final Timeline[] timelines;
        private final Object[] uids;
        private final HashMap<Object, Integer> childIndexByUid;

        public ConcatenatedTimeline(Collection<MediaSourceHolder> mediaSourceHolders, int windowCount, int periodCount, ShuffleOrder shuffleOrder, boolean isAtomic) {
            super(isAtomic, shuffleOrder);
            this.windowCount = windowCount;
            this.periodCount = periodCount;
            int childCount = mediaSourceHolders.size();
            this.firstPeriodInChildIndices = new int[childCount];
            this.firstWindowInChildIndices = new int[childCount];
            this.timelines = new Timeline[childCount];
            this.uids = new Object[childCount];
            this.childIndexByUid = new HashMap();
            int index = 0;
            for (MediaSourceHolder mediaSourceHolder : mediaSourceHolders) {
                this.timelines[index] = mediaSourceHolder.timeline;
                this.firstPeriodInChildIndices[index] = mediaSourceHolder.firstPeriodIndexInChild;
                this.firstWindowInChildIndices[index] = mediaSourceHolder.firstWindowIndexInChild;
                this.uids[index] = mediaSourceHolder.uid;
                this.childIndexByUid.put(this.uids[index], index++);
            }
        }

        @Override
        protected int getChildIndexByPeriodIndex(int periodIndex) {
            return Util.binarySearchFloor(this.firstPeriodInChildIndices, periodIndex + 1, false, false);
        }

        @Override
        protected int getChildIndexByWindowIndex(int windowIndex) {
            return Util.binarySearchFloor(this.firstWindowInChildIndices, windowIndex + 1, false, false);
        }

        @Override
        protected int getChildIndexByChildUid(Object childUid) {
            Integer index = this.childIndexByUid.get(childUid);
            return index == null ? -1 : index;
        }

        @Override
        protected Timeline getTimelineByChildIndex(int childIndex) {
            return this.timelines[childIndex];
        }

        @Override
        protected int getFirstPeriodIndexByChildIndex(int childIndex) {
            return this.firstPeriodInChildIndices[childIndex];
        }

        @Override
        protected int getFirstWindowIndexByChildIndex(int childIndex) {
            return this.firstWindowInChildIndices[childIndex];
        }

        @Override
        protected Object getChildUidByChildIndex(int childIndex) {
            return this.uids[childIndex];
        }

        @Override
        public int getWindowCount() {
            return this.windowCount;
        }

        @Override
        public int getPeriodCount() {
            return this.periodCount;
        }
    }

    private static final class MessageData<T> {
        public final int index;
        public final T customData;
        @Nullable
        public final HandlerAndRunnable onCompletionAction;

        public MessageData(int index, T customData, @Nullable HandlerAndRunnable onCompletionAction) {
            this.index = index;
            this.customData = customData;
            this.onCompletionAction = onCompletionAction;
        }
    }

    static final class MediaSourceHolder
    implements Comparable<MediaSourceHolder> {
        public final MediaSource mediaSource;
        public final Object uid;
        public final List<DeferredMediaPeriod> activeMediaPeriods;
        public DeferredTimeline timeline;
        public int childIndex;
        public int firstWindowIndexInChild;
        public int firstPeriodIndexInChild;
        public boolean hasStartedPreparing;
        public boolean isPrepared;
        public boolean isRemoved;

        public MediaSourceHolder(MediaSource mediaSource) {
            this.mediaSource = mediaSource;
            this.timeline = DeferredTimeline.createWithDummyTimeline(mediaSource.getTag());
            this.activeMediaPeriods = new ArrayList<DeferredMediaPeriod>();
            this.uid = new Object();
        }

        public void reset(int childIndex, int firstWindowIndexInChild, int firstPeriodIndexInChild) {
            this.childIndex = childIndex;
            this.firstWindowIndexInChild = firstWindowIndexInChild;
            this.firstPeriodIndexInChild = firstPeriodIndexInChild;
            this.hasStartedPreparing = false;
            this.isPrepared = false;
            this.isRemoved = false;
            this.activeMediaPeriods.clear();
        }

        @Override
        public int compareTo(@NonNull MediaSourceHolder other) {
            return this.firstPeriodIndexInChild - other.firstPeriodIndexInChild;
        }
    }
}

