/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import com.google.android.exoplayer2.source.SequenceableLoader;

public class CompositeSequenceableLoader
implements SequenceableLoader {
    protected final SequenceableLoader[] loaders;

    public CompositeSequenceableLoader(SequenceableLoader[] loaders) {
        this.loaders = loaders;
    }

    @Override
    public final long getBufferedPositionUs() {
        long bufferedPositionUs = Long.MAX_VALUE;
        for (SequenceableLoader loader : this.loaders) {
            long loaderBufferedPositionUs = loader.getBufferedPositionUs();
            if (loaderBufferedPositionUs == Long.MIN_VALUE) continue;
            bufferedPositionUs = Math.min(bufferedPositionUs, loaderBufferedPositionUs);
        }
        return bufferedPositionUs == Long.MAX_VALUE ? Long.MIN_VALUE : bufferedPositionUs;
    }

    @Override
    public final long getNextLoadPositionUs() {
        long nextLoadPositionUs = Long.MAX_VALUE;
        for (SequenceableLoader loader : this.loaders) {
            long loaderNextLoadPositionUs = loader.getNextLoadPositionUs();
            if (loaderNextLoadPositionUs == Long.MIN_VALUE) continue;
            nextLoadPositionUs = Math.min(nextLoadPositionUs, loaderNextLoadPositionUs);
        }
        return nextLoadPositionUs == Long.MAX_VALUE ? Long.MIN_VALUE : nextLoadPositionUs;
    }

    @Override
    public final void reevaluateBuffer(long positionUs) {
        for (SequenceableLoader loader : this.loaders) {
            loader.reevaluateBuffer(positionUs);
        }
    }

    @Override
    public boolean continueLoading(long positionUs) {
        boolean madeProgressThisIteration;
        boolean madeProgress = false;
        do {
            madeProgressThisIteration = false;
            long nextLoadPositionUs = this.getNextLoadPositionUs();
            if (nextLoadPositionUs == Long.MIN_VALUE) break;
            for (SequenceableLoader loader : this.loaders) {
                boolean isLoaderBehind;
                long loaderNextLoadPositionUs = loader.getNextLoadPositionUs();
                boolean bl = isLoaderBehind = loaderNextLoadPositionUs != Long.MIN_VALUE && loaderNextLoadPositionUs <= positionUs;
                if (loaderNextLoadPositionUs != nextLoadPositionUs && !isLoaderBehind) continue;
                madeProgressThisIteration |= loader.continueLoading(positionUs);
            }
            madeProgress |= madeProgressThisIteration;
        } while (madeProgressThisIteration);
        return madeProgress;
    }
}

