/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import java.util.ArrayList;

public abstract class BaseMediaSource
implements MediaSource {
    private final ArrayList<MediaSource.SourceInfoRefreshListener> sourceInfoListeners = new ArrayList(1);
    private final MediaSourceEventListener.EventDispatcher eventDispatcher = new MediaSourceEventListener.EventDispatcher();
    @Nullable
    private Looper looper;
    @Nullable
    private Timeline timeline;
    @Nullable
    private Object manifest;

    protected abstract void prepareSourceInternal(@Nullable TransferListener var1);

    protected abstract void releaseSourceInternal();

    protected final void refreshSourceInfo(Timeline timeline, @Nullable Object manifest) {
        this.timeline = timeline;
        this.manifest = manifest;
        for (MediaSource.SourceInfoRefreshListener listener : this.sourceInfoListeners) {
            listener.onSourceInfoRefreshed(this, timeline, manifest);
        }
    }

    protected final MediaSourceEventListener.EventDispatcher createEventDispatcher(@Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        return this.eventDispatcher.withParameters(0, mediaPeriodId, 0L);
    }

    protected final MediaSourceEventListener.EventDispatcher createEventDispatcher(MediaSource.MediaPeriodId mediaPeriodId, long mediaTimeOffsetMs) {
        Assertions.checkArgument(mediaPeriodId != null);
        return this.eventDispatcher.withParameters(0, mediaPeriodId, mediaTimeOffsetMs);
    }

    protected final MediaSourceEventListener.EventDispatcher createEventDispatcher(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, long mediaTimeOffsetMs) {
        return this.eventDispatcher.withParameters(windowIndex, mediaPeriodId, mediaTimeOffsetMs);
    }

    @Override
    public final void addEventListener(Handler handler, MediaSourceEventListener eventListener) {
        this.eventDispatcher.addEventListener(handler, eventListener);
    }

    @Override
    public final void removeEventListener(MediaSourceEventListener eventListener) {
        this.eventDispatcher.removeEventListener(eventListener);
    }

    @Override
    public final void prepareSource(MediaSource.SourceInfoRefreshListener listener, @Nullable TransferListener mediaTransferListener) {
        Looper looper = Looper.myLooper();
        Assertions.checkArgument(this.looper == null || this.looper == looper);
        this.sourceInfoListeners.add(listener);
        if (this.looper == null) {
            this.looper = looper;
            this.prepareSourceInternal(mediaTransferListener);
        } else if (this.timeline != null) {
            listener.onSourceInfoRefreshed(this, this.timeline, this.manifest);
        }
    }

    @Override
    public final void releaseSource(MediaSource.SourceInfoRefreshListener listener) {
        this.sourceInfoListeners.remove(listener);
        if (this.sourceInfoListeners.isEmpty()) {
            this.looper = null;
            this.timeline = null;
            this.manifest = null;
            this.releaseSourceInternal();
        }
    }
}

