/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.scheduler;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.os.Handler;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.scheduler.Requirements;
import com.google.android.exoplayer2.util.Util;

public final class RequirementsWatcher {
    private final Context context;
    private final Listener listener;
    private final Requirements requirements;
    private final Handler handler;
    private DeviceStatusChangeReceiver receiver;
    private int notMetRequirements;
    private CapabilityValidatedCallback networkCallback;

    public RequirementsWatcher(Context context, Listener listener, Requirements requirements) {
        this.context = context.getApplicationContext();
        this.listener = listener;
        this.requirements = requirements;
        this.handler = new Handler(Util.getLooper());
    }

    public int start() {
        this.notMetRequirements = this.requirements.getNotMetRequirements(this.context);
        IntentFilter filter = new IntentFilter();
        if (this.requirements.isNetworkRequired()) {
            if (Util.SDK_INT >= 23) {
                this.registerNetworkCallbackV23();
            } else {
                filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            }
        }
        if (this.requirements.isChargingRequired()) {
            filter.addAction("android.intent.action.ACTION_POWER_CONNECTED");
            filter.addAction("android.intent.action.ACTION_POWER_DISCONNECTED");
        }
        if (this.requirements.isIdleRequired()) {
            if (Util.SDK_INT >= 23) {
                filter.addAction("android.os.action.DEVICE_IDLE_MODE_CHANGED");
            } else {
                filter.addAction("android.intent.action.SCREEN_ON");
                filter.addAction("android.intent.action.SCREEN_OFF");
            }
        }
        this.receiver = new DeviceStatusChangeReceiver();
        this.context.registerReceiver((BroadcastReceiver)this.receiver, filter, null, this.handler);
        return this.notMetRequirements;
    }

    public void stop() {
        this.context.unregisterReceiver((BroadcastReceiver)this.receiver);
        this.receiver = null;
        if (this.networkCallback != null) {
            this.unregisterNetworkCallback();
        }
    }

    public Requirements getRequirements() {
        return this.requirements;
    }

    @TargetApi(value=23)
    private void registerNetworkCallbackV23() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        NetworkRequest request = new NetworkRequest.Builder().addCapability(16).build();
        this.networkCallback = new CapabilityValidatedCallback();
        connectivityManager.registerNetworkCallback(request, (ConnectivityManager.NetworkCallback)this.networkCallback);
    }

    private void unregisterNetworkCallback() {
        if (Util.SDK_INT >= 21) {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
            connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.networkCallback);
            this.networkCallback = null;
        }
    }

    private void checkRequirements() {
        int notMetRequirements = this.requirements.getNotMetRequirements(this.context);
        if (this.notMetRequirements != notMetRequirements) {
            this.notMetRequirements = notMetRequirements;
            this.listener.onRequirementsStateChanged(this, notMetRequirements);
        }
    }

    @RequiresApi(api=21)
    private final class CapabilityValidatedCallback
    extends ConnectivityManager.NetworkCallback {
        private CapabilityValidatedCallback() {
        }

        public void onAvailable(Network network) {
            this.onNetworkCallback();
        }

        public void onLost(Network network) {
            this.onNetworkCallback();
        }

        private void onNetworkCallback() {
            RequirementsWatcher.this.handler.post(() -> {
                if (RequirementsWatcher.this.networkCallback != null) {
                    RequirementsWatcher.this.checkRequirements();
                }
            });
        }
    }

    private class DeviceStatusChangeReceiver
    extends BroadcastReceiver {
        private DeviceStatusChangeReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (!this.isInitialStickyBroadcast()) {
                RequirementsWatcher.this.checkRequirements();
            }
        }
    }

    public static interface Listener {
        public void onRequirementsStateChanged(RequirementsWatcher var1, int var2);
    }
}

