/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.scheduler;

import android.annotation.TargetApi;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.PersistableBundle;
import androidx.annotation.RequiresPermission;
import com.google.android.exoplayer2.scheduler.Requirements;
import com.google.android.exoplayer2.scheduler.Scheduler;
import com.google.android.exoplayer2.util.Util;

@TargetApi(value=21)
public final class PlatformScheduler
implements Scheduler {
    private static final boolean DEBUG = false;
    private static final String TAG = "PlatformScheduler";
    private static final String KEY_SERVICE_ACTION = "service_action";
    private static final String KEY_SERVICE_PACKAGE = "service_package";
    private static final String KEY_REQUIREMENTS = "requirements";
    private final int jobId;
    private final ComponentName jobServiceComponentName;
    private final JobScheduler jobScheduler;

    @RequiresPermission(value="android.permission.RECEIVE_BOOT_COMPLETED")
    public PlatformScheduler(Context context, int jobId) {
        this.jobId = jobId;
        this.jobServiceComponentName = new ComponentName(context, PlatformSchedulerService.class);
        this.jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
    }

    @Override
    public boolean schedule(Requirements requirements, String servicePackage, String serviceAction) {
        JobInfo jobInfo = PlatformScheduler.buildJobInfo(this.jobId, this.jobServiceComponentName, requirements, serviceAction, servicePackage);
        int result = this.jobScheduler.schedule(jobInfo);
        PlatformScheduler.logd("Scheduling job: " + this.jobId + " result: " + result);
        return result == 1;
    }

    @Override
    public boolean cancel() {
        PlatformScheduler.logd("Canceling job: " + this.jobId);
        this.jobScheduler.cancel(this.jobId);
        return true;
    }

    private static JobInfo buildJobInfo(int jobId, ComponentName jobServiceComponentName, Requirements requirements, String serviceAction, String servicePackage) {
        JobInfo.Builder builder = new JobInfo.Builder(jobId, jobServiceComponentName);
        if (requirements.isUnmeteredNetworkRequired()) {
            builder.setRequiredNetworkType(2);
        } else if (requirements.isNetworkRequired()) {
            builder.setRequiredNetworkType(1);
        }
        builder.setRequiresDeviceIdle(requirements.isIdleRequired());
        builder.setRequiresCharging(requirements.isChargingRequired());
        builder.setPersisted(true);
        PersistableBundle extras = new PersistableBundle();
        extras.putString(KEY_SERVICE_ACTION, serviceAction);
        extras.putString(KEY_SERVICE_PACKAGE, servicePackage);
        extras.putInt(KEY_REQUIREMENTS, requirements.getRequirements());
        builder.setExtras(extras);
        return builder.build();
    }

    private static void logd(String message) {
    }

    public static final class PlatformSchedulerService
    extends JobService {
        public boolean onStartJob(JobParameters params) {
            PlatformScheduler.logd("PlatformSchedulerService started");
            PersistableBundle extras = params.getExtras();
            Requirements requirements = new Requirements(extras.getInt(PlatformScheduler.KEY_REQUIREMENTS));
            if (requirements.checkRequirements((Context)this)) {
                PlatformScheduler.logd("Requirements are met");
                String serviceAction = extras.getString(PlatformScheduler.KEY_SERVICE_ACTION);
                String servicePackage = extras.getString(PlatformScheduler.KEY_SERVICE_PACKAGE);
                Intent intent = new Intent(serviceAction).setPackage(servicePackage);
                PlatformScheduler.logd("Starting service action: " + serviceAction + " package: " + servicePackage);
                Util.startForegroundService((Context)this, intent);
            } else {
                PlatformScheduler.logd("Requirements are not met");
                this.jobFinished(params, true);
            }
            return false;
        }

        public boolean onStopJob(JobParameters params) {
            return false;
        }
    }
}

