/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.offline;

import android.net.Uri;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.offline.Downloader;
import com.google.android.exoplayer2.offline.DownloaderConstructorHelper;
import com.google.android.exoplayer2.offline.FilterableManifest;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSource;
import com.google.android.exoplayer2.upstream.cache.CacheKeyFactory;
import com.google.android.exoplayer2.upstream.cache.CacheUtil;
import com.google.android.exoplayer2.util.PriorityTaskManager;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class SegmentDownloader<M extends FilterableManifest<M>>
implements Downloader {
    private static final int BUFFER_SIZE_BYTES = 131072;
    private final DataSpec manifestDataSpec;
    private final Cache cache;
    private final CacheDataSource dataSource;
    private final CacheDataSource offlineDataSource;
    private final CacheKeyFactory cacheKeyFactory;
    private final PriorityTaskManager priorityTaskManager;
    private final ArrayList<StreamKey> streamKeys;
    private final AtomicBoolean isCanceled;

    public SegmentDownloader(Uri manifestUri, List<StreamKey> streamKeys, DownloaderConstructorHelper constructorHelper) {
        this.manifestDataSpec = SegmentDownloader.getCompressibleDataSpec(manifestUri);
        this.streamKeys = new ArrayList<StreamKey>(streamKeys);
        this.cache = constructorHelper.getCache();
        this.dataSource = constructorHelper.createCacheDataSource();
        this.offlineDataSource = constructorHelper.createOfflineCacheDataSource();
        this.cacheKeyFactory = constructorHelper.getCacheKeyFactory();
        this.priorityTaskManager = constructorHelper.getPriorityTaskManager();
        this.isCanceled = new AtomicBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void download(@Nullable Downloader.ProgressListener progressListener) throws IOException, InterruptedException {
        this.priorityTaskManager.add(-1000);
        try {
            Object manifest = this.getManifest(this.dataSource, this.manifestDataSpec);
            if (!this.streamKeys.isEmpty()) {
                manifest = (FilterableManifest)manifest.copy(this.streamKeys);
            }
            List<Segment> segments = this.getSegments(this.dataSource, manifest, false);
            int totalSegments = segments.size();
            int segmentsDownloaded = 0;
            long contentLength = 0L;
            long bytesDownloaded = 0L;
            for (int i = segments.size() - 1; i >= 0; --i) {
                Segment segment = segments.get(i);
                Pair<Long, Long> segmentLengthAndBytesDownloaded = CacheUtil.getCached(segment.dataSpec, this.cache, this.cacheKeyFactory);
                long segmentLength = (Long)segmentLengthAndBytesDownloaded.first;
                long segmentBytesDownloaded = (Long)segmentLengthAndBytesDownloaded.second;
                bytesDownloaded += segmentBytesDownloaded;
                if (segmentLength != -1L) {
                    if (segmentLength == segmentBytesDownloaded) {
                        ++segmentsDownloaded;
                        segments.remove(i);
                    }
                    if (contentLength == -1L) continue;
                    contentLength += segmentLength;
                    continue;
                }
                contentLength = -1L;
            }
            Collections.sort(segments);
            ProgressNotifier progressNotifier = null;
            if (progressListener != null) {
                progressNotifier = new ProgressNotifier(progressListener, contentLength, totalSegments, bytesDownloaded, segmentsDownloaded);
            }
            byte[] buffer = new byte[131072];
            for (int i = 0; i < segments.size(); ++i) {
                CacheUtil.cache(segments.get((int)i).dataSpec, this.cache, this.cacheKeyFactory, this.dataSource, buffer, this.priorityTaskManager, -1000, progressNotifier, this.isCanceled, true);
                if (progressNotifier == null) continue;
                progressNotifier.onSegmentDownloaded();
            }
        }
        finally {
            this.priorityTaskManager.remove(-1000);
        }
    }

    @Override
    public void cancel() {
        this.isCanceled.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void remove() throws InterruptedException {
        try {
            M manifest = this.getManifest(this.offlineDataSource, this.manifestDataSpec);
            List<Segment> segments = this.getSegments(this.offlineDataSource, manifest, true);
            for (int i = 0; i < segments.size(); ++i) {
                this.removeDataSpec(segments.get((int)i).dataSpec);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.removeDataSpec(this.manifestDataSpec);
        }
    }

    protected abstract M getManifest(DataSource var1, DataSpec var2) throws IOException;

    protected abstract List<Segment> getSegments(DataSource var1, M var2, boolean var3) throws InterruptedException, IOException;

    private void removeDataSpec(DataSpec dataSpec) {
        CacheUtil.remove(dataSpec, this.cache, this.cacheKeyFactory);
    }

    protected static DataSpec getCompressibleDataSpec(Uri uri) {
        return new DataSpec(uri, 0L, -1L, null, 1);
    }

    private static final class ProgressNotifier
    implements CacheUtil.ProgressListener {
        private final Downloader.ProgressListener progressListener;
        private final long contentLength;
        private final int totalSegments;
        private long bytesDownloaded;
        private int segmentsDownloaded;

        public ProgressNotifier(Downloader.ProgressListener progressListener, long contentLength, int totalSegments, long bytesDownloaded, int segmentsDownloaded) {
            this.progressListener = progressListener;
            this.contentLength = contentLength;
            this.totalSegments = totalSegments;
            this.bytesDownloaded = bytesDownloaded;
            this.segmentsDownloaded = segmentsDownloaded;
        }

        @Override
        public void onProgress(long requestLength, long bytesCached, long newBytesCached) {
            this.bytesDownloaded += newBytesCached;
            this.progressListener.onProgress(this.contentLength, this.bytesDownloaded, this.getPercentDownloaded());
        }

        public void onSegmentDownloaded() {
            ++this.segmentsDownloaded;
            this.progressListener.onProgress(this.contentLength, this.bytesDownloaded, this.getPercentDownloaded());
        }

        private float getPercentDownloaded() {
            if (this.contentLength != -1L && this.contentLength != 0L) {
                return (float)this.bytesDownloaded * 100.0f / (float)this.contentLength;
            }
            if (this.totalSegments != 0) {
                return (float)this.segmentsDownloaded * 100.0f / (float)this.totalSegments;
            }
            return -1.0f;
        }
    }

    protected static class Segment
    implements Comparable<Segment> {
        public final long startTimeUs;
        public final DataSpec dataSpec;

        public Segment(long startTimeUs, DataSpec dataSpec) {
            this.startTimeUs = startTimeUs;
            this.dataSpec = dataSpec;
        }

        @Override
        public int compareTo(@NonNull Segment other) {
            return Util.compareLong(this.startTimeUs, other.startTimeUs);
        }
    }
}

