/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.offline;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.DataSink;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DummyDataSource;
import com.google.android.exoplayer2.upstream.FileDataSourceFactory;
import com.google.android.exoplayer2.upstream.PriorityDataSourceFactory;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSinkFactory;
import com.google.android.exoplayer2.upstream.cache.CacheDataSource;
import com.google.android.exoplayer2.upstream.cache.CacheDataSourceFactory;
import com.google.android.exoplayer2.upstream.cache.CacheKeyFactory;
import com.google.android.exoplayer2.upstream.cache.CacheUtil;
import com.google.android.exoplayer2.util.PriorityTaskManager;

public final class DownloaderConstructorHelper {
    private final Cache cache;
    @Nullable
    private final CacheKeyFactory cacheKeyFactory;
    @Nullable
    private final PriorityTaskManager priorityTaskManager;
    private final CacheDataSourceFactory onlineCacheDataSourceFactory;
    private final CacheDataSourceFactory offlineCacheDataSourceFactory;

    public DownloaderConstructorHelper(Cache cache, DataSource.Factory upstreamFactory) {
        this(cache, upstreamFactory, null, null, null);
    }

    public DownloaderConstructorHelper(Cache cache, DataSource.Factory upstreamFactory, @Nullable DataSource.Factory cacheReadDataSourceFactory, @Nullable DataSink.Factory cacheWriteDataSinkFactory, @Nullable PriorityTaskManager priorityTaskManager) {
        this(cache, upstreamFactory, cacheReadDataSourceFactory, cacheWriteDataSinkFactory, priorityTaskManager, null);
    }

    public DownloaderConstructorHelper(Cache cache, DataSource.Factory upstreamFactory, @Nullable DataSource.Factory cacheReadDataSourceFactory, @Nullable DataSink.Factory cacheWriteDataSinkFactory, @Nullable PriorityTaskManager priorityTaskManager, @Nullable CacheKeyFactory cacheKeyFactory) {
        DataSource.Factory readDataSourceFactory;
        if (priorityTaskManager != null) {
            upstreamFactory = new PriorityDataSourceFactory(upstreamFactory, priorityTaskManager, -1000);
        }
        DataSource.Factory factory = readDataSourceFactory = cacheReadDataSourceFactory != null ? cacheReadDataSourceFactory : new FileDataSourceFactory();
        if (cacheWriteDataSinkFactory == null) {
            cacheWriteDataSinkFactory = new CacheDataSinkFactory(cache, 0x500000L);
        }
        this.onlineCacheDataSourceFactory = new CacheDataSourceFactory(cache, upstreamFactory, readDataSourceFactory, cacheWriteDataSinkFactory, 1, null, cacheKeyFactory);
        this.offlineCacheDataSourceFactory = new CacheDataSourceFactory(cache, DummyDataSource.FACTORY, readDataSourceFactory, null, 1, null, cacheKeyFactory);
        this.cache = cache;
        this.priorityTaskManager = priorityTaskManager;
        this.cacheKeyFactory = cacheKeyFactory;
    }

    public Cache getCache() {
        return this.cache;
    }

    public CacheKeyFactory getCacheKeyFactory() {
        return this.cacheKeyFactory != null ? this.cacheKeyFactory : CacheUtil.DEFAULT_CACHE_KEY_FACTORY;
    }

    public PriorityTaskManager getPriorityTaskManager() {
        return this.priorityTaskManager != null ? this.priorityTaskManager : new PriorityTaskManager();
    }

    public CacheDataSource createCacheDataSource() {
        return this.onlineCacheDataSourceFactory.createDataSource();
    }

    public CacheDataSource createOfflineCacheDataSource() {
        return this.offlineCacheDataSourceFactory.createDataSource();
    }
}

